/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import javax.media.Format;

class FormatTable {
    public Format[] keys;
    public Format[][] table;
    public int[] hits;
    public int last;

    public FormatTable(int size) {
        this.keys = new Format[size];
        this.table = new Format[size][];
        this.hits = new int[size];
        this.last = 0;
    }

    Format[] get(Format input) {
        Format[] res = null;
        int i = 0;
        while (i < this.last) {
            if (res == null && this.keys[i].matches(input)) {
                res = this.table[i];
                this.hits[i] = this.keys.length;
            } else {
                this.hits[i] = this.hits[i] - 1;
            }
            ++i;
        }
        return res;
    }

    public void save(Format input, Format[] supported) {
        int idx = this.last >= this.keys.length ? this.findLeastHit() : this.last++;
        this.keys[idx] = input;
        this.table[idx] = supported;
        this.hits[idx] = this.keys.length;
    }

    public int findLeastHit() {
        int min = this.hits[0];
        int idx = 0;
        int i = 1;
        while (i < this.last) {
            if (this.hits[i] < min) {
                min = this.hits[i];
                idx = i;
            }
            ++i;
        }
        return idx;
    }
}

