/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import java.util.Collection;
import java.util.Comparator;

class HuffmanNode {
    int tag;
    int tagLength;
    int shift;
    int dataLength;
    boolean absolute;
    private int frequency;
    private HuffmanNode child0;
    private HuffmanNode child1;
    private HuffmanNode mergeNode;
    private boolean merged;
    private boolean unmergeable;
    private boolean cleared;
    static FrequencyComparator frequencyComparator = new FrequencyComparator();
    static TagLengthComparator tagLengthComparator = new TagLengthComparator();

    void clear() {
        this.tag = -1;
        this.tagLength = -1;
        this.shift = -1;
        this.dataLength = -1;
        this.absolute = false;
        this.child0 = null;
        this.child1 = null;
        this.mergeNode = null;
        this.frequency = 0;
        this.merged = false;
        this.unmergeable = false;
        this.cleared = true;
    }

    HuffmanNode() {
        this.clear();
    }

    HuffmanNode(int n, int n2, boolean bl) {
        this();
        this.set(n, n2, bl);
    }

    final void set(int n, int n2, boolean bl) {
        this.dataLength = n;
        this.shift = n2;
        this.absolute = bl;
        this.cleared = false;
    }

    final boolean cleared() {
        return this.cleared;
    }

    final void addCount() {
        ++this.frequency;
    }

    final boolean hasCount() {
        return this.frequency > 0;
    }

    final boolean tokenEquals(HuffmanNode huffmanNode) {
        return this.absolute == huffmanNode.absolute && this.dataLength == huffmanNode.dataLength && this.shift == huffmanNode.shift;
    }

    void addChildren(HuffmanNode huffmanNode, HuffmanNode huffmanNode2) {
        this.child0 = huffmanNode;
        this.child1 = huffmanNode2;
        this.frequency = huffmanNode.frequency + huffmanNode2.frequency;
    }

    void collectLeaves(int n, int n2, Collection collection) {
        if (this.child0 == null) {
            this.tag = n;
            this.tagLength = n2;
            collection.add(this);
        } else {
            this.child0.collectLeaves(n << 1 | 0, n2 + 1, collection);
            this.child1.collectLeaves(n << 1 | 1, n2 + 1, collection);
        }
    }

    boolean mergeInto(HuffmanNode huffmanNode) {
        if (this.absolute == huffmanNode.absolute) {
            if (this.dataLength > huffmanNode.dataLength) {
                huffmanNode.dataLength = this.dataLength;
            }
            if (this.shift < huffmanNode.shift) {
                huffmanNode.shift = this.shift;
            }
            huffmanNode.frequency += this.frequency;
            this.mergeNode = huffmanNode;
            this.merged = true;
            return true;
        }
        return false;
    }

    int incrementLength() {
        if (this.shift > 0) {
            --this.shift;
        } else {
            ++this.dataLength;
        }
        return this.dataLength - this.shift;
    }

    final boolean merged() {
        return this.merged;
    }

    final HuffmanNode getMergeNode() {
        return this.mergeNode;
    }

    void setUnmergeable() {
        this.unmergeable = true;
    }

    final boolean unmergeable() {
        return this.unmergeable;
    }

    public String toString() {
        return "shift " + this.shift + " data length " + this.dataLength + (this.absolute ? " absolute " : " relative ") + "\ntag 0x" + Integer.toHexString(this.tag) + " tag length " + this.tagLength + "\nfrequency: " + this.frequency;
    }

    static class TagLengthComparator
    implements Comparator {
        TagLengthComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((HuffmanNode)object2).tagLength - ((HuffmanNode)object).tagLength;
        }
    }

    static class FrequencyComparator
    implements Comparator {
        FrequencyComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((HuffmanNode)object).frequency - ((HuffmanNode)object2).frequency;
        }
    }
}

