/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.pickfast;

import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickTool {
    public static final int TYPE_SHAPE3D = 1;
    public static final int TYPE_MORPH = 2;
    public static final int TYPE_PRIMITIVE = 4;
    public static final int TYPE_LINK = 8;
    public static final int TYPE_GROUP = 16;
    public static final int TYPE_TRANSFORM_GROUP = 32;
    public static final int TYPE_BRANCH_GROUP = 64;
    public static final int TYPE_SWITCH = 128;
    private static final int ALL_FLAGS = 127;
    private final boolean debug = false;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 1;
    int flags = 2;

    public PickTool(BranchGroup branchGroup) {
        this.pickRootBG = branchGroup;
    }

    public PickTool(Locale locale) {
        this.pickRootL = locale;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public Locale getLocale() {
        return this.pickRootL;
    }

    public void setShape(PickShape pickShape, Point3d point3d) {
        this.pickShape = pickShape;
        this.start = point3d;
        this.userDefineShape = pickShape != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d point3d) {
        this.pickShape = new PickBounds(bounds);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setMode(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setFlags(int n) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException();
        }
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setShapeRay(Point3d point3d, Vector3d vector3d) {
        this.pickShape = new PickRay(point3d, vector3d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d point3d, Point3d point3d2) {
        this.pickShape = new PickSegment(point3d, point3d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickCylinderSegment(point3d, point3d2, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickCylinderRay(point3d, vector3d, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickConeSegment(point3d, point3d2, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickConeRay(point3d, vector3d, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickInfo[] pickAll() {
        PickInfo[] pickInfoArray = null;
        if (this.pickRootBG != null) {
            pickInfoArray = this.pickRootBG.pickAll(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfoArray = this.pickRootL.pickAll(this.mode, this.flags, this.pickShape);
        }
        return pickInfoArray;
    }

    public PickInfo pickAny() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickAny(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickAny(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public PickInfo[] pickAllSorted() {
        PickInfo[] pickInfoArray = null;
        if (this.pickRootBG != null) {
            pickInfoArray = this.pickRootBG.pickAllSorted(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfoArray = this.pickRootL.pickAllSorted(this.mode, this.flags, this.pickShape);
        }
        return pickInfoArray;
    }

    public PickInfo pickClosest() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickClosest(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickClosest(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public Node getNode(PickInfo pickInfo, int n) {
        if (pickInfo == null) {
            return null;
        }
        SceneGraphPath sceneGraphPath = pickInfo.getSceneGraphPath();
        Node node = pickInfo.getNode();
        if (node instanceof Shape3D && (n & 1) != 0) {
            return node;
        }
        if (node instanceof Morph && (n & 2) != 0) {
            return node;
        }
        for (int i = sceneGraphPath.nodeCount() - 1; i >= 0; --i) {
            Node node2 = sceneGraphPath.getNode(i);
            if (node2 instanceof Primitive && (n & 4) != 0) {
                return node2;
            }
            if (node2 instanceof Link && (n & 8) != 0) {
                return node2;
            }
            if (node2 instanceof Switch && (n & 0x80) != 0) {
                return node2;
            }
            if (node2 instanceof TransformGroup && (n & 0x20) != 0) {
                return node2;
            }
            if (node2 instanceof BranchGroup && (n & 0x40) != 0) {
                return node2;
            }
            if (!(node2 instanceof Group) || (n & 0x10) == 0) continue;
            return node2;
        }
        return null;
    }
}

