/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class UnfocusableToolBar
extends JToolBar {
    public UnfocusableToolBar() {
        this.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                UnfocusableToolBar.this.updateToolBarButtons();
            }
        });
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                UnfocusableToolBar.this.updateToolBarButtons();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
            }
        });
    }

    private void updateToolBarButtons() {
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        JComponent jComponent = null;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent2 = (JComponent)this.getComponentAtIndex(i);
            jComponent2.setFocusable(false);
            if (!(jComponent2 instanceof AbstractButton)) {
                jComponent = null;
                continue;
            }
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) continue;
            Component component = i < n - 1 ? this.getComponentAtIndex(i + 1) : null;
            jComponent2.putClientProperty("JButton.buttonType", "segmentedTextured");
            if (jComponent == null && !(component instanceof AbstractButton)) {
                jComponent2.putClientProperty("JButton.segmentPosition", "only");
            } else if (jComponent == null) {
                jComponent2.putClientProperty("JButton.segmentPosition", componentOrientation.isLeftToRight() ? "first" : "last");
            } else if (!(component instanceof AbstractButton)) {
                jComponent2.putClientProperty("JButton.segmentPosition", componentOrientation.isLeftToRight() ? "last" : "first");
            } else {
                jComponent2.putClientProperty("JButton.segmentPosition", "middle");
            }
            jComponent = jComponent2;
        }
    }
}

