/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SSLEngineManager {
    private SSLEngine engine = null;
    private int appBufSize;
    private int pktBufSize;
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private Executor executor;
    private FdInStream in;
    private FdOutStream os;

    public SSLEngineManager(SSLEngine sSLEngine, FdInStream fdInStream, FdOutStream fdOutStream) throws IOException {
        this.in = fdInStream;
        this.os = fdOutStream;
        this.engine = sSLEngine;
        this.executor = Executors.newSingleThreadExecutor();
        this.pktBufSize = this.engine.getSession().getPacketBufferSize();
        this.appBufSize = this.engine.getSession().getApplicationBufferSize();
        this.myAppData = ByteBuffer.allocate(Math.max(this.appBufSize, this.os.getBufSize()));
        this.myNetData = ByteBuffer.allocate(this.pktBufSize);
        this.peerAppData = ByteBuffer.allocate(this.appBufSize);
        this.peerNetData = ByteBuffer.allocate(this.pktBufSize);
    }

    public void doHandshake() throws Exception {
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.peerNetData.flip();
                    SSLEngineResult sSLEngineResult = this.engine.unwrap(this.peerNetData, this.peerAppData);
                    this.peerNetData.compact();
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (sSLEngineResult.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            int n = Math.min(this.peerNetData.remaining(), this.in.getBufSize());
                            int n2 = this.in.check(1, n, true);
                            int n3 = this.peerNetData.position();
                            this.in.readBytes(this.peerNetData.array(), n3, n2);
                            this.peerNetData.position(n3 + n2);
                            this.peerNetData.flip();
                            this.peerNetData.compact();
                            break;
                        }
                        case OK: {
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeInbound();
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    this.myNetData.clear();
                    SSLEngineResult sSLEngineResult = this.engine.wrap(this.myAppData, this.myNetData);
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            this.myAppData.compact();
                            this.myNetData.flip();
                            this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
                            this.os.flush();
                            this.myNetData.clear();
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeOutbound();
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.executeTasks();
                }
            }
            handshakeStatus = this.engine.getHandshakeStatus();
        }
    }

    private void executeTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            this.executor.execute(runnable);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.peerNetData.flip();
        SSLEngineResult sSLEngineResult = this.engine.unwrap(this.peerNetData, this.peerAppData);
        this.peerNetData.compact();
        switch (sSLEngineResult.getStatus()) {
            case OK: {
                n3 = Math.min(n2, sSLEngineResult.bytesProduced());
                this.peerAppData.flip();
                this.peerAppData.get(byArray, n, n3);
                this.peerAppData.compact();
                break;
            }
            case BUFFER_UNDERFLOW: {
                int n4 = this.peerNetData.position();
                int n5 = this.peerNetData.remaining();
                int n6 = this.in.check(1, this.in.getBufSize(), false);
                if (n6 < n5) {
                    n6 = this.in.check(1, Math.min(n5, this.in.getBufSize()), true);
                }
                this.in.readBytes(this.peerNetData.array(), n4, Math.min(n5, n6));
                this.peerNetData.position(n4 + Math.min(n5, n6));
                break;
            }
            case CLOSED: {
                this.engine.closeInbound();
            }
        }
        return n3;
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.myAppData.put(byArray, n, n2);
        this.myAppData.flip();
        while (this.myAppData.hasRemaining()) {
            SSLEngineResult sSLEngineResult = this.engine.wrap(this.myAppData, this.myNetData);
            n3 += sSLEngineResult.bytesConsumed();
            switch (sSLEngineResult.getStatus()) {
                case OK: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.myNetData.flip();
                    this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
                    this.os.flush();
                    this.myNetData.clear();
                    break;
                }
                case CLOSED: {
                    this.engine.closeOutbound();
                }
            }
        }
        this.myAppData.clear();
        this.myNetData.flip();
        this.os.writeBytes(this.myNetData.array(), 0, this.myNetData.remaining());
        this.os.flush();
        this.myNetData.clear();
        return n3;
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }
}

