/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rdr.SystemException;
import com.tigervnc.rdr.TLSInStream;
import com.tigervnc.rdr.TLSOutStream;
import com.tigervnc.rdr.WarningException;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.UserPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;

public class CSecurityTLS
extends CSecurity {
    public static StringParameter X509CA = new StringParameter("X509CA", "X509 CA certificate", "", Configuration.ConfigurationObject.ConfViewer);
    public static StringParameter X509CRL = new StringParameter("X509CRL", "X509 CRL file", "", Configuration.ConfigurationObject.ConfViewer);
    protected CConnection client;
    private SSLContext ctx;
    private SSLEngine engine;
    private SSLEngineManager manager;
    private boolean anon;
    private String cafile;
    private String crlfile;
    private FdInStream is;
    private FdOutStream os;
    static LogWriter vlog = new LogWriter("CSecurityTLS");

    private void initGlobal() {
        try {
            this.ctx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception(noSuchAlgorithmException.toString());
        }
    }

    public CSecurityTLS(boolean bl) {
        this.anon = bl;
        this.manager = null;
        CSecurityTLS.setDefaults();
        this.cafile = X509CA.getData();
        this.crlfile = X509CRL.getData();
    }

    public static String getDefaultCA() {
        if (UserPreferences.get("viewer", "x509ca") != null) {
            return UserPreferences.get("viewer", "x509ca");
        }
        return FileUtils.getVncHomeDir() + "x509_ca.pem";
    }

    public static String getDefaultCRL() {
        if (UserPreferences.get("viewer", "x509crl") != null) {
            return UserPreferences.get("viewer", "x509crl");
        }
        return FileUtils.getVncHomeDir() + "x509_crl.pem";
    }

    public static void setDefaults() {
        if (new File(CSecurityTLS.getDefaultCA()).exists()) {
            X509CA.setDefaultStr(CSecurityTLS.getDefaultCA());
        }
        if (new File(CSecurityTLS.getDefaultCRL()).exists()) {
            X509CRL.setDefaultStr(CSecurityTLS.getDefaultCRL());
        }
    }

    @Override
    public boolean processMsg(CConnection cConnection) {
        this.is = (FdInStream)cConnection.getInStream();
        this.os = (FdOutStream)cConnection.getOutStream();
        this.client = cConnection;
        this.initGlobal();
        if (this.manager == null) {
            if (!this.is.checkNoWait(1)) {
                return false;
            }
            if (this.is.readU8() == 0) {
                int n = this.is.readU32();
                String string = n == 1 || n == 2 ? this.is.readString() : new String("Authentication failure (protocol error)");
                throw new AuthFailureException(string);
            }
            this.setParam();
        }
        try {
            this.manager = new SSLEngineManager(this.engine, this.is, this.os);
            this.manager.doHandshake();
        }
        catch (java.lang.Exception exception) {
            throw new SystemException(exception.toString());
        }
        cConnection.setStreams(new TLSInStream(this.is, this.manager), new TLSOutStream(this.os, this.manager));
        return true;
    }

    private void setParam() {
        int n;
        TrustManager[] trustManagerArray;
        if (this.anon) {
            try {
                this.ctx.init(null, null, null);
            }
            catch (KeyManagementException keyManagementException) {
                throw new AuthFailureException(keyManagementException.toString());
            }
        }
        try {
            trustManagerArray = new TrustManager[]{new MyX509TrustManager()};
            this.ctx.init(null, trustManagerArray, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AuthFailureException(generalSecurityException.toString());
        }
        trustManagerArray = this.ctx.getSocketFactory();
        this.engine = this.ctx.createSSLEngine(this.client.getServerName(), this.client.getServerPort());
        this.engine.setUseClientMode(true);
        String[] stringArray = this.engine.getSupportedProtocols();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].matches("TLS.*")) continue;
            arrayList.add(stringArray[n]);
        }
        this.engine.setEnabledProtocols(arrayList.toArray(new String[0]));
        if (this.anon) {
            stringArray = this.engine.getSupportedCipherSuites();
            arrayList = new ArrayList();
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].matches("TLS_ECDH_anon.*")) continue;
                arrayList.add(stringArray[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].matches("TLS_DH_anon.*")) continue;
                arrayList.add(stringArray[n]);
            }
            this.engine.setEnabledCipherSuites(arrayList.toArray(new String[0]));
        } else {
            this.engine.setEnabledCipherSuites(this.engine.getSupportedCipherSuites());
        }
    }

    @Override
    public final int getType() {
        return this.anon ? 257 : 260;
    }

    @Override
    public final String description() {
        return this.anon ? "TLS Encryption without VncAuth" : "X509 Encryption without VncAuth";
    }

    class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager tm;

        MyX509TrustManager() throws GeneralSecurityException {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                File file;
                keyStore.load(null, null);
                String string = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string);
                trustManagerFactory.init((KeyStore)null);
                for (TrustManager object22 : trustManagerFactory.getTrustManagers()) {
                    if (!(object22 instanceof X509TrustManager)) continue;
                    for (X509Certificate x509Certificate : ((X509TrustManager)object22).getAcceptedIssuers()) {
                        keyStore.setCertificateEntry(x509Certificate.getSubjectX500Principal().getName(), x509Certificate);
                    }
                }
                File file2 = new File(FileUtils.getVncHomeDir() + "x509_savedcerts.pem");
                if (file2.exists() && file2.canRead()) {
                    MyFileInputStream myFileInputStream = new MyFileInputStream(file2);
                    Collection<? extends Certificate> collection = certificateFactory.generateCertificates(myFileInputStream);
                    for (Certificate certificate : collection) {
                        String string2 = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                        keyStore.setCertificateEntry(string2, (X509Certificate)certificate);
                    }
                }
                if ((file = new File(CSecurityTLS.this.cafile)).exists() && file.canRead()) {
                    MyFileInputStream myFileInputStream = new MyFileInputStream(file);
                    Collection<? extends Certificate> collection = certificateFactory.generateCertificates(myFileInputStream);
                    for (Certificate certificate : collection) {
                        String string3 = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                        keyStore.setCertificateEntry(string3, (X509Certificate)certificate);
                    }
                }
                PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
                File file3 = new File(CSecurityTLS.this.crlfile);
                if (!file3.exists() || !file3.canRead()) {
                    pKIXBuilderParameters.setRevocationEnabled(false);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(CSecurityTLS.this.crlfile);
                    Collection<? extends CRL> collection = certificateFactory.generateCRLs(fileInputStream);
                    CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(collection);
                    CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
                    pKIXBuilderParameters.addCertStore(certStore);
                    pKIXBuilderParameters.setRevocationEnabled(true);
                }
                trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
                this.tm = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            }
            catch (java.lang.Exception exception) {
                throw new Exception(exception.getMessage());
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.tm.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
                this.verifyHostname(x509CertificateArray[0]);
                this.tm.checkServerTrusted(x509CertificateArray, string);
            }
            catch (java.lang.Exception exception) {
                if (exception.getCause() instanceof CertPathBuilderException) {
                    Object[] objectArray = new Object[]{"YES", "NO"};
                    X509Certificate x509Certificate = x509CertificateArray[0];
                    messageDigest.update(x509Certificate.getEncoded());
                    String string2 = DatatypeConverter.printHexBinary((byte[])messageDigest.digest());
                    string2 = string2.replaceAll("..(?!$)", "$0 ");
                    int n = JOptionPane.showOptionDialog(null, "This certificate has been signed by an unknown authority\n\n  Subject: " + x509Certificate.getSubjectX500Principal().getName() + "\n  Issuer: " + x509Certificate.getIssuerX500Principal().getName() + "\n  Serial Number: " + x509Certificate.getSerialNumber() + "\n  Version: " + x509Certificate.getVersion() + "\n  Signature Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "\n  Not Valid Before: " + x509Certificate.getNotBefore() + "\n  Not Valid After: " + x509Certificate.getNotAfter() + "\n  SHA1 Fingerprint: " + string2 + "\n\nDo you want to save it and continue?", "Certificate Issuer Unknown", 0, 2, null, objectArray, objectArray[0]);
                    if (n == 0) {
                        Collection<? extends Certificate> collection = null;
                        File file = new File(FileUtils.getVncHomeDir());
                        File file2 = new File(file, "x509_savedcerts.pem");
                        try {
                            if (!file.exists()) {
                                file.mkdir();
                            }
                            if (!file2.createNewFile()) {
                                vlog.error("Certificate save failed.");
                                return;
                            }
                        }
                        catch (java.lang.Exception exception2) {
                            vlog.error("Certificate save failed: " + exception2.getMessage());
                            return;
                        }
                        MyFileInputStream myFileInputStream = new MyFileInputStream(file2);
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        collection = certificateFactory.generateCertificates(myFileInputStream);
                        for (int i = 0; i < x509CertificateArray.length; ++i) {
                            if (collection != null && collection.contains(x509CertificateArray[i])) continue;
                            byte[] byArray = x509CertificateArray[i].getEncoded();
                            String string3 = DatatypeConverter.printBase64Binary((byte[])byArray);
                            string3 = string3.replaceAll("(.{64})", "$1\n");
                            FileWriter fileWriter = null;
                            try {
                                fileWriter = new FileWriter(file2.getAbsolutePath(), true);
                                fileWriter.write("-----BEGIN CERTIFICATE-----\n");
                                fileWriter.write(string3 + "\n");
                                fileWriter.write("-----END CERTIFICATE-----\n");
                                continue;
                            }
                            catch (IOException iOException) {
                                throw new Exception(iOException.getMessage());
                            }
                            finally {
                                try {
                                    if (fileWriter != null) {
                                        fileWriter.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    throw new Exception(iOException.getMessage());
                                }
                            }
                        }
                    }
                    throw new WarningException("Peer certificate verification failed.");
                }
                throw new SystemException(exception.getMessage());
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        private void verifyHostname(X509Certificate x509Certificate) throws CertificateParsingException {
            try {
                int n;
                Object object;
                Object[] objectArray;
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection == null) {
                    objectArray = x509Certificate.getSubjectX500Principal().getName();
                    object = new LdapName((String)objectArray);
                    for (Rdn rdn : ((LdapName)object).getRdns()) {
                        String string;
                        if (!rdn.getType().equalsIgnoreCase("CN") || !(string = ((CConn)CSecurityTLS.this.client).getSocket().getPeerName().toLowerCase()).equals(((String)rdn.getValue()).toLowerCase())) continue;
                        return;
                    }
                } else {
                    objectArray = collection.iterator();
                    while (objectArray.hasNext()) {
                        String string;
                        object = (List)objectArray.next();
                        if (!((Integer)object.get(0) == 2 ? (string = ((CConn)CSecurityTLS.this.client).getSocket().getPeerName().toLowerCase()).equals(((String)object.get(1)).toLowerCase()) : (Integer)object.get(0) == 7 && (string = ((CConn)CSecurityTLS.this.client).getSocket().getPeerAddress()).equals(((String)object.get(1)).toLowerCase()))) continue;
                        return;
                    }
                }
                if ((n = JOptionPane.showOptionDialog(null, "Hostname verification failed. Do you want to continue?", "Hostname Verification Failure", 0, 2, null, objectArray = new Object[]{"YES", "NO"}, objectArray[0])) != 0) {
                    throw new WarningException("Hostname verification failed.");
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new SystemException(certificateParsingException.getMessage());
            }
            catch (InvalidNameException invalidNameException) {
                throw new SystemException(invalidNameException.getMessage());
            }
        }

        private class MyFileInputStream
        extends InputStream {
            ByteBuffer buf;

            public MyFileInputStream(String string) {
                this(new File(string));
            }

            public MyFileInputStream(File file) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((object = bufferedReader.readLine()) != null) {
                        if (((String)object).trim().length() <= 0) continue;
                        stringBuffer.append((String)object + "\n");
                    }
                }
                catch (java.lang.Exception exception) {
                    throw new Exception(exception.toString());
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new Exception(iOException.getMessage());
                    }
                }
                object = Charset.forName("UTF-8");
                this.buf = ByteBuffer.wrap(stringBuffer.toString().getBytes((Charset)object));
                this.buf.limit(this.buf.capacity());
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                n2 = Math.min(n2, this.buf.remaining());
                this.buf.get(byArray, n, n2);
                return n2;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }
        }
    }
}

