/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;

public class CopyRectDecoder
extends Decoder {
    public CopyRectDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ConnParams connParams, OutStream outStream) {
        outStream.copyBytes(inStream, 4);
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ConnParams connParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        int n2 = memInStream.readU16();
        int n3 = memInStream.readU16();
        modifiablePixelBuffer.copyRect(rect, new Point(rect.tl.x - n2, rect.tl.y - n3));
    }
}

