/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;

public class StructuredUnitType
extends NumericalType {
    protected Constant.Structured minimum;
    protected Constant.Structured maximum;

    public StructuredUnitType(Constant.Structured minimum, Constant.Structured maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
        if (minimum == null || maximum == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
    }

    public Constant.Structured getMinimum() {
        return this.minimum;
    }

    public Constant.Structured getMaximum() {
        return this.maximum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minimum);
        sb.append("..");
        sb.append(this.maximum);
        sb.append(" [");
        sb.append(this.unit == null ? "null" : this.unit.getScopedName((Container)null));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isAbstract() {
        Unit unit = this.getUnit();
        return unit != null && unit.isAbstract();
    }

    @Override
    public void setUnit(Unit unit) throws PropertyVetoException {
        Unit oldValue = this.unit;
        Unit newValue = unit;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isAbstract()) {
            throw new IllegalArgumentException(StructuredUnitType.formatMessage("err_structuredUnitType_abstractUnit", newValue.toString()));
        }
        this.fireVetoableChange("unit", oldValue, newValue);
        this.unit = newValue;
        this.firePropertyChange("unit", oldValue, newValue);
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public void setReferenceSystem(RefSystemRef referenceSystem) throws PropertyVetoException {
        RefSystemRef oldValue = this.referenceSystem;
        RefSystemRef newValue = referenceSystem;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("referenceSystem", oldValue, newValue);
        this.referenceSystem = newValue;
        this.firePropertyChange("referenceSystem", oldValue, newValue);
    }

    @Override
    public RefSystemRef getReferenceSystem() {
        return this.referenceSystem;
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        Unit generalUnit;
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof StructuredUnitType)) {
            throw new IllegalArgumentException(rsrc.getString("err_structuredUnitType_extOther"));
        }
        StructuredUnitType general = (StructuredUnitType)wantToExtend;
        if (this.isAbstract() && !general.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_structuredUnitType_abstractExtConcrete"));
        }
        if (this.unit != null && (generalUnit = general.getUnit()) != null && !this.unit.isExtendingIndirectly(generalUnit)) {
            throw new IllegalArgumentException(StructuredUnitType.formatMessage("err_structuredUnitType_unitNotExtBaseUnit", this.unit.toString(), generalUnit.toString()));
        }
    }

    @Override
    public StructuredUnitType clone() {
        return (StructuredUnitType)super.clone();
    }
}

