/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iligml;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iox.IoxException;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IligmlWriterAlt {
    private XMLStreamWriter xout = null;
    private ViewableProperties mapping = null;
    private HashMap nameMapping = null;
    private HashSet unkClsv = new HashSet();
    public static final String iligmlBase = "http://www.interlis.ch/INTERLIS2.3/GML32";
    public static final String xmlns_ili = "http://www.interlis.ch/INTERLIS2.3/GML32/INTERLIS";
    public static final String xmlns_gml = "http://www.opengis.net/gml/3.2";
    public static final String xmlns_xlink = "http://www.w3.org/1999/xlink";
    public static final String xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
    private static String nl = null;
    private String lastBasketNs = null;
    private int tid = 1;

    public IligmlWriterAlt(OutputStreamWriter buffer, ViewableProperties mapping1, HashMap nameMapping, String version) throws IoxException {
        this.mapping = mapping1;
        this.nameMapping = nameMapping;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.xout = outputFactory.createXMLStreamWriter(new BufferedWriter(buffer));
            String encoding = Charset.forName(buffer.getEncoding()).name();
            this.xout.writeStartDocument(encoding, "1.0");
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    public XMLStreamWriter getXout() {
        return this.xout;
    }

    public void close() throws IoxException {
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException(ex);
            }
            this.xout = null;
        }
    }

    public void flush() throws IoxException {
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException(ex);
            }
        }
    }

    public void newline() throws IoxException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        try {
            this.xout.writeCharacters(nl);
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    public void writeStartTransfer(String sender, String comment, XtfModel[] models) throws IoxException {
        try {
            this.xout.setPrefix("ili", xmlns_ili);
            this.xout.writeStartElement(xmlns_ili, "TRANSFER");
            this.xout.writeNamespace("ili", xmlns_ili);
            this.xout.writeNamespace("gml", xmlns_gml);
            this.xout.setPrefix("gml", xmlns_gml);
            this.xout.writeNamespace("xlink", xmlns_xlink);
            this.xout.setPrefix("xlink", xmlns_xlink);
            this.xout.writeNamespace("xsi", xmlns_xsi);
            this.xout.setPrefix("xsi", xmlns_xsi);
            int i = 0;
            while (i < models.length) {
                XtfModel model = models[i];
                if (i + 1 == models.length) {
                    this.xout.writeDefaultNamespace("http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                    this.xout.setDefaultNamespace("http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                } else {
                    this.xout.writeNamespace(model.getName(), "http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                    this.xout.setPrefix(model.getName(), "http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                }
                ++i;
            }
            this.xout.writeAttribute(xmlns_gml, "id", this.getNewTid());
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    public void writeEndTransfer() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.xout.writeEndDocument();
            this.xout.flush();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
        this.xout = null;
    }

    public void writeStartBasket(String type, String bid) throws IoxException {
        this.writeStartBasket(type, bid, 0, 0, null, null, null);
    }

    public void writeStartBasket(String type, String bid, int consistency, int kind, String startstate, String endstate, String[] topicv) throws IoxException {
        try {
            this.xout.writeStartElement(xmlns_ili, "baskets");
            this.newline();
            this.lastBasketNs = this.getXmlNs(type);
            this.xout.writeStartElement(this.lastBasketNs, this.getXmlName(type));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(bid));
            if (kind != 0 && kind != 2) {
                throw new IllegalArgumentException();
            }
            if (consistency != 0) {
                throw new IllegalArgumentException();
            }
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    public void writeEndBasket() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeEndElement();
            this.newline();
            this.lastBasketNs = null;
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    public void writeObject(IomObject obj) throws IoxException {
        try {
            String type = obj.getobjecttag();
            this.xout.writeStartElement(this.lastBasketNs, "member");
            this.xout.writeStartElement(this.getXmlNs(type), this.getXmlName(type));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(obj.getobjectoid()));
            this.writeObjAttrs(obj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeObjAttrs(IomObject obj) throws IoxException {
        String tag = obj.getobjecttag();
        if (this.mapping != null && this.mapping.existsClass(tag)) {
            ViewableProperty[] attrv = this.mapping.getClassVProperties(tag);
            int i = 0;
            while (i < attrv.length) {
                this.writeObjAttr(obj, attrv[i]);
                ++i;
            }
        } else {
            if (!this.unkClsv.contains(tag)) {
                EhiLogger.logError("unknown class " + tag);
                this.unkClsv.add(tag);
            }
            int i = 0;
            while (i < obj.getattrcount()) {
                this.writeObjAttr(obj, new ViewableProperty(obj.getattrname(i)));
                ++i;
            }
        }
    }

    private void writeObjAttr(IomObject obj, ViewableProperty attr) throws IoxException {
        block27: {
            String xmlns_attr = this.getXmlNs(obj.getobjecttag());
            String baseAttrInClass = attr.getBaseDefInClass();
            if (baseAttrInClass != null) {
                xmlns_attr = this.getXmlNs(baseAttrInClass);
            }
            String attrName = attr.getName();
            try {
                int valueCount = obj.getattrvaluecount(attrName);
                if (valueCount <= 0) break block27;
                String val = obj.getattrprim(attrName, 0);
                if (val == null) {
                    boolean isRef;
                    IomObject child = obj.getattrobj(attrName, 0);
                    if (child == null) break block27;
                    if (child.getobjecttag().equals("COORD")) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        this.writeCoord(child, "EPSG:21781");
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one COORD value allowed (" + attrName + ")");
                        }
                        break block27;
                    }
                    if (child.getobjecttag().equals("POLYLINE")) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        this.writePolyline(child, false, "EPSG:21781");
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one POLYLINE value allowed (" + attrName + ")");
                        }
                        break block27;
                    }
                    if (child.getobjecttag().equals("MULTISURFACE")) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        this.writeSurface(child, "EPSG:21781");
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one MULTISURFACE value allowed (" + attrName + ")");
                        }
                        break block27;
                    }
                    String aref = child.getobjectrefoid();
                    boolean bl = isRef = aref != null;
                    if (isRef) {
                        String orderpos = null;
                        if (child.getobjectreforderpos() > 0L) {
                            orderpos = Long.toString(child.getobjectreforderpos());
                        }
                        String extref = null;
                        String bid = child.getobjectrefbid();
                        if (bid != null) {
                            extref = aref;
                            aref = null;
                        }
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        if (aref != null) {
                            this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(aref));
                        } else {
                            this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(extref));
                        }
                        this.writeAttributeStringOptional(xmlns_ili, "ORDER_POS", orderpos);
                        this.xout.writeEndElement();
                        if (child.getattrcount() > 0) {
                            this.xout.writeStartElement(xmlns_attr, String.valueOf(attrName) + "." + "LINK_DATA");
                            String structType = child.getobjecttag();
                            String structTid = child.getobjectoid();
                            if (structTid == null) {
                                structTid = this.getNewTid();
                            }
                            this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                            this.xout.writeAttribute(xmlns_gml, "id", structTid);
                            this.writeObjAttrs(child);
                            this.xout.writeEndElement();
                            this.xout.writeEndElement();
                        }
                        if (valueCount > 1) {
                            throw new IoxException("max one reference value allowed (" + attrName + ")");
                        }
                        break block27;
                    }
                    int valuei = 0;
                    while (true) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        String structType = child.getobjecttag();
                        String structTid = child.getobjectoid();
                        if (structTid == null) {
                            structTid = this.getNewTid();
                        }
                        this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                        this.xout.writeAttribute(xmlns_gml, "id", structTid);
                        this.writeObjAttrs(child);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        if (++valuei < valueCount) {
                            child = obj.getattrobj(attrName, valuei);
                            continue;
                        }
                        break block27;
                        break;
                    }
                }
                if (attr.getEnumType() != null && !attr.isTypeFinal()) {
                    if ((val = StringUtility.purge(val)) != null) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        String type = attr.getEnumType();
                        String codeSpace = null;
                        int pos = type.lastIndexOf(58);
                        if (pos > 0) {
                            String enumAttrDef = type.substring(pos + 1);
                            type = type.substring(0, pos);
                            codeSpace = String.valueOf(this.getXmlNs(type)) + "/" + this.getXmlName(type) + "/" + enumAttrDef;
                        } else {
                            codeSpace = String.valueOf(this.getXmlNs(type)) + "/" + this.getXmlName(type);
                        }
                        this.xout.writeAttribute("codeSpace", codeSpace);
                        this.xout.writeCharacters(val);
                        this.xout.writeEndElement();
                    }
                } else {
                    this.writeElementStringOptional(xmlns_attr, attrName, val);
                }
                if (valueCount > 1) {
                    throw new IoxException("max one primitive-type value allowed (" + attrName + ")");
                }
            }
            catch (XMLStreamException ex) {
                throw new IoxException(ex);
            }
        }
    }

    private void writeCoord(IomObject obj, String srs) throws IoxException {
        try {
            this.xout.writeStartElement(xmlns_gml, "Point");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "pos");
            this.writePosContent(obj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writePosContent(IomObject obj) throws XMLStreamException {
        String c1 = obj.getattrprim("C1", 0);
        this.xout.writeCharacters(c1);
        String c2 = obj.getattrprim("C2", 0);
        if (c2 != null) {
            this.xout.writeCharacters(" ");
            this.xout.writeCharacters(c2);
            String c3 = obj.getattrprim("C3", 0);
            if (c3 != null) {
                this.xout.writeCharacters(" ");
                this.xout.writeCharacters(c3);
            }
        }
    }

    private void writePolyline(IomObject obj, boolean hasLineAttr, String srs) throws IoxException {
        try {
            boolean clipped;
            IomObject lineattr;
            this.xout.writeStartElement(xmlns_gml, "Curve");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "segments");
            if (hasLineAttr && (lineattr = obj.getattrobj("lineattr", 0)) != null) {
                this.xout.writeStartElement(xmlns_ili, "LINEATTR");
                this.xout.writeStartElement(xmlns_ili, lineattr.getobjecttag());
                this.writeObjAttrs(lineattr);
                this.xout.writeEndElement();
                this.xout.writeEndElement();
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped polyline not supported");
            }
            int sequencei = 0;
            while (sequencei < obj.getattrvaluecount("sequence")) {
                if (!clipped && sequencei > 0) {
                    throw new IllegalArgumentException("unclipped polyline with multi 'sequence' elements");
                }
                IomObject sequence = obj.getattrobj("sequence", sequencei);
                int segmentc = sequence.getattrvaluecount("segment");
                int segmenti = 0;
                while (segmenti < segmentc) {
                    IomObject lastSegment;
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    if (segment.getobjecttag().equals("COORD")) {
                        if (segmenti != 0 || sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) {
                            if (segmenti == 0 || !sequence.getattrobj("segment", segmenti - 1).getobjecttag().equals("COORD")) {
                                this.xout.writeStartElement(xmlns_gml, "LineStringSegment");
                                this.xout.writeAttribute("interpolation", "linear");
                                this.xout.writeStartElement(xmlns_gml, "posList");
                                if (segmenti > 0) {
                                    lastSegment = sequence.getattrobj("segment", segmenti - 1);
                                    this.writePosContent(lastSegment);
                                    this.xout.writeCharacters(" ");
                                }
                            } else {
                                this.xout.writeCharacters(" ");
                            }
                            this.writePosContent(segment);
                            if (segmenti + 1 == segmentc || !sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) {
                                this.xout.writeEndElement();
                                this.xout.writeEndElement();
                            }
                        }
                    } else if (segment.getobjecttag().equals("ARC")) {
                        this.xout.writeStartElement(xmlns_gml, "Arc");
                        this.xout.writeAttribute("numArc", "1");
                        this.xout.writeAttribute("interpolation", "circularArc3Points");
                        this.xout.writeStartElement(xmlns_gml, "posList");
                        lastSegment = sequence.getattrobj("segment", segmenti - 1);
                        this.writePosContent(lastSegment);
                        this.xout.writeCharacters(" ");
                        String a1 = segment.getattrprim("A1", 0);
                        String a2 = segment.getattrprim("A2", 0);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a1);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a2);
                        this.xout.writeCharacters(" ");
                        this.writePosContent(segment);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                    } else {
                        throw new IoxException("custum line form not supported (" + segment.getobjecttag() + ")");
                    }
                    ++segmenti;
                }
                ++sequencei;
            }
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeSurface(IomObject obj, String srs) throws IoxException {
        try {
            boolean clipped;
            this.xout.writeStartElement(xmlns_gml, "Polygon");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped surface not supported");
            }
            int surfacei = 0;
            while (surfacei < obj.getattrvaluecount("surface")) {
                if (!clipped && surfacei > 0) {
                    throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                int boundaryi = 0;
                while (boundaryi < surface.getattrvaluecount("boundary")) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    if (boundaryi == 0) {
                        this.xout.writeStartElement(xmlns_gml, "exterior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    } else {
                        this.xout.writeStartElement(xmlns_gml, "interior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    }
                    int polylinei = 0;
                    while (polylinei < boundary.getattrvaluecount("polyline")) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        this.xout.writeStartElement(xmlns_gml, "curveMember");
                        this.writePolyline(polyline, true, null);
                        this.xout.writeEndElement();
                        ++polylinei;
                    }
                    this.xout.writeEndElement();
                    this.xout.writeEndElement();
                    ++boundaryi;
                }
                ++surfacei;
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeElementStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeStartElement(nsuri, name);
                this.xout.writeCharacters(v);
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeAttributeStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeAttribute(nsuri, name, v);
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private String getXmlNs(String type) {
        int pos = type.indexOf(46);
        String ret = "http://www.interlis.ch/INTERLIS2.3/GML32/" + type.substring(0, pos);
        return ret;
    }

    private String getXmlName(String type) {
        if (!this.nameMapping.containsKey(type)) {
            throw new IllegalArgumentException();
        }
        String ret = (String)this.nameMapping.get(type);
        return ret;
    }

    private String makeOid(String value) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            if (Character.isDigit(v.charAt(0))) {
                return "x" + v;
            }
            return v;
        }
        return null;
    }

    private String getNewTid() {
        return "iox" + Integer.toString(this.tid++);
    }
}

