/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.itf.impl.ItfLineCursor;
import ch.interlis.iox.IoxException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class ItfScanner {
    private LineNumberReader is = null;
    private HashMap str2lk = null;
    public static final String ITF_CHARSET = "ISO-8859-1";
    private boolean lookAheadDone = false;
    private int lookAheadKind = 0;
    private String lookAheadStr = null;
    private char continueCode = (char)92;

    public ItfScanner(InputStream in) throws UnsupportedEncodingException, IOException {
        this.setupStr2lk();
        this.is = new LineNumberReader(new InputStreamReader(in, ITF_CHARSET));
    }

    public void close() throws IoxException {
        this.is = null;
        this.str2lk = null;
    }

    public boolean read(ItfLineCursor cursor) throws IoxException {
        String str;
        cursor.setKind(0);
        cursor.setLineNumber(this.is.getLineNumber());
        try {
            if (this.lookAheadDone) {
                str = this.lookAheadStr;
                this.lookAheadDone = false;
            } else {
                while ((str = this.is.readLine()) != null && str.length() == 0) {
                }
            }
        }
        catch (IOException ex) {
            throw new IoxException("failed to read physical line", (Throwable)ex);
        }
        if (str == null) {
            cursor.setKind(0);
            return false;
        }
        if (str.startsWith("MOTR") || str.startsWith("SCNT")) {
            int kind = this.detLineKind(this.is.getLineNumber(), new StringBuffer(str));
            StringBuffer line = new StringBuffer();
            while (true) {
                try {
                    str = this.is.readLine();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to read physical line", (Throwable)ex);
                }
                if (str == null) {
                    throw new IoxException("end of file reached without line with label ////");
                }
                if (str.startsWith("////")) break;
                line.append(str);
            }
            cursor.setContent(line.toString());
            cursor.setKind(kind);
        } else {
            int contPos = -1;
            StringBuffer line = new StringBuffer();
            while (str != null && (contPos = this.getContPos(str)) >= 0) {
                line.append(str.substring(0, contPos));
                try {
                    str = this.is.readLine();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to read physical line", (Throwable)ex);
                }
                if (str == null) {
                    throw new IoxException("end of file reached without line with label CONT");
                }
                if (!str.startsWith("CONT")) {
                    throw new IoxException(this.is.getLineNumber(), "line with label CONT expected");
                }
                str = str.length() > 5 ? str.substring(5) : "";
            }
            line.append(str);
            int kind = this.detLineKind(this.is.getLineNumber(), line);
            if (line.length() > 5) {
                cursor.setContent(line.substring(5));
            } else {
                cursor.setContent(null);
            }
            cursor.setKind(kind);
        }
        return true;
    }

    public int nextKind() throws IoxException {
        if (this.lookAheadDone) {
            return this.lookAheadKind;
        }
        try {
            do {
                this.lookAheadStr = this.is.readLine();
            } while (this.lookAheadStr != null && this.lookAheadStr.length() == 0);
            this.lookAheadDone = true;
        }
        catch (IOException ex) {
            throw new IoxException("failed to read physical line", (Throwable)ex);
        }
        this.lookAheadKind = this.detLineKind(this.is.getLineNumber(), new StringBuffer(this.lookAheadStr));
        return this.lookAheadKind;
    }

    public void setContinueCode(char c) {
        this.continueCode = c;
    }

    private int getContPos(String str) {
        int pos = str.lastIndexOf(this.continueCode);
        if (pos == -1) {
            return -1;
        }
        int len = str.length();
        int i = pos + 1;
        while (i < len) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r') {
                return -1;
            }
            ++i;
        }
        return pos;
    }

    private int detLineKind(int lineNumber, StringBuffer line) throws IoxException {
        if (line.length() < 4) {
            throw new IoxException(lineNumber, "line without valid tag <" + line + ">");
        }
        if (line.length() > 4 && line.charAt(4) != ' ' && line.charAt(4) != '\t') {
            throw new IoxException(lineNumber, "line without valid tag <" + line.substring(0, 5) + ">");
        }
        String tag = line.substring(0, 4);
        if (!this.str2lk.containsKey(tag)) {
            throw new IoxException(lineNumber, "line with invalid tag <" + tag + ">");
        }
        return (Integer)this.str2lk.get(tag);
    }

    private void setupStr2lk() {
        this.str2lk = new HashMap();
        this.str2lk.put("SCNT", new Integer(1));
        this.str2lk.put("MOTR", new Integer(2));
        this.str2lk.put("MTID", new Integer(3));
        this.str2lk.put("ENDE", new Integer(4));
        this.str2lk.put("////", new Integer(5));
        this.str2lk.put("MODL", new Integer(6));
        this.str2lk.put("EMOD", new Integer(7));
        this.str2lk.put("TOPI", new Integer(8));
        this.str2lk.put("ETOP", new Integer(9));
        this.str2lk.put("TABL", new Integer(10));
        this.str2lk.put("ETAB", new Integer(11));
        this.str2lk.put("OBJE", new Integer(12));
        this.str2lk.put("PERI", new Integer(13));
        this.str2lk.put("STPT", new Integer(14));
        this.str2lk.put("ELIN", new Integer(15));
        this.str2lk.put("LIPT", new Integer(16));
        this.str2lk.put("ARCP", new Integer(17));
        this.str2lk.put("EFLA", new Integer(18));
        this.str2lk.put("EDGE", new Integer(19));
        this.str2lk.put("EEDG", new Integer(20));
        this.str2lk.put("LATT", new Integer(21));
        this.str2lk.put("TABA", new Integer(22));
        this.str2lk.put("SOBJ", new Integer(23));
        this.str2lk.put("ETBA", new Integer(24));
        this.str2lk.put("!!!!", new Integer(25));
    }

    public static void main(String[] args) {
        EhiLogger.getInstance().setTraceFilter(false);
        try {
            ItfScanner scanner = new ItfScanner(new FileInputStream(args[0]));
            ItfLineCursor cursor = new ItfLineCursor();
            while (scanner.read(cursor)) {
                System.out.println("kind " + cursor.getKind() + ", content <" + cursor.getContent() + ">");
            }
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
        }
    }
}

