/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.swingext;

import ch.softenvironment.util.Tracer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class JEditorPanePrintUtility
implements Printable {
    private int currentPage = -1;
    private JEditorPane jeditorPane;
    private double pageEndY = 0.0;
    private double pageStartY = 0.0;
    private boolean scaleWidthToFit = true;
    private PageFormat pFormat;
    private PrinterJob pJob = PrinterJob.getPrinterJob();

    public JEditorPanePrintUtility(String jobName) {
        this.pJob.setJobName(jobName);
        this.pFormat = new PageFormat();
    }

    public void pageDialog() {
        this.pFormat = this.pJob.pageDialog(this.pFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.jeditorPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.jeditorPane.validate();
        View rootView = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        if (this.scaleWidthToFit && this.jeditorPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            scale = pageFormat.getImageableWidth() / this.jeditorPane.getMinimumSize().getWidth();
            graphics2D.scale(scale, scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.pageStartY), (int)this.jeditorPane.getMinimumSize().getWidth(), (int)this.jeditorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    public void print(HTMLDocument htmlDocument) {
        this.setDocument(htmlDocument);
        this.printDialog();
    }

    public void print(JEditorPane jedPane) {
        this.jeditorPane = jedPane;
        this.printDialog();
    }

    public void print(PlainDocument plainDocument) {
        this.setDocument(plainDocument);
        this.printDialog();
    }

    private void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException ex) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                Tracer.getInstance().runtimeError("Error Printing Document", ex);
            }
        }
    }

    private boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    private void setDocument(PlainDocument plainDocument) {
        this.setDocument("text/plain", plainDocument);
    }

    private void setDocument(HTMLDocument htmlDocument) {
        this.setDocument("text/html", htmlDocument);
    }

    private void setDocument(String type, Document document) {
        this.jeditorPane = new JEditorPane();
        this.jeditorPane.setContentType(type);
        this.jeditorPane.setDocument(document);
    }

    public void setScaleWidthToFit(boolean scaleWidth) {
        this.scaleWidthToFit = scaleWidth;
    }
}

