/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.util;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DoubleStroke;
import java.awt.BasicStroke;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class Utils {
    private Utils() {
    }

    public static Point normalize(Point p, int pixels) {
        Point ret = new Point();
        double d = Math.sqrt(p.x * p.x + p.y * p.y);
        ret.x = (int)((double)p.x / d * (double)pixels);
        ret.y = (int)((double)p.y / d * (double)pixels);
        return ret;
    }

    public static Vector<String> decomposeStringsIncludingEmptyStrings(String s, String delimiter) {
        return Utils.decomposeStringsWFilter(s, delimiter, false, false);
    }

    public static Vector<String> decomposeStringsWithEmptyLines(String s) {
        return Utils.decomposeStringsWFilter(s, "\n", true, false);
    }

    public static Vector<String> decomposeStringsWithComments(String s) {
        return Utils.decomposeStringsWFilter(s, "\n", false, true);
    }

    public static Vector<String> decomposeStrings(String s, String delimiter) {
        return Utils.decomposeStringsWFilter(s, delimiter, true, true);
    }

    public static Vector<String> decomposeStrings(String s) {
        return Utils.decomposeStrings(s, "\n");
    }

    private static Vector<String> decomposeStringsWFilter(String fullString, String delimiter, boolean filterComments, boolean filterNewLines) {
        Vector<String> returnVector = new Vector<String>();
        String compatibleFullString = fullString.replaceAll("\r\n", delimiter);
        for (String line : compatibleFullString.split("\\" + delimiter)) {
            if (filterComments && line.matches("((//)|(fg=)|(bg=)|(autoresize=)|(layer=)|(group=)).*") || filterNewLines && line.isEmpty()) continue;
            returnVector.add(line);
        }
        return returnVector;
    }

    public static String composeStrings(Vector<String> v, String delimiter) {
        String ret = null;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                ret = ret == null ? v.elementAt(i) : ret + delimiter + v.elementAt(i);
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static Stroke getStroke(LineType lineType, float lineThickness) {
        if (lineThickness < 0.0f) {
            lineThickness = 1.0f;
        }
        Stroke stroke = null;
        if (lineType == LineType.SOLID) {
            stroke = new BasicStroke(lineThickness);
        } else if (lineType == LineType.DASHED) {
            stroke = new BasicStroke(lineThickness, 0, 0, 5.0f, new float[]{8.0f, 5.0f}, 0.0f);
        } else if (lineType == LineType.DOTTED) {
            stroke = new BasicStroke(lineThickness, 0, 0, 5.0f, new float[]{1.0f, 2.0f}, 0.0f);
        } else if (lineType == LineType.DOUBLE) {
            stroke = new DoubleStroke(lineThickness, 4.0f, 0, 0, 5.0f, null, 0.0f);
        } else if (lineType == LineType.DOUBLE_DASHED) {
            stroke = new DoubleStroke(lineThickness, 4.0f, 0, 0, 5.0f, new float[]{8.0f, 5.0f}, 0.0f);
        } else if (lineType == LineType.DOUBLE_DOTTED) {
            stroke = new DoubleStroke(lineThickness, 3.0f, 0, 0, 5.0f, new float[]{1.0f, 2.0f}, 0.0f);
        }
        return stroke;
    }

    public static Map<RenderingHints.Key, Object> getUxRenderingQualityHigh(boolean subpixelRendering) {
        HashMap<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
        renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        if (subpixelRendering) {
            renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return renderingHints;
    }

    public static double getAngle(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double res = Math.atan(y / x);
        if (x >= 0.0 && y >= 0.0) {
            res += 0.0;
        } else if (x < 0.0 && y >= 0.0) {
            res += Math.PI;
        } else if (x < 0.0 && y < 0.0) {
            res += Math.PI;
        } else if (x >= 0.0 && y < 0.0) {
            res += Math.PI * 2;
        }
        return res;
    }

    public static Double[] createDoubleArrayFromTo(Double min, Double max, Double step) {
        if (min > max) {
            return null;
        }
        int range = (int)Math.ceil((max - min) / step + 1.0);
        Double[] returnArray = new Double[range];
        for (int i = 0; i < range; ++i) {
            returnArray[i] = min + (double)i * step;
        }
        return returnArray;
    }

    public static Double[] createDoubleArrayFromTo(Double min, Double max) {
        return Utils.createDoubleArrayFromTo(min, max, 1.0);
    }
}

