/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;

public class CommentsParser {
    private static final int COLUMNS_PER_TAB = 4;

    public CommentsCollection parse(String source) throws IOException, UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes(Charset.defaultCharset()));
        return this.parse(in, Charset.defaultCharset().name());
    }

    public CommentsCollection parse(InputStream in, String charsetName) throws IOException, UnsupportedEncodingException {
        int r;
        boolean lastWasASlashR = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, charsetName));
        CommentsCollection comments = new CommentsCollection();
        LinkedList<Character> prevTwoChars = new LinkedList<Character>(Arrays.asList(Character.valueOf('z'), Character.valueOf('z')));
        State state = State.CODE;
        Comment currentLineComment = null;
        BlockComment currentBlockComment = null;
        StringBuffer currentContent = null;
        int currLine = 1;
        int currCol = 1;
        while ((r = br.read()) != -1) {
            char c = (char)r;
            if (c == '\r') {
                lastWasASlashR = true;
            } else {
                if (c == '\n' && lastWasASlashR) {
                    lastWasASlashR = false;
                    continue;
                }
                lastWasASlashR = false;
            }
            switch (state) {
                case CODE: {
                    if (prevTwoChars.peekLast().equals(Character.valueOf('/')) && c == '/') {
                        currentLineComment = new LineComment();
                        currentLineComment.setBeginLine(currLine);
                        currentLineComment.setBeginColumn(currCol - 1);
                        state = State.IN_LINE_COMMENT;
                        currentContent = new StringBuffer();
                        break;
                    }
                    if (prevTwoChars.peekLast().equals(Character.valueOf('/')) && c == '*') {
                        currentBlockComment = new BlockComment();
                        currentBlockComment.setBeginLine(currLine);
                        currentBlockComment.setBeginColumn(currCol - 1);
                        state = State.IN_BLOCK_COMMENT;
                        currentContent = new StringBuffer();
                        break;
                    }
                    if (c == '\"') {
                        state = State.IN_STRING;
                        break;
                    }
                    if (c != '\'') break;
                    state = State.IN_CHAR;
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (c == '\n' || c == '\r') {
                        currentLineComment.setContent(currentContent.toString());
                        currentLineComment.setEndLine(currLine);
                        currentLineComment.setEndColumn(currCol);
                        comments.addComment((LineComment)currentLineComment);
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c);
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (prevTwoChars.peekLast().equals(Character.valueOf('*')) && c == '/' && !prevTwoChars.peekFirst().equals(Character.valueOf('/'))) {
                        String content = currentContent.deleteCharAt(currentContent.toString().length() - 1).toString();
                        if (content.startsWith("*")) {
                            JavadocComment javadocComment = new JavadocComment();
                            javadocComment.setContent(content.substring(1));
                            javadocComment.setBeginLine(currentBlockComment.getBeginLine());
                            javadocComment.setBeginColumn(currentBlockComment.getBeginColumn());
                            javadocComment.setEndLine(currLine);
                            javadocComment.setEndColumn(currCol + 1);
                            comments.addComment(javadocComment);
                        } else {
                            currentBlockComment.setContent(content);
                            currentBlockComment.setEndLine(currLine);
                            currentBlockComment.setEndColumn(currCol + 1);
                            comments.addComment(currentBlockComment);
                        }
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c == '\r' ? (char)'\n' : (char)c);
                    break;
                }
                case IN_STRING: {
                    if (prevTwoChars.peekLast().equals(Character.valueOf('\\')) || c != '\"') break;
                    state = State.CODE;
                    break;
                }
                case IN_CHAR: {
                    if (prevTwoChars.peekLast().equals(Character.valueOf('\\')) || c != '\'') break;
                    state = State.CODE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected");
                }
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    ++currLine;
                    currCol = 1;
                    break;
                }
                case '\t': {
                    currCol += 4;
                    break;
                }
                default: {
                    ++currCol;
                }
            }
            prevTwoChars.remove();
            prevTwoChars.add(Character.valueOf(c));
        }
        if (state == State.IN_LINE_COMMENT) {
            currentLineComment.setContent(currentContent.toString());
            currentLineComment.setEndLine(currLine);
            currentLineComment.setEndColumn(currCol);
            comments.addComment((LineComment)currentLineComment);
        }
        return comments;
    }

    private static enum State {
        CODE,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING,
        IN_CHAR;

    }
}

