# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

"""
@author:       MHL
@license:      GNU General Public License 2.0
@contact:      michael.ligh@mnin.org

This file provides support for Vista SP0 x64
"""

syscalls = [
    [
    'NtMapUserPhysicalPagesScatter', # 0x0
    'NtWaitForSingleObject', # 0x1
    'NtCallbackReturn', # 0x2
    'NtReadFile', # 0x3
    'NtDeviceIoControlFile', # 0x4
    'NtWriteFile', # 0x5
    'NtRemoveIoCompletion', # 0x6
    'NtReleaseSemaphore', # 0x7
    'NtReplyWaitReceivePort', # 0x8
    'NtReplyPort', # 0x9
    'NtSetInformationThread', # 0xa
    'NtSetEvent', # 0xb
    'NtClose', # 0xc
    'NtQueryObject', # 0xd
    'NtQueryInformationFile', # 0xe
    'NtOpenKey', # 0xf
    'NtEnumerateValueKey', # 0x10
    'NtFindAtom', # 0x11
    'NtQueryDefaultLocale', # 0x12
    'NtQueryKey', # 0x13
    'NtQueryValueKey', # 0x14
    'NtAllocateVirtualMemory', # 0x15
    'NtQueryInformationProcess', # 0x16
    'NtWaitForMultipleObjects32', # 0x17
    'NtWriteFileGather', # 0x18
    'NtSetInformationProcess', # 0x19
    'NtCreateKey', # 0x1a
    'NtFreeVirtualMemory', # 0x1b
    'NtImpersonateClientOfPort', # 0x1c
    'NtReleaseMutant', # 0x1d
    'NtQueryInformationToken', # 0x1e
    'NtRequestWaitReplyPort', # 0x1f
    'NtQueryVirtualMemory', # 0x20
    'NtOpenThreadToken', # 0x21
    'NtQueryInformationThread', # 0x22
    'NtOpenProcess', # 0x23
    'NtSetInformationFile', # 0x24
    'NtMapViewOfSection', # 0x25
    'NtAccessCheckAndAuditAlarm', # 0x26
    'NtUnmapViewOfSection', # 0x27
    'NtReplyWaitReceivePortEx', # 0x28
    'NtTerminateProcess', # 0x29
    'NtSetEventBoostPriority', # 0x2a
    'NtReadFileScatter', # 0x2b
    'NtOpenThreadTokenEx', # 0x2c
    'NtOpenProcessTokenEx', # 0x2d
    'NtQueryPerformanceCounter', # 0x2e
    'NtEnumerateKey', # 0x2f
    'NtOpenFile', # 0x30
    'NtDelayExecution', # 0x31
    'NtQueryDirectoryFile', # 0x32
    'NtQuerySystemInformation', # 0x33
    'NtOpenSection', # 0x34
    'NtQueryTimer', # 0x35
    'NtFsControlFile', # 0x36
    'NtWriteVirtualMemory', # 0x37
    'NtCloseObjectAuditAlarm', # 0x38
    'NtDuplicateObject', # 0x39
    'NtQueryAttributesFile', # 0x3a
    'NtClearEvent', # 0x3b
    'NtReadVirtualMemory', # 0x3c
    'NtOpenEvent', # 0x3d
    'NtAdjustPrivilegesToken', # 0x3e
    'NtDuplicateToken', # 0x3f
    'NtContinue', # 0x40
    'NtQueryDefaultUILanguage', # 0x41
    'NtQueueApcThread', # 0x42
    'NtYieldExecution', # 0x43
    'NtAddAtom', # 0x44
    'NtCreateEvent', # 0x45
    'NtQueryVolumeInformationFile', # 0x46
    'NtCreateSection', # 0x47
    'NtFlushBuffersFile', # 0x48
    'NtApphelpCacheControl', # 0x49
    'NtCreateProcessEx', # 0x4a
    'NtCreateThread', # 0x4b
    'NtIsProcessInJob', # 0x4c
    'NtProtectVirtualMemory', # 0x4d
    'NtQuerySection', # 0x4e
    'NtResumeThread', # 0x4f
    'NtTerminateThread', # 0x50
    'NtReadRequestData', # 0x51
    'NtCreateFile', # 0x52
    'NtQueryEvent', # 0x53
    'NtWriteRequestData', # 0x54
    'NtOpenDirectoryObject', # 0x55
    'NtAccessCheckByTypeAndAuditAlarm', # 0x56
    'NtQuerySystemTime', # 0x57
    'NtWaitForMultipleObjects', # 0x58
    'NtSetInformationObject', # 0x59
    'NtCancelIoFile', # 0x5a
    'NtTraceEvent', # 0x5b
    'NtPowerInformation', # 0x5c
    'NtSetValueKey', # 0x5d
    'NtCancelTimer', # 0x5e
    'NtSetTimer', # 0x5f
    'NtAcceptConnectPort', # 0x60
    'NtAccessCheck', # 0x61
    'NtAccessCheckByType', # 0x62
    'NtAccessCheckByTypeResultList', # 0x63
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x64
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x65
    'NtAcquireCMFViewOwnership', # 0x66
    'NtAddBootEntry', # 0x67
    'NtAddDriverEntry', # 0x68
    'NtAdjustGroupsToken', # 0x69
    'NtAlertResumeThread', # 0x6a
    'NtAlertThread', # 0x6b
    'NtAllocateLocallyUniqueId', # 0x6c
    'NtAllocateUserPhysicalPages', # 0x6d
    'NtAllocateUuids', # 0x6e
    'NtAlpcAcceptConnectPort', # 0x6f
    'NtAlpcCancelMessage', # 0x70
    'NtAlpcConnectPort', # 0x71
    'NtAlpcCreatePort', # 0x72
    'NtAlpcCreatePortSection', # 0x73
    'NtAlpcCreateResourceReserve', # 0x74
    'NtAlpcCreateSectionView', # 0x75
    'NtAlpcCreateSecurityContext', # 0x76
    'NtAlpcDeletePortSection', # 0x77
    'NtAlpcDeleteResourceReserve', # 0x78
    'NtAlpcDeleteSectionView', # 0x79
    'NtAlpcDeleteSecurityContext', # 0x7a
    'NtAlpcDisconnectPort', # 0x7b
    'NtAlpcImpersonateClientOfPort', # 0x7c
    'NtAlpcOpenSenderProcess', # 0x7d
    'NtAlpcOpenSenderThread', # 0x7e
    'NtAlpcQueryInformation', # 0x7f
    'NtAlpcQueryInformationMessage', # 0x80
    'NtAlpcRevokeSecurityContext', # 0x81
    'NtAlpcSendWaitReceivePort', # 0x82
    'NtAlpcSetInformation', # 0x83
    'NtAreMappedFilesTheSame', # 0x84
    'NtAssignProcessToJobObject', # 0x85
    'NtCancelDeviceWakeupRequest', # 0x86
    'NtCancelIoFileEx', # 0x87
    'NtCancelSynchronousIoFile', # 0x88
    'NtClearAllSavepointsTransaction', # 0x89
    'NtClearSavepointTransaction', # 0x8a
    'NtCommitComplete', # 0x8b
    'NtCommitEnlistment', # 0x8c
    'NtCommitTransaction', # 0x8d
    'NtCompactKeys', # 0x8e
    'NtCompareTokens', # 0x8f
    'NtCompleteConnectPort', # 0x90
    'NtCompressKey', # 0x91
    'NtConnectPort', # 0x92
    'NtCreateDebugObject', # 0x93
    'NtCreateDirectoryObject', # 0x94
    'NtCreateEnlistment', # 0x95
    'NtCreateEventPair', # 0x96
    'NtCreateIoCompletion', # 0x97
    'NtCreateJobObject', # 0x98
    'NtCreateJobSet', # 0x99
    'NtCreateKeyTransacted', # 0x9a
    'NtCreateKeyedEvent', # 0x9b
    'NtCreateMailslotFile', # 0x9c
    'NtCreateMutant', # 0x9d
    'NtCreateNamedPipeFile', # 0x9e
    'NtCreatePagingFile', # 0x9f
    'NtCreatePort', # 0xa0
    'NtCreatePrivateNamespace', # 0xa1
    'NtCreateProcess', # 0xa2
    'NtCreateProfile', # 0xa3
    'NtCreateResourceManager', # 0xa4
    'NtCreateSemaphore', # 0xa5
    'NtCreateSymbolicLinkObject', # 0xa6
    'NtCreateThreadEx', # 0xa7
    'NtCreateTimer', # 0xa8
    'NtCreateToken', # 0xa9
    'NtCreateTransaction', # 0xaa
    'NtCreateTransactionManager', # 0xab
    'NtCreateUserProcess', # 0xac
    'NtCreateWaitablePort', # 0xad
    'NtCreateWorkerFactory', # 0xae
    'NtDebugActiveProcess', # 0xaf
    'NtDebugContinue', # 0xb0
    'NtDeleteAtom', # 0xb1
    'NtDeleteBootEntry', # 0xb2
    'NtDeleteDriverEntry', # 0xb3
    'NtDeleteFile', # 0xb4
    'NtDeleteKey', # 0xb5
    'NtDeleteObjectAuditAlarm', # 0xb6
    'NtDeletePrivateNamespace', # 0xb7
    'NtDeleteValueKey', # 0xb8
    'NtDisplayString', # 0xb9
    'NtEnumerateBootEntries', # 0xba
    'NtEnumerateDriverEntries', # 0xbb
    'NtEnumerateSystemEnvironmentValuesEx', # 0xbc
    'NtEnumerateTransactionObject', # 0xbd
    'NtExtendSection', # 0xbe
    'NtFilterToken', # 0xbf
    'NtFlushInstallUILanguage', # 0xc0
    'NtFlushInstructionCache', # 0xc1
    'NtFlushKey', # 0xc2
    'NtFlushProcessWriteBuffers', # 0xc3
    'NtFlushVirtualMemory', # 0xc4
    'NtFlushWriteBuffer', # 0xc5
    'NtFreeUserPhysicalPages', # 0xc6
    'NtFreezeRegistry', # 0xc7
    'NtFreezeTransactions', # 0xc8
    'NtGetContextThread', # 0xc9
    'NtGetCurrentProcessorNumber', # 0xca
    'NtGetDevicePowerState', # 0xcb
    'NtGetMUIRegistryInfo', # 0xcc
    'NtGetNextProcess', # 0xcd
    'NtGetNextThread', # 0xce
    'NtGetNlsSectionPtr', # 0xcf
    'NtGetNotificationResourceManager', # 0xd0
    'NtGetPlugPlayEvent', # 0xd1
    'NtGetWriteWatch', # 0xd2
    'NtImpersonateAnonymousToken', # 0xd3
    'NtImpersonateThread', # 0xd4
    'NtInitializeNlsFiles', # 0xd5
    'NtInitializeRegistry', # 0xd6
    'NtInitiatePowerAction', # 0xd7
    'NtIsSystemResumeAutomatic', # 0xd8
    'NtIsUILanguageComitted', # 0xd9
    'NtListTransactions', # 0xda
    'NtListenPort', # 0xdb
    'NtLoadDriver', # 0xdc
    'NtLoadKey', # 0xdd
    'NtLoadKey2', # 0xde
    'NtLoadKeyEx', # 0xdf
    'NtLockFile', # 0xe0
    'NtLockProductActivationKeys', # 0xe1
    'NtLockRegistryKey', # 0xe2
    'NtLockVirtualMemory', # 0xe3
    'NtMakePermanentObject', # 0xe4
    'NtMakeTemporaryObject', # 0xe5
    'NtMapCMFModule', # 0xe6
    'NtMapUserPhysicalPages', # 0xe7
    'NtMarshallTransaction', # 0xe8
    'NtModifyBootEntry', # 0xe9
    'NtModifyDriverEntry', # 0xea
    'NtNotifyChangeDirectoryFile', # 0xeb
    'NtNotifyChangeKey', # 0xec
    'NtNotifyChangeMultipleKeys', # 0xed
    'NtOpenEnlistment', # 0xee
    'NtOpenEventPair', # 0xef
    'NtOpenIoCompletion', # 0xf0
    'NtOpenJobObject', # 0xf1
    'NtOpenKeyTransacted', # 0xf2
    'NtOpenKeyedEvent', # 0xf3
    'NtOpenMutant', # 0xf4
    'NtOpenObjectAuditAlarm', # 0xf5
    'NtOpenPrivateNamespace', # 0xf6
    'NtOpenProcessToken', # 0xf7
    'NtOpenResourceManager', # 0xf8
    'NtOpenSemaphore', # 0xf9
    'NtOpenSession', # 0xfa
    'NtOpenSymbolicLinkObject', # 0xfb
    'NtOpenThread', # 0xfc
    'NtOpenTimer', # 0xfd
    'NtOpenTransaction', # 0xfe
    'NtOpenTransactionManager', # 0xff
    'NtPlugPlayControl', # 0x100
    'NtPrePrepareComplete', # 0x101
    'NtPrePrepareEnlistment', # 0x102
    'NtPrepareComplete', # 0x103
    'NtPrepareEnlistment', # 0x104
    'NtPrivilegeCheck', # 0x105
    'NtPrivilegeObjectAuditAlarm', # 0x106
    'NtPrivilegedServiceAuditAlarm', # 0x107
    'NtPropagationComplete', # 0x108
    'NtPropagationFailed', # 0x109
    'NtPullTransaction', # 0x10a
    'NtPulseEvent', # 0x10b
    'NtQueryBootEntryOrder', # 0x10c
    'NtQueryBootOptions', # 0x10d
    'NtQueryDebugFilterState', # 0x10e
    'NtQueryDirectoryObject', # 0x10f
    'NtQueryDriverEntryOrder', # 0x110
    'NtQueryEaFile', # 0x111
    'NtQueryFullAttributesFile', # 0x112
    'NtQueryInformationAtom', # 0x113
    'NtQueryInformationEnlistment', # 0x114
    'NtQueryInformationJobObject', # 0x115
    'NtQueryInformationPort', # 0x116
    'NtQueryInformationResourceManager', # 0x117
    'NtQueryInformationTransaction', # 0x118
    'NtQueryInformationTransactionManager', # 0x119
    'NtQueryInformationWorkerFactory', # 0x11a
    'NtQueryInstallUILanguage', # 0x11b
    'NtQueryIntervalProfile', # 0x11c
    'NtQueryIoCompletion', # 0x11d
    'NtQueryLicenseValue', # 0x11e
    'NtQueryMultipleValueKey', # 0x11f
    'NtQueryMutant', # 0x120
    'NtQueryOpenSubKeys', # 0x121
    'NtQueryOpenSubKeysEx', # 0x122
    'NtQueryPortInformationProcess', # 0x123
    'NtQueryQuotaInformationFile', # 0x124
    'NtQuerySecurityObject', # 0x125
    'NtQuerySemaphore', # 0x126
    'NtQuerySymbolicLinkObject', # 0x127
    'NtQuerySystemEnvironmentValue', # 0x128
    'NtQuerySystemEnvironmentValueEx', # 0x129
    'NtQueryTimerResolution', # 0x12a
    'NtRaiseException', # 0x12b
    'NtRaiseHardError', # 0x12c
    'NtReadOnlyEnlistment', # 0x12d
    'NtRecoverEnlistment', # 0x12e
    'NtRecoverResourceManager', # 0x12f
    'NtRecoverTransactionManager', # 0x130
    'NtRegisterProtocolAddressInformation', # 0x131
    'NtRegisterThreadTerminatePort', # 0x132
    'NtReleaseCMFViewOwnership', # 0x133
    'NtReleaseKeyedEvent', # 0x134
    'NtReleaseWorkerFactoryWorker', # 0x135
    'NtRemoveIoCompletionEx', # 0x136
    'NtRemoveProcessDebug', # 0x137
    'NtRenameKey', # 0x138
    'NtReplaceKey', # 0x139
    'NtReplyWaitReplyPort', # 0x13a
    'NtRequestDeviceWakeup', # 0x13b
    'NtRequestPort', # 0x13c
    'NtRequestWakeupLatency', # 0x13d
    'NtResetEvent', # 0x13e
    'NtResetWriteWatch', # 0x13f
    'NtRestoreKey', # 0x140
    'NtResumeProcess', # 0x141
    'NtRollbackComplete', # 0x142
    'NtRollbackEnlistment', # 0x143
    'NtRollbackSavepointTransaction', # 0x144
    'NtRollbackTransaction', # 0x145
    'NtRollforwardTransactionManager', # 0x146
    'NtSaveKey', # 0x147
    'NtSaveKeyEx', # 0x148
    'NtSaveMergedKeys', # 0x149
    'NtSavepointComplete', # 0x14a
    'NtSavepointTransaction', # 0x14b
    'NtSecureConnectPort', # 0x14c
    'NtSetBootEntryOrder', # 0x14d
    'NtSetBootOptions', # 0x14e
    'NtSetContextThread', # 0x14f
    'NtSetDebugFilterState', # 0x150
    'NtSetDefaultHardErrorPort', # 0x151
    'NtSetDefaultLocale', # 0x152
    'NtSetDefaultUILanguage', # 0x153
    'NtSetDriverEntryOrder', # 0x154
    'NtSetEaFile', # 0x155
    'NtSetHighEventPair', # 0x156
    'NtSetHighWaitLowEventPair', # 0x157
    'NtSetInformationDebugObject', # 0x158
    'NtSetInformationEnlistment', # 0x159
    'NtSetInformationJobObject', # 0x15a
    'NtSetInformationKey', # 0x15b
    'NtSetInformationResourceManager', # 0x15c
    'NtSetInformationToken', # 0x15d
    'NtSetInformationTransaction', # 0x15e
    'NtSetInformationTransactionManager', # 0x15f
    'NtSetInformationWorkerFactory', # 0x160
    'NtSetIntervalProfile', # 0x161
    'NtSetIoCompletion', # 0x162
    'NtSetLdtEntries', # 0x163
    'NtSetLowEventPair', # 0x164
    'NtSetLowWaitHighEventPair', # 0x165
    'NtSetQuotaInformationFile', # 0x166
    'NtSetSecurityObject', # 0x167
    'NtSetSystemEnvironmentValue', # 0x168
    'NtSetSystemEnvironmentValueEx', # 0x169
    'NtSetSystemInformation', # 0x16a
    'NtSetSystemPowerState', # 0x16b
    'NtSetSystemTime', # 0x16c
    'NtSetThreadExecutionState', # 0x16d
    'NtSetTimerResolution', # 0x16e
    'NtSetUuidSeed', # 0x16f
    'NtSetVolumeInformationFile', # 0x170
    'NtShutdownSystem', # 0x171
    'NtShutdownWorkerFactory', # 0x172
    'NtSignalAndWaitForSingleObject', # 0x173
    'NtSinglePhaseReject', # 0x174
    'NtStartProfile', # 0x175
    'NtStartTm', # 0x176
    'NtStopProfile', # 0x177
    'NtSuspendProcess', # 0x178
    'NtSuspendThread', # 0x179
    'NtSystemDebugControl', # 0x17a
    'NtTerminateJobObject', # 0x17b
    'NtTestAlert', # 0x17c
    'NtThawRegistry', # 0x17d
    'NtThawTransactions', # 0x17e
    'NtTraceControl', # 0x17f
    'NtTranslateFilePath', # 0x180
    'NtUnloadDriver', # 0x181
    'NtUnloadKey', # 0x182
    'NtUnloadKey2', # 0x183
    'NtUnloadKeyEx', # 0x184
    'NtUnlockFile', # 0x185
    'NtUnlockVirtualMemory', # 0x186
    'NtVdmControl', # 0x187
    'NtWaitForDebugEvent', # 0x188
    'NtWaitForKeyedEvent', # 0x189
    'NtWaitForWorkViaWorkerFactory', # 0x18a
    'NtWaitHighEventPair', # 0x18b
    'NtWaitLowEventPair', # 0x18c
    'NtWorkerFactoryWorkerReady', # 0x18d
    ],
    [
    'NtUserGetThreadState', # 0x0
    'NtUserPeekMessage', # 0x1
    'NtUserCallOneParam', # 0x2
    'NtUserGetKeyState', # 0x3
    'NtUserInvalidateRect', # 0x4
    'NtUserCallNoParam', # 0x5
    'NtUserGetMessage', # 0x6
    'NtUserMessageCall', # 0x7
    'NtGdiBitBlt', # 0x8
    'NtGdiGetCharSet', # 0x9
    'NtUserGetDC', # 0xa
    'NtGdiSelectBitmap', # 0xb
    'NtUserWaitMessage', # 0xc
    'NtUserTranslateMessage', # 0xd
    'NtUserGetProp', # 0xe
    'NtUserPostMessage', # 0xf
    'NtUserQueryWindow', # 0x10
    'NtUserTranslateAccelerator', # 0x11
    'NtGdiFlush', # 0x12
    'NtUserRedrawWindow', # 0x13
    'NtUserWindowFromPoint', # 0x14
    'NtUserCallMsgFilter', # 0x15
    'NtUserValidateTimerCallback', # 0x16
    'NtUserBeginPaint', # 0x17
    'NtUserSetTimer', # 0x18
    'NtUserEndPaint', # 0x19
    'NtUserSetCursor', # 0x1a
    'NtUserKillTimer', # 0x1b
    'NtUserBuildHwndList', # 0x1c
    'NtUserSelectPalette', # 0x1d
    'NtUserCallNextHookEx', # 0x1e
    'NtUserHideCaret', # 0x1f
    'NtGdiIntersectClipRect', # 0x20
    'NtUserCallHwndLock', # 0x21
    'NtUserGetProcessWindowStation', # 0x22
    'NtGdiDeleteObjectApp', # 0x23
    'NtUserSetWindowPos', # 0x24
    'NtUserShowCaret', # 0x25
    'NtUserEndDeferWindowPosEx', # 0x26
    'NtUserCallHwndParamLock', # 0x27
    'NtUserVkKeyScanEx', # 0x28
    'NtGdiSetDIBitsToDeviceInternal', # 0x29
    'NtUserCallTwoParam', # 0x2a
    'NtGdiGetRandomRgn', # 0x2b
    'NtUserCopyAcceleratorTable', # 0x2c
    'NtUserNotifyWinEvent', # 0x2d
    'NtGdiExtSelectClipRgn', # 0x2e
    'NtUserIsClipboardFormatAvailable', # 0x2f
    'NtUserSetScrollInfo', # 0x30
    'NtGdiStretchBlt', # 0x31
    'NtUserCreateCaret', # 0x32
    'NtGdiRectVisible', # 0x33
    'NtGdiCombineRgn', # 0x34
    'NtGdiGetDCObject', # 0x35
    'NtUserDispatchMessage', # 0x36
    'NtUserRegisterWindowMessage', # 0x37
    'NtGdiExtTextOutW', # 0x38
    'NtGdiSelectFont', # 0x39
    'NtGdiRestoreDC', # 0x3a
    'NtGdiSaveDC', # 0x3b
    'NtUserGetForegroundWindow', # 0x3c
    'NtUserShowScrollBar', # 0x3d
    'NtUserFindExistingCursorIcon', # 0x3e
    'NtGdiGetDCDword', # 0x3f
    'NtGdiGetRegionData', # 0x40
    'NtGdiLineTo', # 0x41
    'NtUserSystemParametersInfo', # 0x42
    'NtGdiGetAppClipBox', # 0x43
    'NtUserGetAsyncKeyState', # 0x44
    'NtUserGetCPD', # 0x45
    'NtUserRemoveProp', # 0x46
    'NtGdiDoPalette', # 0x47
    'NtGdiPolyPolyDraw', # 0x48
    'NtUserSetCapture', # 0x49
    'NtUserEnumDisplayMonitors', # 0x4a
    'NtGdiCreateCompatibleBitmap', # 0x4b
    'NtUserSetProp', # 0x4c
    'NtGdiGetTextCharsetInfo', # 0x4d
    'NtUserSBGetParms', # 0x4e
    'NtUserGetIconInfo', # 0x4f
    'NtUserExcludeUpdateRgn', # 0x50
    'NtUserSetFocus', # 0x51
    'NtGdiExtGetObjectW', # 0x52
    'NtUserDeferWindowPos', # 0x53
    'NtUserGetUpdateRect', # 0x54
    'NtGdiCreateCompatibleDC', # 0x55
    'NtUserGetClipboardSequenceNumber', # 0x56
    'NtGdiCreatePen', # 0x57
    'NtUserShowWindow', # 0x58
    'NtUserGetKeyboardLayoutList', # 0x59
    'NtGdiPatBlt', # 0x5a
    'NtUserMapVirtualKeyEx', # 0x5b
    'NtUserSetWindowLong', # 0x5c
    'NtGdiHfontCreate', # 0x5d
    'NtUserMoveWindow', # 0x5e
    'NtUserPostThreadMessage', # 0x5f
    'NtUserDrawIconEx', # 0x60
    'NtUserGetSystemMenu', # 0x61
    'NtGdiDrawStream', # 0x62
    'NtUserInternalGetWindowText', # 0x63
    'NtUserGetWindowDC', # 0x64
    'NtGdiD3dDrawPrimitives2', # 0x65
    'NtGdiInvertRgn', # 0x66
    'NtGdiGetRgnBox', # 0x67
    'NtGdiGetAndSetDCDword', # 0x68
    'NtGdiMaskBlt', # 0x69
    'NtGdiGetWidthTable', # 0x6a
    'NtUserScrollDC', # 0x6b
    'NtUserGetObjectInformation', # 0x6c
    'NtGdiCreateBitmap', # 0x6d
    'NtGdiConsoleTextOut', # 0x6e
    'NtUserFindWindowEx', # 0x6f
    'NtGdiPolyPatBlt', # 0x70
    'NtUserUnhookWindowsHookEx', # 0x71
    'NtGdiGetNearestColor', # 0x72
    'NtGdiTransformPoints', # 0x73
    'NtGdiGetDCPoint', # 0x74
    'NtUserCheckImeHotKey', # 0x75
    'NtGdiCreateDIBBrush', # 0x76
    'NtGdiGetTextMetricsW', # 0x77
    'NtUserCreateWindowEx', # 0x78
    'NtUserSetParent', # 0x79
    'NtUserGetKeyboardState', # 0x7a
    'NtUserToUnicodeEx', # 0x7b
    'NtUserGetControlBrush', # 0x7c
    'NtUserGetClassName', # 0x7d
    'NtGdiAlphaBlend', # 0x7e
    'NtGdiDdBlt', # 0x7f
    'NtGdiOffsetRgn', # 0x80
    'NtUserDefSetText', # 0x81
    'NtGdiGetTextFaceW', # 0x82
    'NtGdiStretchDIBitsInternal', # 0x83
    'NtUserSendInput', # 0x84
    'NtUserGetThreadDesktop', # 0x85
    'NtGdiCreateRectRgn', # 0x86
    'NtGdiGetDIBitsInternal', # 0x87
    'NtUserGetUpdateRgn', # 0x88
    'NtGdiDeleteClientObj', # 0x89
    'NtUserGetIconSize', # 0x8a
    'NtUserFillWindow', # 0x8b
    'NtGdiExtCreateRegion', # 0x8c
    'NtGdiComputeXformCoefficients', # 0x8d
    'NtUserSetWindowsHookEx', # 0x8e
    'NtUserNotifyProcessCreate', # 0x8f
    'NtGdiUnrealizeObject', # 0x90
    'NtUserGetTitleBarInfo', # 0x91
    'NtGdiRectangle', # 0x92
    'NtUserSetThreadDesktop', # 0x93
    'NtUserGetDCEx', # 0x94
    'NtUserGetScrollBarInfo', # 0x95
    'NtGdiGetTextExtent', # 0x96
    'NtUserSetWindowFNID', # 0x97
    'NtGdiSetLayout', # 0x98
    'NtUserCalcMenuBar', # 0x99
    'NtUserThunkedMenuItemInfo', # 0x9a
    'NtGdiExcludeClipRect', # 0x9b
    'NtGdiCreateDIBSection', # 0x9c
    'NtGdiGetDCforBitmap', # 0x9d
    'NtUserDestroyCursor', # 0x9e
    'NtUserDestroyWindow', # 0x9f
    'NtUserCallHwndParam', # 0xa0
    'NtGdiCreateDIBitmapInternal', # 0xa1
    'NtUserOpenWindowStation', # 0xa2
    'NtGdiDdDeleteSurfaceObject', # 0xa3
    'NtGdiEnumFontClose', # 0xa4
    'NtGdiEnumFontOpen', # 0xa5
    'NtGdiEnumFontChunk', # 0xa6
    'NtGdiDdCanCreateSurface', # 0xa7
    'NtGdiDdCreateSurface', # 0xa8
    'NtUserSetCursorIconData', # 0xa9
    'NtGdiDdDestroySurface', # 0xaa
    'NtUserCloseDesktop', # 0xab
    'NtUserOpenDesktop', # 0xac
    'NtUserSetProcessWindowStation', # 0xad
    'NtUserGetAtomName', # 0xae
    'NtGdiDdResetVisrgn', # 0xaf
    'NtGdiExtCreatePen', # 0xb0
    'NtGdiCreatePaletteInternal', # 0xb1
    'NtGdiSetBrushOrg', # 0xb2
    'NtUserBuildNameList', # 0xb3
    'NtGdiSetPixel', # 0xb4
    'NtUserRegisterClassExWOW', # 0xb5
    'NtGdiCreatePatternBrushInternal', # 0xb6
    'NtUserGetAncestor', # 0xb7
    'NtGdiGetOutlineTextMetricsInternalW', # 0xb8
    'NtGdiSetBitmapBits', # 0xb9
    'NtUserCloseWindowStation', # 0xba
    'NtUserGetDoubleClickTime', # 0xbb
    'NtUserEnableScrollBar', # 0xbc
    'NtGdiCreateSolidBrush', # 0xbd
    'NtUserGetClassInfoEx', # 0xbe
    'NtGdiCreateClientObj', # 0xbf
    'NtUserUnregisterClass', # 0xc0
    'NtUserDeleteMenu', # 0xc1
    'NtGdiRectInRegion', # 0xc2
    'NtUserScrollWindowEx', # 0xc3
    'NtGdiGetPixel', # 0xc4
    'NtUserSetClassLong', # 0xc5
    'NtUserGetMenuBarInfo', # 0xc6
    'NtGdiDdCreateSurfaceEx', # 0xc7
    'NtGdiDdCreateSurfaceObject', # 0xc8
    'NtGdiGetNearestPaletteIndex', # 0xc9
    'NtGdiDdLockD3D', # 0xca
    'NtGdiDdUnlockD3D', # 0xcb
    'NtGdiGetCharWidthW', # 0xcc
    'NtUserInvalidateRgn', # 0xcd
    'NtUserGetClipboardOwner', # 0xce
    'NtUserSetWindowRgn', # 0xcf
    'NtUserBitBltSysBmp', # 0xd0
    'NtGdiGetCharWidthInfo', # 0xd1
    'NtUserValidateRect', # 0xd2
    'NtUserCloseClipboard', # 0xd3
    'NtUserOpenClipboard', # 0xd4
    'NtGdiGetStockObject', # 0xd5
    'NtUserSetClipboardData', # 0xd6
    'NtUserEnableMenuItem', # 0xd7
    'NtUserAlterWindowStyle', # 0xd8
    'NtGdiFillRgn', # 0xd9
    'NtUserGetWindowPlacement', # 0xda
    'NtGdiModifyWorldTransform', # 0xdb
    'NtGdiGetFontData', # 0xdc
    'NtUserGetOpenClipboardWindow', # 0xdd
    'NtUserSetThreadState', # 0xde
    'NtGdiOpenDCW', # 0xdf
    'NtUserTrackMouseEvent', # 0xe0
    'NtGdiGetTransform', # 0xe1
    'NtUserDestroyMenu', # 0xe2
    'NtGdiGetBitmapBits', # 0xe3
    'NtUserConsoleControl', # 0xe4
    'NtUserSetActiveWindow', # 0xe5
    'NtUserSetInformationThread', # 0xe6
    'NtUserSetWindowPlacement', # 0xe7
    'NtUserGetControlColor', # 0xe8
    'NtGdiSetMetaRgn', # 0xe9
    'NtGdiSetMiterLimit', # 0xea
    'NtGdiSetVirtualResolution', # 0xeb
    'NtGdiGetRasterizerCaps', # 0xec
    'NtUserSetWindowWord', # 0xed
    'NtUserGetClipboardFormatName', # 0xee
    'NtUserRealInternalGetMessage', # 0xef
    'NtUserCreateLocalMemHandle', # 0xf0
    'NtUserAttachThreadInput', # 0xf1
    'NtGdiCreateHalftonePalette', # 0xf2
    'NtUserPaintMenuBar', # 0xf3
    'NtUserSetKeyboardState', # 0xf4
    'NtGdiCombineTransform', # 0xf5
    'NtUserCreateAcceleratorTable', # 0xf6
    'NtUserGetCursorFrameInfo', # 0xf7
    'NtUserGetAltTabInfo', # 0xf8
    'NtUserGetCaretBlinkTime', # 0xf9
    'NtGdiQueryFontAssocInfo', # 0xfa
    'NtUserProcessConnect', # 0xfb
    'NtUserEnumDisplayDevices', # 0xfc
    'NtUserEmptyClipboard', # 0xfd
    'NtUserGetClipboardData', # 0xfe
    'NtUserRemoveMenu', # 0xff
    'NtGdiSetBoundsRect', # 0x100
    'NtUserSetInformationProcess', # 0x101
    'NtGdiGetBitmapDimension', # 0x102
    'NtUserConvertMemHandle', # 0x103
    'NtUserDestroyAcceleratorTable', # 0x104
    'NtUserGetGUIThreadInfo', # 0x105
    'NtGdiCloseFigure', # 0x106
    'NtUserSetWindowsHookAW', # 0x107
    'NtUserSetMenuDefaultItem', # 0x108
    'NtUserCheckMenuItem', # 0x109
    'NtUserSetWinEventHook', # 0x10a
    'NtUserUnhookWinEvent', # 0x10b
    'NtGdiSetupPublicCFONT', # 0x10c
    'NtUserLockWindowUpdate', # 0x10d
    'NtUserSetSystemMenu', # 0x10e
    'NtUserThunkedMenuInfo', # 0x10f
    'NtGdiBeginPath', # 0x110
    'NtGdiEndPath', # 0x111
    'NtGdiFillPath', # 0x112
    'NtUserCallHwnd', # 0x113
    'NtUserDdeInitialize', # 0x114
    'NtUserModifyUserStartupInfoFlags', # 0x115
    'NtUserCountClipboardFormats', # 0x116
    'NtGdiAddFontMemResourceEx', # 0x117
    'NtGdiEqualRgn', # 0x118
    'NtGdiGetSystemPaletteUse', # 0x119
    'NtGdiRemoveFontMemResourceEx', # 0x11a
    'NtUserEnumDisplaySettings', # 0x11b
    'NtUserPaintDesktop', # 0x11c
    'NtGdiExtEscape', # 0x11d
    'NtGdiSetBitmapDimension', # 0x11e
    'NtGdiSetFontEnumeration', # 0x11f
    'NtUserChangeClipboardChain', # 0x120
    'NtUserResolveDesktop', # 0x121
    'NtUserSetClipboardViewer', # 0x122
    'NtUserShowWindowAsync', # 0x123
    'NtUserSetConsoleReserveKeys', # 0x124
    'NtGdiCreateColorSpace', # 0x125
    'NtGdiDeleteColorSpace', # 0x126
    'NtUserActivateKeyboardLayout', # 0x127
    'NtGdiAbortDoc', # 0x128
    'NtGdiAbortPath', # 0x129
    'NtGdiAddEmbFontToDC', # 0x12a
    'NtGdiAddFontResourceW', # 0x12b
    'NtGdiAddRemoteFontToDC', # 0x12c
    'NtGdiAddRemoteMMInstanceToDC', # 0x12d
    'NtGdiAngleArc', # 0x12e
    'NtGdiAnyLinkedFonts', # 0x12f
    'NtGdiArcInternal', # 0x130
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x131
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x132
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x133
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x134
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x135
    'NtGdiCLIPOBJ_bEnum', # 0x136
    'NtGdiCLIPOBJ_cEnumStart', # 0x137
    'NtGdiCLIPOBJ_ppoGetPath', # 0x138
    'NtGdiCancelDC', # 0x139
    'NtGdiChangeGhostFont', # 0x13a
    'NtGdiCheckBitmapBits', # 0x13b
    'NtGdiClearBitmapAttributes', # 0x13c
    'NtGdiClearBrushAttributes', # 0x13d
    'NtGdiColorCorrectPalette', # 0x13e
    'NtGdiConfigureOPMProtectedOutput', # 0x13f
    'NtGdiConvertMetafileRect', # 0x140
    'NtGdiCreateColorTransform', # 0x141
    'NtGdiCreateEllipticRgn', # 0x142
    'NtGdiCreateHatchBrushInternal', # 0x143
    'NtGdiCreateMetafileDC', # 0x144
    'NtGdiCreateOPMProtectedOutputs', # 0x145
    'NtGdiCreateRoundRectRgn', # 0x146
    'NtGdiCreateServerMetaFile', # 0x147
    'NtGdiD3dContextCreate', # 0x148
    'NtGdiD3dContextDestroy', # 0x149
    'NtGdiD3dContextDestroyAll', # 0x14a
    'NtGdiD3dValidateTextureStageState', # 0x14b
    'NtGdiDDCCIGetCapabilitiesString', # 0x14c
    'NtGdiDDCCIGetCapabilitiesStringLength', # 0x14d
    'NtGdiDDCCIGetTimingReport', # 0x14e
    'NtGdiDDCCIGetVCPFeature', # 0x14f
    'NtGdiDDCCISaveCurrentSettings', # 0x150
    'NtGdiDDCCISetVCPFeature', # 0x151
    'NtGdiDdAddAttachedSurface', # 0x152
    'NtGdiDdAlphaBlt', # 0x153
    'NtGdiDdAttachSurface', # 0x154
    'NtGdiDdBeginMoCompFrame', # 0x155
    'NtGdiDdCanCreateD3DBuffer', # 0x156
    'NtGdiDdColorControl', # 0x157
    'NtGdiDdCreateD3DBuffer', # 0x158
    'NtGdiDdCreateDirectDrawObject', # 0x159
    'NtGdiDdCreateMoComp', # 0x15a
    'NtGdiDdDDICheckExclusiveOwnership', # 0x15b
    'NtGdiDdDDICheckMonitorPowerState', # 0x15c
    'NtGdiDdDDICheckOcclusion', # 0x15d
    'NtGdiDdDDICloseAdapter', # 0x15e
    'NtGdiDdDDICreateAllocation', # 0x15f
    'NtGdiDdDDICreateContext', # 0x160
    'NtGdiDdDDICreateDCFromMemory', # 0x161
    'NtGdiDdDDICreateDevice', # 0x162
    'NtGdiDdDDICreateOverlay', # 0x163
    'NtGdiDdDDICreateSynchronizationObject', # 0x164
    'NtGdiDdDDIDestroyAllocation', # 0x165
    'NtGdiDdDDIDestroyContext', # 0x166
    'NtGdiDdDDIDestroyDCFromMemory', # 0x167
    'NtGdiDdDDIDestroyDevice', # 0x168
    'NtGdiDdDDIDestroyOverlay', # 0x169
    'NtGdiDdDDIDestroySynchronizationObject', # 0x16a
    'NtGdiDdDDIEscape', # 0x16b
    'NtGdiDdDDIFlipOverlay', # 0x16c
    'NtGdiDdDDIGetContextSchedulingPriority', # 0x16d
    'NtGdiDdDDIGetDeviceState', # 0x16e
    'NtGdiDdDDIGetDisplayModeList', # 0x16f
    'NtGdiDdDDIGetMultisampleMethodList', # 0x170
    'NtGdiDdDDIGetPresentHistory', # 0x171
    'NtGdiDdDDIGetProcessSchedulingPriorityClass', # 0x172
    'NtGdiDdDDIGetRuntimeData', # 0x173
    'NtGdiDdDDIGetScanLine', # 0x174
    'NtGdiDdDDIGetSharedPrimaryHandle', # 0x175
    'NtGdiDdDDIInvalidateActiveVidPn', # 0x176
    'NtGdiDdDDILock', # 0x177
    'NtGdiDdDDIOpenAdapterFromDeviceName', # 0x178
    'NtGdiDdDDIOpenAdapterFromHdc', # 0x179
    'NtGdiDdDDIOpenResource', # 0x17a
    'NtGdiDdDDIPollDisplayChildren', # 0x17b
    'NtGdiDdDDIPresent', # 0x17c
    'NtGdiDdDDIQueryAdapterInfo', # 0x17d
    'NtGdiDdDDIQueryAllocationResidency', # 0x17e
    'NtGdiDdDDIQueryResourceInfo', # 0x17f
    'NtGdiDdDDIQueryStatistics', # 0x180
    'NtGdiDdDDIReleaseProcessVidPnSourceOwners', # 0x181
    'NtGdiDdDDIRender', # 0x182
    'NtGdiDdDDISetAllocationPriority', # 0x183
    'NtGdiDdDDISetContextSchedulingPriority', # 0x184
    'NtGdiDdDDISetDisplayMode', # 0x185
    'NtGdiDdDDISetDisplayPrivateDriverFormat', # 0x186
    'NtGdiDdDDISetGammaRamp', # 0x187
    'NtGdiDdDDISetProcessSchedulingPriorityClass', # 0x188
    'NtGdiDdDDISetQueuedLimit', # 0x189
    'NtGdiDdDDISetVidPnSourceOwner', # 0x18a
    'NtGdiDdDDISharedPrimaryLockNotification', # 0x18b
    'NtGdiDdDDISharedPrimaryUnLockNotification', # 0x18c
    'NtGdiDdDDISignalSynchronizationObject', # 0x18d
    'NtGdiDdDDIUnlock', # 0x18e
    'NtGdiDdDDIUpdateOverlay', # 0x18f
    'NtGdiDdDDIWaitForIdle', # 0x190
    'NtGdiDdDDIWaitForSynchronizationObject', # 0x191
    'NtGdiDdDDIWaitForVerticalBlankEvent', # 0x192
    'NtGdiDdDeleteDirectDrawObject', # 0x193
    'NtGdiDdDestroyD3DBuffer', # 0x194
    'NtGdiDdDestroyMoComp', # 0x195
    'NtGdiDdEndMoCompFrame', # 0x196
    'NtGdiDdFlip', # 0x197
    'NtGdiDdFlipToGDISurface', # 0x198
    'NtGdiDdGetAvailDriverMemory', # 0x199
    'NtGdiDdGetBltStatus', # 0x19a
    'NtGdiDdGetDC', # 0x19b
    'NtGdiDdGetDriverInfo', # 0x19c
    'NtGdiDdGetDriverState', # 0x19d
    'NtGdiDdGetDxHandle', # 0x19e
    'NtGdiDdGetFlipStatus', # 0x19f
    'NtGdiDdGetInternalMoCompInfo', # 0x1a0
    'NtGdiDdGetMoCompBuffInfo', # 0x1a1
    'NtGdiDdGetMoCompFormats', # 0x1a2
    'NtGdiDdGetMoCompGuids', # 0x1a3
    'NtGdiDdGetScanLine', # 0x1a4
    'NtGdiDdLock', # 0x1a5
    'NtGdiDdQueryDirectDrawObject', # 0x1a6
    'NtGdiDdQueryMoCompStatus', # 0x1a7
    'NtGdiDdReenableDirectDrawObject', # 0x1a8
    'NtGdiDdReleaseDC', # 0x1a9
    'NtGdiDdRenderMoComp', # 0x1aa
    'NtGdiDdSetColorKey', # 0x1ab
    'NtGdiDdSetExclusiveMode', # 0x1ac
    'NtGdiDdSetGammaRamp', # 0x1ad
    'NtGdiDdSetOverlayPosition', # 0x1ae
    'NtGdiDdUnattachSurface', # 0x1af
    'NtGdiDdUnlock', # 0x1b0
    'NtGdiDdUpdateOverlay', # 0x1b1
    'NtGdiDdWaitForVerticalBlank', # 0x1b2
    'NtGdiDeleteColorTransform', # 0x1b3
    'NtGdiDescribePixelFormat', # 0x1b4
    'NtGdiDestroyOPMProtectedOutput', # 0x1b5
    'NtGdiDestroyPhysicalMonitor', # 0x1b6
    'NtGdiDoBanding', # 0x1b7
    'NtGdiDrawEscape', # 0x1b8
    'NtGdiDvpAcquireNotification', # 0x1b9
    'NtGdiDvpCanCreateVideoPort', # 0x1ba
    'NtGdiDvpColorControl', # 0x1bb
    'NtGdiDvpCreateVideoPort', # 0x1bc
    'NtGdiDvpDestroyVideoPort', # 0x1bd
    'NtGdiDvpFlipVideoPort', # 0x1be
    'NtGdiDvpGetVideoPortBandwidth', # 0x1bf
    'NtGdiDvpGetVideoPortConnectInfo', # 0x1c0
    'NtGdiDvpGetVideoPortField', # 0x1c1
    'NtGdiDvpGetVideoPortFlipStatus', # 0x1c2
    'NtGdiDvpGetVideoPortInputFormats', # 0x1c3
    'NtGdiDvpGetVideoPortLine', # 0x1c4
    'NtGdiDvpGetVideoPortOutputFormats', # 0x1c5
    'NtGdiDvpGetVideoSignalStatus', # 0x1c6
    'NtGdiDvpReleaseNotification', # 0x1c7
    'NtGdiDvpUpdateVideoPort', # 0x1c8
    'NtGdiDvpWaitForVideoPortSync', # 0x1c9
    'NtGdiDwmGetDirtyRgn', # 0x1ca
    'NtGdiDwmGetSurfaceData', # 0x1cb
    'NtGdiDxgGenericThunk', # 0x1cc
    'NtGdiEllipse', # 0x1cd
    'NtGdiEnableEudc', # 0x1ce
    'NtGdiEndDoc', # 0x1cf
    'NtGdiEndPage', # 0x1d0
    'NtGdiEngAlphaBlend', # 0x1d1
    'NtGdiEngAssociateSurface', # 0x1d2
    'NtGdiEngBitBlt', # 0x1d3
    'NtGdiEngCheckAbort', # 0x1d4
    'NtGdiEngComputeGlyphSet', # 0x1d5
    'NtGdiEngCopyBits', # 0x1d6
    'NtGdiEngCreateBitmap', # 0x1d7
    'NtGdiEngCreateClip', # 0x1d8
    'NtGdiEngCreateDeviceBitmap', # 0x1d9
    'NtGdiEngCreateDeviceSurface', # 0x1da
    'NtGdiEngCreatePalette', # 0x1db
    'NtGdiEngDeleteClip', # 0x1dc
    'NtGdiEngDeletePalette', # 0x1dd
    'NtGdiEngDeletePath', # 0x1de
    'NtGdiEngDeleteSurface', # 0x1df
    'NtGdiEngEraseSurface', # 0x1e0
    'NtGdiEngFillPath', # 0x1e1
    'NtGdiEngGradientFill', # 0x1e2
    'NtGdiEngLineTo', # 0x1e3
    'NtGdiEngLockSurface', # 0x1e4
    'NtGdiEngMarkBandingSurface', # 0x1e5
    'NtGdiEngPaint', # 0x1e6
    'NtGdiEngPlgBlt', # 0x1e7
    'NtGdiEngStretchBlt', # 0x1e8
    'NtGdiEngStretchBltROP', # 0x1e9
    'NtGdiEngStrokeAndFillPath', # 0x1ea
    'NtGdiEngStrokePath', # 0x1eb
    'NtGdiEngTextOut', # 0x1ec
    'NtGdiEngTransparentBlt', # 0x1ed
    'NtGdiEngUnlockSurface', # 0x1ee
    'NtGdiEnumObjects', # 0x1ef
    'NtGdiEudcLoadUnloadLink', # 0x1f0
    'NtGdiExtFloodFill', # 0x1f1
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x1f2
    'NtGdiFONTOBJ_cGetGlyphs', # 0x1f3
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x1f4
    'NtGdiFONTOBJ_pfdg', # 0x1f5
    'NtGdiFONTOBJ_pifi', # 0x1f6
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x1f7
    'NtGdiFONTOBJ_pxoGetXform', # 0x1f8
    'NtGdiFONTOBJ_vGetInfo', # 0x1f9
    'NtGdiFlattenPath', # 0x1fa
    'NtGdiFontIsLinked', # 0x1fb
    'NtGdiForceUFIMapping', # 0x1fc
    'NtGdiFrameRgn', # 0x1fd
    'NtGdiFullscreenControl', # 0x1fe
    'NtGdiGetBoundsRect', # 0x1ff
    'NtGdiGetCOPPCompatibleOPMInformation', # 0x200
    'NtGdiGetCertificate', # 0x201
    'NtGdiGetCertificateSize', # 0x202
    'NtGdiGetCharABCWidthsW', # 0x203
    'NtGdiGetCharacterPlacementW', # 0x204
    'NtGdiGetColorAdjustment', # 0x205
    'NtGdiGetColorSpaceforBitmap', # 0x206
    'NtGdiGetDeviceCaps', # 0x207
    'NtGdiGetDeviceCapsAll', # 0x208
    'NtGdiGetDeviceGammaRamp', # 0x209
    'NtGdiGetDeviceWidth', # 0x20a
    'NtGdiGetDhpdev', # 0x20b
    'NtGdiGetETM', # 0x20c
    'NtGdiGetEmbUFI', # 0x20d
    'NtGdiGetEmbedFonts', # 0x20e
    'NtGdiGetEudcTimeStampEx', # 0x20f
    'NtGdiGetFontResourceInfoInternalW', # 0x210
    'NtGdiGetFontUnicodeRanges', # 0x211
    'NtGdiGetGlyphIndicesW', # 0x212
    'NtGdiGetGlyphIndicesWInternal', # 0x213
    'NtGdiGetGlyphOutline', # 0x214
    'NtGdiGetKerningPairs', # 0x215
    'NtGdiGetLinkedUFIs', # 0x216
    'NtGdiGetMiterLimit', # 0x217
    'NtGdiGetMonitorID', # 0x218
    'NtGdiGetNumberOfPhysicalMonitors', # 0x219
    'NtGdiGetOPMInformation', # 0x21a
    'NtGdiGetOPMRandomNumber', # 0x21b
    'NtGdiGetObjectBitmapHandle', # 0x21c
    'NtGdiGetPath', # 0x21d
    'NtGdiGetPerBandInfo', # 0x21e
    'NtGdiGetPhysicalMonitorDescription', # 0x21f
    'NtGdiGetPhysicalMonitors', # 0x220
    'NtGdiGetRealizationInfo', # 0x221
    'NtGdiGetServerMetaFileBits', # 0x222
    'NtGdiGetSpoolMessage', # 0x223
    'NtGdiGetStats', # 0x224
    'NtGdiGetStringBitmapW', # 0x225
    'NtGdiGetSuggestedOPMProtectedOutputArraySize', # 0x226
    'NtGdiGetTextExtentExW', # 0x227
    'NtGdiGetUFI', # 0x228
    'NtGdiGetUFIPathname', # 0x229
    'NtGdiGradientFill', # 0x22a
    'NtGdiHT_Get8BPPFormatPalette', # 0x22b
    'NtGdiHT_Get8BPPMaskPalette', # 0x22c
    'NtGdiIcmBrushInfo', # 0x22d
    'NtGdiInit', # 0x22e
    'NtGdiInitSpool', # 0x22f
    'NtGdiMakeFontDir', # 0x230
    'NtGdiMakeInfoDC', # 0x231
    'NtGdiMakeObjectUnXferable', # 0x232
    'NtGdiMakeObjectXferable', # 0x233
    'NtGdiMirrorWindowOrg', # 0x234
    'NtGdiMonoBitmap', # 0x235
    'NtGdiMoveTo', # 0x236
    'NtGdiOffsetClipRgn', # 0x237
    'NtGdiPATHOBJ_bEnum', # 0x238
    'NtGdiPATHOBJ_bEnumClipLines', # 0x239
    'NtGdiPATHOBJ_vEnumStart', # 0x23a
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x23b
    'NtGdiPATHOBJ_vGetBounds', # 0x23c
    'NtGdiPathToRegion', # 0x23d
    'NtGdiPlgBlt', # 0x23e
    'NtGdiPolyDraw', # 0x23f
    'NtGdiPolyTextOutW', # 0x240
    'NtGdiPtInRegion', # 0x241
    'NtGdiPtVisible', # 0x242
    'NtGdiQueryFonts', # 0x243
    'NtGdiRemoveFontResourceW', # 0x244
    'NtGdiRemoveMergeFont', # 0x245
    'NtGdiResetDC', # 0x246
    'NtGdiResizePalette', # 0x247
    'NtGdiRoundRect', # 0x248
    'NtGdiSTROBJ_bEnum', # 0x249
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x24a
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x24b
    'NtGdiSTROBJ_dwGetCodePage', # 0x24c
    'NtGdiSTROBJ_vEnumStart', # 0x24d
    'NtGdiScaleViewportExtEx', # 0x24e
    'NtGdiScaleWindowExtEx', # 0x24f
    'NtGdiSelectBrush', # 0x250
    'NtGdiSelectClipPath', # 0x251
    'NtGdiSelectPen', # 0x252
    'NtGdiSetBitmapAttributes', # 0x253
    'NtGdiSetBrushAttributes', # 0x254
    'NtGdiSetColorAdjustment', # 0x255
    'NtGdiSetColorSpace', # 0x256
    'NtGdiSetDeviceGammaRamp', # 0x257
    'NtGdiSetFontXform', # 0x258
    'NtGdiSetIcmMode', # 0x259
    'NtGdiSetLinkedUFIs', # 0x25a
    'NtGdiSetMagicColors', # 0x25b
    'NtGdiSetOPMSigningKeyAndSequenceNumbers', # 0x25c
    'NtGdiSetPUMPDOBJ', # 0x25d
    'NtGdiSetPixelFormat', # 0x25e
    'NtGdiSetRectRgn', # 0x25f
    'NtGdiSetSizeDevice', # 0x260
    'NtGdiSetSystemPaletteUse', # 0x261
    'NtGdiSetTextJustification', # 0x262
    'NtGdiStartDoc', # 0x263
    'NtGdiStartPage', # 0x264
    'NtGdiStrokeAndFillPath', # 0x265
    'NtGdiStrokePath', # 0x266
    'NtGdiSwapBuffers', # 0x267
    'NtGdiTransparentBlt', # 0x268
    'NtGdiUMPDEngFreeUserMem', # 0x269
    'NtGdiUnloadPrinterDriver', # 0x26a
    'EngRestoreFloatingPointState', # 0x26b
    'NtGdiUpdateColors', # 0x26c
    'NtGdiUpdateTransform', # 0x26d
    'NtGdiWidenPath', # 0x26e
    'NtGdiXFORMOBJ_bApplyXform', # 0x26f
    'NtGdiXFORMOBJ_iGetXform', # 0x270
    'NtGdiXLATEOBJ_cGetPalette', # 0x271
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x272
    'NtGdiXLATEOBJ_iXlate', # 0x273
    'NtUserAddClipboardFormatListener', # 0x274
    'NtUserAssociateInputContext', # 0x275
    'NtUserBlockInput', # 0x276
    'NtUserBuildHimcList', # 0x277
    'NtUserBuildPropList', # 0x278
    'NtUserCallHwndOpt', # 0x279
    'NtUserChangeDisplaySettings', # 0x27a
    'NtUserCheckAccessForIntegrityLevel', # 0x27b
    'NtUserCheckDesktopByThreadId', # 0x27c
    'NtUserCheckWindowThreadDesktop', # 0x27d
    'NtUserChildWindowFromPointEx', # 0x27e
    'NtUserClipCursor', # 0x27f
    'NtUserCreateDesktopEx', # 0x280
    'NtUserCreateInputContext', # 0x281
    'NtUserCreateWindowStation', # 0x282
    'NtUserCtxDisplayIOCtl', # 0x283
    'NtUserDestroyInputContext', # 0x284
    'NtUserDisableThreadIme', # 0x285
    'NtUserDoSoundConnect', # 0x286
    'NtUserDoSoundDisconnect', # 0x287
    'NtUserDragDetect', # 0x288
    'NtUserDragObject', # 0x289
    'NtUserDrawAnimatedRects', # 0x28a
    'NtUserDrawCaption', # 0x28b
    'NtUserDrawCaptionTemp', # 0x28c
    'NtUserDrawMenuBarTemp', # 0x28d
    'NtUserDwmGetDxRgn', # 0x28e
    'NtUserDwmHintDxUpdate', # 0x28f
    'NtUserDwmStartRedirection', # 0x290
    'NtUserDwmStopRedirection', # 0x291
    'NtUserEndMenu', # 0x292
    'NtUserEvent', # 0x293
    'NtUserFlashWindowEx', # 0x294
    'NtUserFrostCrashedWindow', # 0x295
    'NtUserGetAppImeLevel', # 0x296
    'NtUserGetCaretPos', # 0x297
    'NtUserGetClipCursor', # 0x298
    'NtUserGetClipboardViewer', # 0x299
    'NtUserGetComboBoxInfo', # 0x29a
    'NtUserGetCursorInfo', # 0x29b
    'NtUserGetGuiResources', # 0x29c
    'NtUserGetImeHotKey', # 0x29d
    'NtUserGetImeInfoEx', # 0x29e
    'NtUserGetInternalWindowPos', # 0x29f
    'NtUserGetKeyNameText', # 0x2a0
    'NtUserGetKeyboardLayoutName', # 0x2a1
    'NtUserGetLayeredWindowAttributes', # 0x2a2
    'NtUserGetListBoxInfo', # 0x2a3
    'NtUserGetMenuIndex', # 0x2a4
    'NtUserGetMenuItemRect', # 0x2a5
    'NtUserGetMouseMovePointsEx', # 0x2a6
    'NtUserGetPriorityClipboardFormat', # 0x2a7
    'NtUserGetRawInputBuffer', # 0x2a8
    'NtUserGetRawInputData', # 0x2a9
    'NtUserGetRawInputDeviceInfo', # 0x2aa
    'NtUserGetRawInputDeviceList', # 0x2ab
    'NtUserGetRegisteredRawInputDevices', # 0x2ac
    'NtUserGetUpdatedClipboardFormats', # 0x2ad
    'NtUserGetWOWClass', # 0x2ae
    'NtUserGetWindowMinimizeRect', # 0x2af
    'NtUserGetWindowRgnEx', # 0x2b0
    'NtUserGhostWindowFromHungWindow', # 0x2b1
    'NtUserHardErrorControl', # 0x2b2
    'NtUserHiliteMenuItem', # 0x2b3
    'NtUserHungWindowFromGhostWindow', # 0x2b4
    'NtUserImpersonateDdeClientWindow', # 0x2b5
    'NtUserInitTask', # 0x2b6
    'NtUserInitialize', # 0x2b7
    'NtUserInitializeClientPfnArrays', # 0x2b8
    'NtUserInternalGetWindowIcon', # 0x2b9
    'NtUserLoadKeyboardLayoutEx', # 0x2ba
    'NtUserLockWindowStation', # 0x2bb
    'NtUserLockWorkStation', # 0x2bc
    'NtUserLogicalToPhysicalPoint', # 0x2bd
    'NtUserMNDragLeave', # 0x2be
    'NtUserMNDragOver', # 0x2bf
    'NtUserMenuItemFromPoint', # 0x2c0
    'NtUserMinMaximize', # 0x2c1
    'NtUserNotifyIMEStatus', # 0x2c2
    'NtUserOpenInputDesktop', # 0x2c3
    'NtUserOpenThreadDesktop', # 0x2c4
    'NtUserPaintMonitor', # 0x2c5
    'NtUserPhysicalToLogicalPoint', # 0x2c6
    'NtUserPrintWindow', # 0x2c7
    'NtUserQueryInformationThread', # 0x2c8
    'NtUserQueryInputContext', # 0x2c9
    'NtUserQuerySendMessage', # 0x2ca
    'NtUserRealChildWindowFromPoint', # 0x2cb
    'NtUserRealWaitMessageEx', # 0x2cc
    'NtUserRegisterErrorReportingDialog', # 0x2cd
    'NtUserRegisterHotKey', # 0x2ce
    'NtUserRegisterRawInputDevices', # 0x2cf
    'NtUserRegisterSessionPort', # 0x2d0
    'NtUserRegisterTasklist', # 0x2d1
    'NtUserRegisterUserApiHook', # 0x2d2
    'NtUserRemoteConnect', # 0x2d3
    'NtUserRemoteRedrawRectangle', # 0x2d4
    'NtUserRemoteRedrawScreen', # 0x2d5
    'NtUserRemoteStopScreenUpdates', # 0x2d6
    'NtUserRemoveClipboardFormatListener', # 0x2d7
    'NtUserResolveDesktopForWOW', # 0x2d8
    'NtUserSetAppImeLevel', # 0x2d9
    'NtUserSetClassWord', # 0x2da
    'NtUserSetCursorContents', # 0x2db
    'NtUserSetImeHotKey', # 0x2dc
    'NtUserSetImeInfoEx', # 0x2dd
    'NtUserSetImeOwnerWindow', # 0x2de
    'NtUserSetInternalWindowPos', # 0x2df
    'NtUserSetLayeredWindowAttributes', # 0x2e0
    'NtUserSetMenu', # 0x2e1
    'NtUserSetMenuContextHelpId', # 0x2e2
    'NtUserSetMenuFlagRtoL', # 0x2e3
    'NtUserSetMirrorRendering', # 0x2e4
    'NtUserSetObjectInformation', # 0x2e5
    'NtUserSetProcessDPIAware', # 0x2e6
    'NtUserSetShellWindowEx', # 0x2e7
    'NtUserSetSysColors', # 0x2e8
    'NtUserSetSystemCursor', # 0x2e9
    'NtUserSetSystemTimer', # 0x2ea
    'NtUserSetThreadLayoutHandles', # 0x2eb
    'NtUserSetWindowRgnEx', # 0x2ec
    'NtUserSetWindowStationUser', # 0x2ed
    'NtUserShowSystemCursor', # 0x2ee
    'NtUserSoundSentry', # 0x2ef
    'NtUserSwitchDesktop', # 0x2f0
    'NtUserTestForInteractiveUser', # 0x2f1
    'NtUserTrackPopupMenuEx', # 0x2f2
    'NtUserUnloadKeyboardLayout', # 0x2f3
    'NtUserUnlockWindowStation', # 0x2f4
    'NtUserUnregisterHotKey', # 0x2f5
    'NtUserUnregisterSessionPort', # 0x2f6
    'NtUserUnregisterUserApiHook', # 0x2f7
    'NtUserUpdateInputContext', # 0x2f8
    'NtUserUpdateInstance', # 0x2f9
    'NtUserUpdateLayeredWindow', # 0x2fa
    'NtUserUpdatePerUserSystemParameters', # 0x2fb
    'NtUserUpdateWindowTransform', # 0x2fc
    'NtUserUserHandleGrantAccess', # 0x2fd
    'NtUserValidateHandleSecure', # 0x2fe
    'NtUserWaitForInputIdle', # 0x2ff
    'NtUserWaitForMsgAndEvent', # 0x300
    'NtUserWin32PoolAllocationStats', # 0x301
    'NtUserWindowFromPhysicalPoint', # 0x302
    'NtUserYieldTask', # 0x303
    'NtUserSetClassLongPtr', # 0x304
    'NtUserSetWindowLongPtr', # 0x305
    ],
]
