/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetObjectMonitors
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() != 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "object ID");
        ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, Rep.getObjectMonitorsRep(oRef), true, false);
    }

    public Object clone() {
        return new GetObjectMonitors();
    }
}

