/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SampleTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static Font defaultFont;
    protected static ImageIcon collapsedIcon;
    protected static ImageIcon expandedIcon;
    protected static final Color SELECTED_BACKGROUND_COLOR;
    protected boolean selected;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setToolTipText(stringValue);
        if (expanded) {
            this.setIcon(expandedIcon);
        } else if (!leaf) {
            this.setIcon(collapsedIcon);
        } else {
            this.setIcon(null);
        }
        SampleData userObject = (SampleData)((DefaultMutableTreeNode)value).getUserObject();
        if (hasFocus) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(userObject.getColor());
        }
        if (userObject.getFont() == null) {
            this.setFont(defaultFont);
        } else {
            this.setFont(userObject.getFont());
        }
        this.selected = selected;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Icon currentI = this.getIcon();
        Color bColor = this.selected ? SELECTED_BACKGROUND_COLOR : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        g.setColor(bColor);
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }

    static {
        SELECTED_BACKGROUND_COLOR = "Nimbus".equals(UIManager.getLookAndFeel().getName()) ? new Color(0, 0, 0, 0) : Color.YELLOW;
        try {
            defaultFont = new Font("SansSerif", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            collapsedIcon = new ImageIcon(SampleTreeCellRenderer.class.getResource("/resources/images/collapsed.gif"));
            expandedIcon = new ImageIcon(SampleTreeCellRenderer.class.getResource("/resources/images/expanded.gif"));
        }
        catch (Exception e) {
            System.out.println("Couldn't load images: " + e);
        }
    }
}

