/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DirectDoubleBufferU;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferRU
extends DirectDoubleBufferU
implements DirectBuffer {
    DirectDoubleBufferRU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(db, mark, pos, lim, cap, off);
    }

    @Override
    public DoubleBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 3;
        assert (off >= 0);
        return new DirectDoubleBufferRU(this, -1, 0, rem, rem, off);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public DoubleBuffer put(double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(int i, double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(DoubleBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(double[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

