/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

public class SpinnerListModel
extends AbstractSpinnerModel
implements Serializable {
    private List list;
    private int index;

    public SpinnerListModel(List<?> values) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("SpinnerListModel(List) expects non-null non-empty List");
        }
        this.list = values;
        this.index = 0;
    }

    public SpinnerListModel(Object[] values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("SpinnerListModel(Object[]) expects non-null non-empty Object[]");
        }
        this.list = Arrays.asList(values);
        this.index = 0;
    }

    public SpinnerListModel() {
        this(new Object[]{"empty"});
    }

    public List<?> getList() {
        return this.list;
    }

    public void setList(List<?> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("invalid list");
        }
        if (!list.equals(this.list)) {
            this.list = list;
            this.index = 0;
            this.fireStateChanged();
        }
    }

    @Override
    public Object getValue() {
        return this.list.get(this.index);
    }

    @Override
    public void setValue(Object elt) {
        int index = this.list.indexOf(elt);
        if (index == -1) {
            throw new IllegalArgumentException("invalid sequence element");
        }
        if (index != this.index) {
            this.index = index;
            this.fireStateChanged();
        }
    }

    @Override
    public Object getNextValue() {
        return this.index >= this.list.size() - 1 ? null : this.list.get(this.index + 1);
    }

    @Override
    public Object getPreviousValue() {
        return this.index <= 0 ? null : this.list.get(this.index - 1);
    }

    Object findNextMatch(String substring) {
        int max = this.list.size();
        if (max == 0) {
            return null;
        }
        int counter = this.index;
        do {
            Object value;
            String string;
            if ((string = (value = this.list.get(counter)).toString()) == null || !string.startsWith(substring)) continue;
            return value;
        } while ((counter = (counter + 1) % max) != this.index);
        return null;
    }
}

