/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XWindow;

public class XMenuItemPeer
implements MenuItemPeer {
    private XBaseMenuWindow container;
    private MenuItem target;
    private Rectangle bounds;
    private Point textOrigin;
    private static final int SEPARATOR_WIDTH = 20;
    private static final int SEPARATOR_HEIGHT = 5;
    private TextMetrics textMetrics;

    XMenuItemPeer(MenuItem target) {
        this.target = target;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setFont(Font font) {
        this.resetTextMetrics();
        this.repaintIfShowing();
    }

    @Override
    public void setLabel(String label) {
        this.resetTextMetrics();
        this.repaintIfShowing();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repaintIfShowing();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    MenuItem getTarget() {
        return this.target;
    }

    Font getTargetFont() {
        if (this.target == null) {
            return XWindow.getDefaultFont();
        }
        return AWTAccessor.getMenuComponentAccessor().getFont_NoClientCode(this.target);
    }

    String getTargetLabel() {
        if (this.target == null) {
            return "";
        }
        String label = AWTAccessor.getMenuItemAccessor().getLabel(this.target);
        return label == null ? "" : label;
    }

    boolean isTargetEnabled() {
        if (this.target == null) {
            return false;
        }
        return AWTAccessor.getMenuItemAccessor().isEnabled(this.target);
    }

    boolean isTargetItemEnabled() {
        if (this.target == null) {
            return false;
        }
        return AWTAccessor.getMenuItemAccessor().isItemEnabled(this.target);
    }

    String getTargetActionCommand() {
        if (this.target == null) {
            return "";
        }
        return AWTAccessor.getMenuItemAccessor().getActionCommandImpl(this.target);
    }

    MenuShortcut getTargetShortcut() {
        if (this.target == null) {
            return null;
        }
        return AWTAccessor.getMenuItemAccessor().getShortcut(this.target);
    }

    String getShortcutText() {
        if (this.container == null) {
            return null;
        }
        if (this.container.getRootMenuWindow() instanceof XPopupMenuPeer) {
            return null;
        }
        MenuShortcut sc = this.getTargetShortcut();
        return sc == null ? null : sc.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContainer(XBaseMenuWindow container) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            this.container = container;
        }
    }

    XBaseMenuWindow getContainer() {
        return this.container;
    }

    boolean isSeparator() {
        boolean r = this.getTargetLabel().equals("-");
        return r;
    }

    boolean isContainerShowing() {
        if (this.container == null) {
            return false;
        }
        return this.container.isShowing();
    }

    void repaintIfShowing() {
        if (this.isContainerShowing()) {
            this.container.postPaintEvent();
        }
    }

    void action(long when) {
        if (!this.isSeparator() && this.isTargetItemEnabled()) {
            XWindow.postEventStatic(new ActionEvent(this.target, 1001, this.getTargetActionCommand(), when, 0));
        }
    }

    TextMetrics getTextMetrics() {
        TextMetrics textMetrics = this.textMetrics;
        if (textMetrics == null) {
            this.textMetrics = textMetrics = this.calcTextMetrics();
        }
        return textMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TextMetrics calcTextMetrics() {
        if (this.container == null) {
            return null;
        }
        if (this.isSeparator()) {
            return new TextMetrics(new Dimension(20, 5), 0, 0);
        }
        Graphics g = this.container.getGraphics();
        if (g == null) {
            return null;
        }
        try {
            g.setFont(this.getTargetFont());
            FontMetrics fm = g.getFontMetrics();
            String str = this.getTargetLabel();
            int width = fm.stringWidth(str);
            int height = fm.getHeight();
            Dimension textDimension = new Dimension(width, height);
            int textBaseline = fm.getHeight() - fm.getAscent();
            String sc = this.getShortcutText();
            int shortcutWidth = sc == null ? 0 : fm.stringWidth(sc);
            TextMetrics textMetrics = new TextMetrics(textDimension, shortcutWidth, textBaseline);
            return textMetrics;
        }
        finally {
            g.dispose();
        }
    }

    void resetTextMetrics() {
        this.textMetrics = null;
        if (this.container != null) {
            this.container.updateSize();
        }
    }

    void map(Rectangle bounds, Point textOrigin) {
        this.bounds = bounds;
        this.textOrigin = textOrigin;
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    Point getTextOrigin() {
        return this.textOrigin;
    }

    static class TextMetrics
    implements Cloneable {
        private Dimension textDimension;
        private int shortcutWidth;
        private int textBaseline;

        TextMetrics(Dimension textDimension, int shortcutWidth, int textBaseline) {
            this.textDimension = textDimension;
            this.shortcutWidth = shortcutWidth;
            this.textBaseline = textBaseline;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        Dimension getTextDimension() {
            return this.textDimension;
        }

        int getShortcutWidth() {
            return this.shortcutWidth;
        }

        int getTextBaseline() {
            return this.textBaseline;
        }
    }
}

