/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;

class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");
    private List<PKIXCertPathChecker> certPathCheckers;

    PKIXMasterCertPathValidator(List<PKIXCertPathChecker> certPathCheckers) {
        this.certPathCheckers = certPathCheckers;
    }

    void validate(CertPath cpOriginal, List<X509Certificate> reversedCertList) throws CertPathValidatorException {
        int cpSize = reversedCertList.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        for (int i = 0; i < cpSize; ++i) {
            X509Certificate currCert;
            Set<String> unresolvedCritExts;
            if (debug != null) {
                debug.println("Checking cert" + (i + 1) + " ...");
            }
            if ((unresolvedCritExts = (currCert = reversedCertList.get(i)).getCriticalExtensionOIDs()) == null) {
                unresolvedCritExts = Collections.emptySet();
            }
            if (debug != null && !unresolvedCritExts.isEmpty()) {
                debug.println("Set of critical extensions:");
                for (String oid : unresolvedCritExts) {
                    debug.println(oid);
                }
            }
            CertPathValidatorException ocspCause = null;
            for (int j = 0; j < this.certPathCheckers.size(); ++j) {
                block20: {
                    PKIXCertPathChecker currChecker = this.certPathCheckers.get(j);
                    if (debug != null) {
                        debug.println("-Using checker" + (j + 1) + " ... [" + currChecker.getClass().getName() + "]");
                    }
                    if (i == 0) {
                        currChecker.init(false);
                    }
                    try {
                        currChecker.check(currCert, unresolvedCritExts);
                        if (PKIXMasterCertPathValidator.isRevocationCheck(currChecker, j, this.certPathCheckers)) {
                            if (debug != null) {
                                debug.println("-checker" + (j + 1) + " validation succeeded");
                            }
                            ++j;
                            continue;
                        }
                    }
                    catch (CertPathValidatorException cpve) {
                        if (ocspCause != null && currChecker instanceof CrlRevocationChecker) {
                            if (cpve.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                                throw cpve;
                            }
                            throw ocspCause;
                        }
                        CertPathValidatorException currentCause = new CertPathValidatorException(cpve.getMessage(), cpve.getCause() != null ? cpve.getCause() : cpve, cpOriginal, cpSize - (i + 1), cpve.getReason());
                        if (cpve.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                            throw currentCause;
                        }
                        if (!PKIXMasterCertPathValidator.isRevocationCheck(currChecker, j, this.certPathCheckers)) {
                            throw currentCause;
                        }
                        ocspCause = currentCause;
                        if (debug == null) break block20;
                        debug.println(cpve.getMessage());
                        debug.println("preparing to failover (from OCSP to CRLs)");
                    }
                }
                if (debug == null) continue;
                debug.println("-checker" + (j + 1) + " validation succeeded");
            }
            if (debug != null) {
                debug.println("checking for unresolvedCritExts");
            }
            if (!unresolvedCritExts.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, cpOriginal, cpSize - (i + 1), PKIXReason.UNRECOGNIZED_CRIT_EXT);
            }
            if (debug == null) continue;
            debug.println("\ncert" + (i + 1) + " validation succeeded.\n");
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }

    private static boolean isRevocationCheck(PKIXCertPathChecker checker, int index, List<PKIXCertPathChecker> checkers) {
        PKIXCertPathChecker nextChecker;
        return checker instanceof OCSPChecker && index + 1 < checkers.size() && (nextChecker = checkers.get(index + 1)) instanceof CrlRevocationChecker;
    }
}

