/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherWithWrappingSpi
extends CipherSpi {
    @Override
    protected final byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        try {
            byte[] encodedKey = key.getEncoded();
            if (encodedKey == null || encodedKey.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            result = this.engineDoFinal(encodedKey, 0, encodedKey.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected final Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        Key result = null;
        try {
            encodedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException eBlockSize) {
            throw new InvalidKeyException();
        }
        switch (wrappedKeyType) {
            case 3: {
                result = this.constructSecretKey(encodedKey, wrappedKeyAlgorithm);
                break;
            }
            case 2: {
                result = this.constructPrivateKey(encodedKey, wrappedKeyAlgorithm);
                break;
            }
            case 1: {
                result = this.constructPublicKey(encodedKey, wrappedKeyAlgorithm);
            }
        }
        return result;
    }

    private final PublicKey constructPublicKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm, "SunJCE");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            key = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                key = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return key;
    }

    private final PrivateKey constructPrivateKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm, "SunJCE");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                key = keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return key;
    }

    private final SecretKey constructSecretKey(byte[] encodedKey, String encodedKeyAlgorithm) {
        return new SecretKeySpec(encodedKey, encodedKeyAlgorithm);
    }
}

