/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.math.BigInteger;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.wrapper.Functions;

public class CK_ATTRIBUTE {
    public static final CK_ATTRIBUTE TOKEN_FALSE = new CK_ATTRIBUTE(1L, false);
    public static final CK_ATTRIBUTE SENSITIVE_FALSE = new CK_ATTRIBUTE(259L, false);
    public static final CK_ATTRIBUTE EXTRACTABLE_TRUE = new CK_ATTRIBUTE(354L, true);
    public static final CK_ATTRIBUTE ENCRYPT_TRUE = new CK_ATTRIBUTE(260L, true);
    public static final CK_ATTRIBUTE DECRYPT_TRUE = new CK_ATTRIBUTE(261L, true);
    public static final CK_ATTRIBUTE WRAP_TRUE = new CK_ATTRIBUTE(262L, true);
    public static final CK_ATTRIBUTE UNWRAP_TRUE = new CK_ATTRIBUTE(263L, true);
    public static final CK_ATTRIBUTE SIGN_TRUE = new CK_ATTRIBUTE(264L, true);
    public static final CK_ATTRIBUTE VERIFY_TRUE = new CK_ATTRIBUTE(266L, true);
    public static final CK_ATTRIBUTE SIGN_RECOVER_TRUE = new CK_ATTRIBUTE(265L, true);
    public static final CK_ATTRIBUTE VERIFY_RECOVER_TRUE = new CK_ATTRIBUTE(267L, true);
    public static final CK_ATTRIBUTE DERIVE_TRUE = new CK_ATTRIBUTE(268L, true);
    public static final CK_ATTRIBUTE ENCRYPT_NULL = new CK_ATTRIBUTE(260L);
    public static final CK_ATTRIBUTE DECRYPT_NULL = new CK_ATTRIBUTE(261L);
    public static final CK_ATTRIBUTE WRAP_NULL = new CK_ATTRIBUTE(262L);
    public static final CK_ATTRIBUTE UNWRAP_NULL = new CK_ATTRIBUTE(263L);
    public long type;
    public Object pValue;

    public CK_ATTRIBUTE() {
    }

    public CK_ATTRIBUTE(long type) {
        this.type = type;
    }

    public CK_ATTRIBUTE(long type, Object pValue) {
        this.type = type;
        this.pValue = pValue;
    }

    public CK_ATTRIBUTE(long type, boolean value) {
        this.type = type;
        this.pValue = value;
    }

    public CK_ATTRIBUTE(long type, long value) {
        this.type = type;
        this.pValue = value;
    }

    public CK_ATTRIBUTE(long type, BigInteger value) {
        this.type = type;
        this.pValue = P11Util.getMagnitude(value);
    }

    public BigInteger getBigInteger() {
        if (!(this.pValue instanceof byte[])) {
            throw new RuntimeException("Not a byte[]");
        }
        return new BigInteger(1, (byte[])this.pValue);
    }

    public boolean getBoolean() {
        if (!(this.pValue instanceof Boolean)) {
            throw new RuntimeException("Not a Boolean: " + this.pValue.getClass().getName());
        }
        return (Boolean)this.pValue;
    }

    public char[] getCharArray() {
        if (!(this.pValue instanceof char[])) {
            throw new RuntimeException("Not a char[]");
        }
        return (char[])this.pValue;
    }

    public byte[] getByteArray() {
        if (!(this.pValue instanceof byte[])) {
            throw new RuntimeException("Not a byte[]");
        }
        return (byte[])this.pValue;
    }

    public long getLong() {
        if (!(this.pValue instanceof Long)) {
            throw new RuntimeException("Not a Long: " + this.pValue.getClass().getName());
        }
        return (Long)this.pValue;
    }

    public String toString() {
        String prefix = Functions.getAttributeName(this.type) + " = ";
        if (this.type == 0L) {
            return prefix + Functions.getObjectClassName(this.getLong());
        }
        if (this.type == 256L) {
            return prefix + Functions.getKeyName(this.getLong());
        }
        String s = this.pValue instanceof char[] ? new String((char[])this.pValue) : (this.pValue instanceof byte[] ? Functions.toHexString((byte[])this.pValue) : String.valueOf(this.pValue));
        return prefix + s;
    }
}

