/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Obj;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.ldap.Control;
import javax.net.SocketFactory;

class ClientId {
    private final int version;
    private final String hostname;
    private final int port;
    private final String protocol;
    private final Control[] bindCtls;
    private final OutputStream trace;
    private final String socketFactory;
    private final int myHash;
    private final int ctlHash;
    private SocketFactory factory = null;
    private Method sockComparator = null;
    private boolean isDefaultSockFactory = false;
    public static final boolean debug = false;

    ClientId(int n, String string, int n2, String string2, Control[] controlArray, OutputStream outputStream, String string3) {
        this.version = n;
        this.hostname = string.toLowerCase(Locale.ENGLISH);
        this.port = n2;
        this.protocol = string2;
        this.bindCtls = controlArray != null ? (Control[])controlArray.clone() : null;
        this.trace = outputStream;
        this.socketFactory = string3;
        if (string3 != null && !string3.equals("javax.net.ssl.SSLSocketFactory")) {
            try {
                Class<?> clazz = Obj.helper.loadClass(string3);
                Class<?> clazz2 = Class.forName("java.lang.Object");
                this.sockComparator = clazz.getMethod("compare", clazz2, clazz2);
                Method method = clazz.getMethod("getDefault", new Class[0]);
                this.factory = (SocketFactory)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            this.isDefaultSockFactory = true;
        }
        this.ctlHash = ClientId.hashCodeControls(controlArray);
        this.myHash = n + n2 + (outputStream != null ? outputStream.hashCode() : 0) + (this.hostname != null ? this.hostname.hashCode() : 0) + (string2 != null ? string2.hashCode() : 0) + this.ctlHash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClientId)) {
            return false;
        }
        ClientId clientId = (ClientId)object;
        return this.myHash == clientId.myHash && this.version == clientId.version && this.port == clientId.port && this.trace == clientId.trace && (this.hostname == clientId.hostname || this.hostname != null && this.hostname.equals(clientId.hostname)) && (this.protocol == clientId.protocol || this.protocol != null && this.protocol.equals(clientId.protocol)) && this.ctlHash == clientId.ctlHash && ClientId.equalsControls(this.bindCtls, clientId.bindCtls) && this.equalsSockFactory(clientId);
    }

    public int hashCode() {
        return this.myHash;
    }

    private static int hashCodeControls(Control[] controlArray) {
        if (controlArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            n = n * 31 + controlArray[i].getID().hashCode();
        }
        return n;
    }

    private static boolean equalsControls(Control[] controlArray, Control[] controlArray2) {
        if (controlArray == controlArray2) {
            return true;
        }
        if (controlArray == null || controlArray2 == null) {
            return false;
        }
        if (controlArray.length != controlArray2.length) {
            return false;
        }
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i].getID().equals(controlArray2[i].getID()) && controlArray[i].isCritical() == controlArray2[i].isCritical() && Arrays.equals(controlArray[i].getEncodedValue(), controlArray2[i].getEncodedValue())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsSockFactory(ClientId clientId) {
        if (this.isDefaultSockFactory && clientId.isDefaultSockFactory) {
            return true;
        }
        if (!clientId.isDefaultSockFactory) {
            return this.invokeComparator(clientId, this);
        }
        return this.invokeComparator(this, clientId);
    }

    private boolean invokeComparator(ClientId clientId, ClientId clientId2) {
        Object object;
        try {
            object = clientId.sockComparator.invoke(clientId.factory, clientId.socketFactory, clientId2.socketFactory);
        }
        catch (Exception exception) {
            return false;
        }
        return (Integer)object == 0;
    }

    private static String toStringControls(Control[] controlArray) {
        if (controlArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < controlArray.length; ++i) {
            stringBuffer.append(controlArray[i].getID());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.hostname + ":" + this.port + ":" + (this.protocol != null ? this.protocol : "") + ":" + ClientId.toStringControls(this.bindCtls) + ":" + this.socketFactory;
    }
}

