/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.peer.TextAreaPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class TextArea
extends TextComponent {
    int rows;
    int columns;
    private static final String base = "text";
    private static int nameCounter = 0;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility;
    private static Set<AWTKeyStroke> forwardTraversalKeys;
    private static Set<AWTKeyStroke> backwardTraversalKeys;
    private static final long serialVersionUID = 3692302836626095722L;
    private int textAreaSerializedDataVersion = 2;

    private static native void initIDs();

    public TextArea() throws HeadlessException {
        this("", 0, 0, 0);
    }

    public TextArea(String string) throws HeadlessException {
        this(string, 0, 0, 0);
    }

    public TextArea(int n, int n2) throws HeadlessException {
        this("", n, n2, 0);
    }

    public TextArea(String string, int n, int n2) throws HeadlessException {
        this(string, n, n2, 0);
    }

    public TextArea(String string, int n, int n2, int n3) throws HeadlessException {
        super(string);
        this.rows = n >= 0 ? n : 0;
        this.columns = n2 >= 0 ? n2 : 0;
        this.scrollbarVisibility = n3 >= 0 && n3 <= 3 ? n3 : 0;
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<TextArea> clazz = TextArea.class;
        synchronized (TextArea.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextArea(this);
            }
            super.addNotify();
        }
    }

    public void insert(String string, int n) {
        this.insertText(string, n);
    }

    @Deprecated
    public synchronized void insertText(String string, int n) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.insert(string, n);
        } else {
            this.text = this.text.substring(0, n) + string + this.text.substring(n);
        }
    }

    public void append(String string) {
        this.appendText(string);
    }

    @Deprecated
    public synchronized void appendText(String string) {
        if (this.peer != null) {
            this.insertText(string, this.getText().length());
        } else {
            this.text = this.text + string;
        }
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceText(string, n, n2);
    }

    @Deprecated
    public synchronized void replaceText(String string, int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.replaceRange(string, n, n2);
        } else {
            this.text = this.text.substring(0, n) + string + this.text.substring(n2);
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        int n2 = this.rows;
        if (n < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (n != n2) {
            this.rows = n;
            this.invalidate();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
            return textAreaPeer != null ? textAreaPeer.getPreferredSize(n, n2) : super.preferredSize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 && this.columns > 0 ? this.preferredSize(this.rows, this.columns) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
            return textAreaPeer != null ? textAreaPeer.getMinimumSize(n, n2) : super.minimumSize();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 && this.columns > 0 ? this.minimumSize(this.rows, this.columns) : super.minimumSize();
        }
    }

    @Override
    protected String paramString() {
        String string;
        switch (this.scrollbarVisibility) {
            case 0: {
                string = "both";
                break;
            }
            case 1: {
                string = "vertical-only";
                break;
            }
            case 2: {
                string = "horizontal-only";
                break;
            }
            case 3: {
                string = "none";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        return super.paramString() + ",rows=" + this.rows + ",columns=" + this.columns + ",scrollbarVisibility=" + string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        objectInputStream.defaultReadObject();
        if (this.columns < 0) {
            this.columns = 0;
        }
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (this.scrollbarVisibility < 0 || this.scrollbarVisibility > 3) {
            this.scrollbarVisibility = 0;
        }
        if (this.textAreaSerializedDataVersion < 2) {
            this.setFocusTraversalKeys(0, forwardTraversalKeys);
            this.setFocusTraversalKeys(1, backwardTraversalKeys);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextArea();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            TextArea.initIDs();
        }
        forwardTraversalKeys = KeyboardFocusManager.initFocusTraversalKeysSet("ctrl TAB", new HashSet<AWTKeyStroke>());
        backwardTraversalKeys = KeyboardFocusManager.initFocusTraversalKeysSet("ctrl shift TAB", new HashSet<AWTKeyStroke>());
    }

    protected class AccessibleAWTTextArea
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 3472827823632144419L;

        protected AccessibleAWTTextArea() {
            super(TextArea.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }
}

