/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.management.VMManagement;
import sun.management.counter.Counter;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;
import sun.security.action.GetPropertyAction;

class VMManagementImpl
implements VMManagement {
    private static String version = VMManagementImpl.getVersion0();
    private static boolean compTimeMonitoringSupport;
    private static boolean threadContentionMonitoringSupport;
    private static boolean currentThreadCpuTimeSupport;
    private static boolean otherThreadCpuTimeSupport;
    private static boolean bootClassPathSupport;
    private static boolean objectMonitorUsageSupport;
    private static boolean synchronizerUsageSupport;
    private static boolean threadAllocatedMemorySupport;
    private static boolean gcNotificationSupport;
    private static boolean remoteDiagnosticCommandsSupport;
    private List<String> vmArgs = null;
    private PerfInstrumentation perfInstr = null;
    private boolean noPerfData = false;

    VMManagementImpl() {
    }

    private static native String getVersion0();

    private static native void initOptionalSupportFields();

    @Override
    public boolean isCompilationTimeMonitoringSupported() {
        return compTimeMonitoringSupport;
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return threadContentionMonitoringSupport;
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return currentThreadCpuTimeSupport;
    }

    @Override
    public boolean isOtherThreadCpuTimeSupported() {
        return otherThreadCpuTimeSupport;
    }

    @Override
    public boolean isBootClassPathSupported() {
        return bootClassPathSupport;
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return objectMonitorUsageSupport;
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        return synchronizerUsageSupport;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return threadAllocatedMemorySupport;
    }

    @Override
    public boolean isGcNotificationSupported() {
        return gcNotificationSupport;
    }

    @Override
    public boolean isRemoteDiagnosticCommandsSupported() {
        return remoteDiagnosticCommandsSupport;
    }

    @Override
    public native boolean isThreadContentionMonitoringEnabled();

    @Override
    public native boolean isThreadCpuTimeEnabled();

    @Override
    public native boolean isThreadAllocatedMemoryEnabled();

    @Override
    public int getLoadedClassCount() {
        long l = this.getTotalClassCount() - this.getUnloadedClassCount();
        return (int)l;
    }

    @Override
    public native long getTotalClassCount();

    @Override
    public native long getUnloadedClassCount();

    @Override
    public native boolean getVerboseClass();

    @Override
    public native boolean getVerboseGC();

    @Override
    public String getManagementVersion() {
        return version;
    }

    @Override
    public String getVmId() {
        int n = this.getProcessId();
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return n + "@" + string;
    }

    private native int getProcessId();

    @Override
    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getVmSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public String getVmSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public String getVmSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    @Override
    public String getBootClassPath() {
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.boot.class.path");
        String string = AccessController.doPrivileged(getPropertyAction);
        return string;
    }

    @Override
    public long getUptime() {
        return this.getUptime0();
    }

    @Override
    public synchronized List<String> getVmArguments() {
        if (this.vmArgs == null) {
            String[] stringArray = this.getVmArguments0();
            List list = stringArray != null && stringArray.length != 0 ? Arrays.asList(stringArray) : Collections.emptyList();
            this.vmArgs = Collections.unmodifiableList(list);
        }
        return this.vmArgs;
    }

    public native String[] getVmArguments0();

    @Override
    public native long getStartupTime();

    private native long getUptime0();

    @Override
    public native int getAvailableProcessors();

    @Override
    public String getCompilerName() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.management.compiler");
            }
        });
        return string;
    }

    @Override
    public native long getTotalCompileTime();

    @Override
    public native long getTotalThreadCount();

    @Override
    public native int getLiveThreadCount();

    @Override
    public native int getPeakThreadCount();

    @Override
    public native int getDaemonThreadCount();

    @Override
    public String getOsName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public String getOsVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public native long getSafepointCount();

    @Override
    public native long getTotalSafepointTime();

    @Override
    public native long getSafepointSyncTime();

    @Override
    public native long getTotalApplicationNonStoppedTime();

    @Override
    public native long getLoadedClassSize();

    @Override
    public native long getUnloadedClassSize();

    @Override
    public native long getClassLoadingTime();

    @Override
    public native long getMethodDataSize();

    @Override
    public native long getInitializedClassCount();

    @Override
    public native long getClassInitializationTime();

    @Override
    public native long getClassVerificationTime();

    private synchronized PerfInstrumentation getPerfInstrumentation() {
        if (this.noPerfData || this.perfInstr != null) {
            return this.perfInstr;
        }
        Perf perf = AccessController.doPrivileged(new Perf.GetPerfAction());
        try {
            ByteBuffer byteBuffer = perf.attach(0, "r");
            if (byteBuffer.capacity() == 0) {
                this.noPerfData = true;
                return null;
            }
            this.perfInstr = new PerfInstrumentation(byteBuffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.noPerfData = true;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return this.perfInstr;
    }

    @Override
    public List<Counter> getInternalCounters(String string) {
        PerfInstrumentation perfInstrumentation = this.getPerfInstrumentation();
        if (perfInstrumentation != null) {
            return perfInstrumentation.findByPattern(string);
        }
        return Collections.emptyList();
    }

    static {
        if (version == null) {
            throw new AssertionError((Object)"Invalid Management Version");
        }
        VMManagementImpl.initOptionalSupportFields();
    }
}

