/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jdk.internal.jimage.decompressor.ResourceDecompressor;
import jdk.internal.jimage.decompressor.ResourceDecompressorFactory;
import jdk.internal.jimage.decompressor.StringSharingDecompressorFactory;
import jdk.internal.jimage.decompressor.ZipDecompressorFactory;

public final class ResourceDecompressorRepository {
    private static final Map<String, ResourceDecompressorFactory> factories = new HashMap<String, ResourceDecompressorFactory>();

    private ResourceDecompressorRepository() {
    }

    public static ResourceDecompressor newResourceDecompressor(Properties properties, String name) throws IOException {
        ResourceDecompressorFactory fact = factories.get(name);
        if (fact != null) {
            return fact.newDecompressor(properties);
        }
        return null;
    }

    private static void registerReaderProvider(ResourceDecompressorFactory factory) {
        factories.put(factory.getName(), factory);
    }

    static {
        ResourceDecompressorRepository.registerReaderProvider(new ZipDecompressorFactory());
        ResourceDecompressorRepository.registerReaderProvider(new StringSharingDecompressorFactory());
    }
}

