/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvmstat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.jvmstat.monitor.Monitor;

class Utils {
    private static Method getVariabilityMethod = Utils.getMonitorMethod("getVariability");
    private static Method getUnitsMethod = Utils.getMonitorMethod("getUnits");

    Utils() {
    }

    static Object getVariability(Monitor monitor) {
        return Utils.invokeGetter(monitor, getVariabilityMethod);
    }

    static Object getUnits(Monitor monitor) {
        return Utils.invokeGetter(monitor, getUnitsMethod);
    }

    private static Object invokeGetter(Monitor monitor, Method method) {
        try {
            return method.invoke((Object)monitor, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method getMonitorMethod(String methodName) {
        try {
            return Monitor.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

