/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutStoredScriptAction
extends TransportMasterNodeAction<PutStoredScriptRequest, PutStoredScriptResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportPutStoredScriptAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
        super(settings, "cluster:admin/script/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutStoredScriptRequest::new);
        this.scriptService = scriptService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected PutStoredScriptResponse newResponse() {
        return new PutStoredScriptResponse();
    }

    @Override
    protected void masterOperation(PutStoredScriptRequest request, ClusterState state, ActionListener<PutStoredScriptResponse> listener) throws Exception {
        this.scriptService.putStoredScript(this.clusterService, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(PutStoredScriptRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

