/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.search.aggregations.support.ValuesSource;

abstract class CompositeValuesSource<VS extends ValuesSource, T extends Comparable<T>> {
    protected final VS vs;
    protected final int size;
    protected final int reverseMul;
    protected T topValue;

    CompositeValuesSource(VS vs, int size, int reverseMul) {
        this.vs = vs;
        this.size = size;
        this.reverseMul = reverseMul;
    }

    abstract String type();

    abstract void move(int var1, int var2);

    abstract int compare(int var1, int var2);

    abstract int compareTop(int var1);

    abstract void setTop(Comparable<?> var1);

    abstract Comparable<T> toComparable(int var1) throws IOException;

    abstract Collector getLeafCollector(LeafReaderContext var1, Collector var2) throws IOException;

    static CompositeValuesSource<ValuesSource.Numeric, Long> wrapLong(ValuesSource.Numeric vs, int size, int reverseMul) {
        return new LongValuesSource(vs, size, reverseMul);
    }

    static CompositeValuesSource<ValuesSource.Numeric, Double> wrapDouble(ValuesSource.Numeric vs, int size, int reverseMul) {
        return new DoubleValuesSource(vs, size, reverseMul);
    }

    static CompositeValuesSource<ValuesSource.Bytes, BytesRef> wrapBinary(ValuesSource.Bytes vs, int size, int reverseMul) {
        return new BinaryValuesSource(vs, size, reverseMul);
    }

    static CompositeValuesSource<ValuesSource.Bytes.WithOrdinals, BytesRef> wrapGlobalOrdinals(ValuesSource.Bytes.WithOrdinals vs, int size, int reverseMul) {
        return new GlobalOrdinalValuesSource(vs, size, reverseMul);
    }

    private static class DoubleValuesSource
    extends CompositeValuesSource<ValuesSource.Numeric, Double> {
        private final double[] values;
        private double topValue;

        DoubleValuesSource(ValuesSource.Numeric vs, int size, int reverseMul) {
            super(vs, size, reverseMul);
            this.values = new double[size];
        }

        @Override
        String type() {
            return "long";
        }

        @Override
        void move(int from, int to) {
            this.values[to] = this.values[from];
        }

        @Override
        int compare(int from, int to) {
            return Double.compare(this.values[from], this.values[to]) * this.reverseMul;
        }

        @Override
        int compareTop(int slot) {
            return Double.compare(this.values[slot], this.topValue) * this.reverseMul;
        }

        @Override
        void setTop(Comparable<?> value) {
            this.topValue = value instanceof Number ? ((Number)((Object)value)).doubleValue() : Double.parseDouble(value.toString());
        }

        @Override
        Comparable<Double> toComparable(int slot) {
            return this.values[slot];
        }

        @Override
        Collector getLeafCollector(LeafReaderContext context, Collector next) throws IOException {
            SortedNumericDoubleValues dvs = ((ValuesSource.Numeric)this.vs).doubleValues(context);
            return doc -> {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        this.values[0] = dvs.nextValue();
                        next.collect(doc);
                    }
                }
            };
        }
    }

    private static class LongValuesSource
    extends CompositeValuesSource<ValuesSource.Numeric, Long> {
        private final long[] values;
        private long topValue;

        LongValuesSource(ValuesSource.Numeric vs, int size, int reverseMul) {
            super(vs, size, reverseMul);
            this.values = new long[size];
        }

        @Override
        String type() {
            return "long";
        }

        @Override
        void move(int from, int to) {
            this.values[to] = this.values[from];
        }

        @Override
        int compare(int from, int to) {
            return Long.compare(this.values[from], this.values[to]) * this.reverseMul;
        }

        @Override
        int compareTop(int slot) {
            return Long.compare(this.values[slot], this.topValue) * this.reverseMul;
        }

        @Override
        void setTop(Comparable<?> value) {
            this.topValue = value instanceof Number ? ((Number)((Object)value)).longValue() : Long.parseLong(value.toString());
        }

        @Override
        Comparable<Long> toComparable(int slot) {
            return this.values[slot];
        }

        @Override
        Collector getLeafCollector(LeafReaderContext context, Collector next) throws IOException {
            SortedNumericDocValues dvs = ((ValuesSource.Numeric)this.vs).longValues(context);
            return doc -> {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        this.values[0] = dvs.nextValue();
                        next.collect(doc);
                    }
                }
            };
        }
    }

    private static class BinaryValuesSource
    extends CompositeValuesSource<ValuesSource.Bytes, BytesRef> {
        private final BytesRef[] values;
        private BytesRef topValue;

        BinaryValuesSource(ValuesSource.Bytes vs, int size, int reverseMul) {
            super(vs, size, reverseMul);
            this.values = new BytesRef[size];
        }

        @Override
        String type() {
            return "binary";
        }

        @Override
        public void move(int from, int to) {
            this.values[to] = BytesRef.deepCopyOf((BytesRef)this.values[from]);
        }

        @Override
        public int compare(int from, int to) {
            return this.values[from].compareTo(this.values[to]) * this.reverseMul;
        }

        @Override
        int compareTop(int slot) {
            return this.values[slot].compareTo(this.topValue) * this.reverseMul;
        }

        @Override
        void setTop(Comparable<?> value) {
            if (value.getClass() == BytesRef.class) {
                this.topValue = (BytesRef)value;
            } else if (value.getClass() == String.class) {
                this.topValue = new BytesRef((CharSequence)((String)((Object)value)));
            } else {
                throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
            }
        }

        @Override
        Comparable<BytesRef> toComparable(int slot) {
            return this.values[slot];
        }

        @Override
        Collector getLeafCollector(LeafReaderContext context, Collector next) throws IOException {
            SortedBinaryDocValues dvs = ((ValuesSource.Bytes)this.vs).bytesValues(context);
            return doc -> {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        this.values[0] = dvs.nextValue();
                        next.collect(doc);
                    }
                }
            };
        }
    }

    private static class GlobalOrdinalValuesSource
    extends CompositeValuesSource<ValuesSource.Bytes.WithOrdinals, BytesRef> {
        private final long[] values;
        private SortedSetDocValues lookup;
        private Long topValueLong;

        GlobalOrdinalValuesSource(ValuesSource.Bytes.WithOrdinals vs, int size, int reverseMul) {
            super(vs, size, reverseMul);
            this.values = new long[size];
        }

        @Override
        String type() {
            return "global_ordinals";
        }

        @Override
        void move(int from, int to) {
            this.values[to] = this.values[from];
        }

        @Override
        int compare(int from, int to) {
            return Long.compare(this.values[from], this.values[to]) * this.reverseMul;
        }

        @Override
        int compareTop(int slot) {
            return Long.compare(this.values[slot], this.topValueLong) * this.reverseMul;
        }

        @Override
        void setTop(Comparable<?> value) {
            if (value instanceof BytesRef) {
                this.topValue = (BytesRef)value;
            } else if (value instanceof String) {
                this.topValue = new BytesRef((CharSequence)value.toString());
            } else {
                throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
            }
        }

        @Override
        Comparable<BytesRef> toComparable(int slot) throws IOException {
            return BytesRef.deepCopyOf((BytesRef)this.lookup.lookupOrd(this.values[slot]));
        }

        @Override
        Collector getLeafCollector(LeafReaderContext context, Collector next) throws IOException {
            SortedSetDocValues dvs = ((ValuesSource.Bytes.WithOrdinals)this.vs).globalOrdinalsValues(context);
            if (this.lookup == null) {
                this.lookup = dvs;
                if (this.topValue != null && this.topValueLong == null) {
                    if (this.lookup instanceof GlobalOrdinalMapping) {
                        this.topValueLong = GlobalOrdinalValuesSource.lookupGlobalOrdinals((GlobalOrdinalMapping)this.lookup, (BytesRef)this.topValue);
                    } else {
                        this.topValueLong = this.lookup.lookupTerm((BytesRef)this.topValue);
                        if (this.topValueLong < 0L) {
                            this.topValueLong = -this.topValueLong.longValue() - 2L;
                        }
                    }
                }
            }
            return doc -> {
                if (dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        this.values[0] = ord;
                        next.collect(doc);
                    }
                }
            };
        }

        private static long lookupGlobalOrdinals(GlobalOrdinalMapping mapping, BytesRef key) throws IOException {
            long low = 0L;
            long high = mapping.getValueCount();
            while (low <= high) {
                long mid = low + high >>> 1;
                BytesRef midVal = mapping.lookupOrd(mid);
                int cmp = midVal.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1L;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1L;
                    continue;
                }
                return mid;
            }
            return low - 1L;
        }
    }

    static interface Collector {
        public void collect(int var1) throws IOException;
    }
}

