/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Map;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.java.BS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class BinaryDcdReader
extends AtomSetCollectionReader {
    private int nModels;
    private int nAtoms;
    private int nFree;
    private BS bsFree;
    private float[] xAll;
    private float[] yAll;
    private float[] zAll;
    private int crystGroup;

    protected void setup(String fullPath, Map<String, Object> htParams, Object reader) {
        this.isBinary = true;
        this.setupASCR(fullPath, htParams, reader);
    }

    protected void initializeReader() {
        this.initializeTrajectoryFile();
        this.asc.setInfo("ignoreUnitCell", (Object)Boolean.TRUE);
    }

    protected void processBinaryDocument() throws Exception {
        int i;
        byte[] bytes = new byte[40];
        this.binaryDoc.setStream(null, this.binaryDoc.readInt() == 84);
        this.binaryDoc.readInt();
        this.nModels = this.binaryDoc.readInt();
        int nPriv = this.binaryDoc.readInt();
        int nSaveC = this.binaryDoc.readInt();
        int nStep = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        int ndegf = this.binaryDoc.readInt();
        this.nFree = ndegf / 3;
        int nFixed = this.binaryDoc.readInt();
        int delta4 = this.binaryDoc.readInt();
        this.crystGroup = this.binaryDoc.readInt();
        this.binaryDoc.readByteArray(bytes, 0, 32);
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        SB sb = new SB();
        int n = this.binaryDoc.readInt();
        for (i = 0; i < n; ++i) {
            sb.append(this.trimString(this.binaryDoc.readString(80))).appendC('\n');
        }
        this.binaryDoc.readInt();
        Logger.info((String)("BinaryDcdReadaer:\n" + sb));
        this.binaryDoc.readInt();
        this.nAtoms = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.nFree = this.nAtoms - nFixed;
        if (nFixed != 0) {
            this.binaryDoc.readInt();
            this.bsFree = BS.newN((int)this.nFree);
            for (i = 0; i < this.nFree; ++i) {
                this.bsFree.set(this.binaryDoc.readInt() - 1);
            }
            this.binaryDoc.readInt();
            Logger.info((String)("free: " + this.bsFree.cardinality() + " " + Escape.eBS((BS)this.bsFree)));
        }
        this.readCoordinates();
        Logger.info((String)("Total number of trajectory steps=" + this.trajectorySteps.size()));
    }

    private String trimString(String s) {
        int pt = s.indexOf(0);
        if (pt >= 0) {
            s = s.substring(0, pt);
        }
        return s.trim();
    }

    private float[] readFloatArray() throws Exception {
        int n = this.binaryDoc.readInt() / 4;
        float[] data = new float[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.binaryDoc.readFloat();
        }
        this.binaryDoc.readInt();
        return data;
    }

    private double[] readDoubleArray() throws Exception {
        int n = this.binaryDoc.readInt() / 8;
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.binaryDoc.readDouble();
        }
        this.binaryDoc.readInt();
        return data;
    }

    private void readCoordinates() throws Exception {
        int ac = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        for (int i = 0; i < this.nModels; ++i) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3[] trajectoryStep = new P3[ac];
                if (!this.getTrajectoryStep(trajectoryStep)) {
                    return;
                }
                this.trajectorySteps.addLast((Object)trajectoryStep);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (this.crystGroup > 0) {
                this.readDoubleArray();
            }
            this.readFloatArray();
            this.readFloatArray();
            this.readFloatArray();
        }
    }

    private boolean getTrajectoryStep(P3[] trajectoryStep) throws Exception {
        try {
            BS bs;
            int ac = trajectoryStep.length;
            int n = -1;
            if (this.crystGroup > 0) {
                this.calcUnitCell(this.readDoubleArray());
            }
            float[] x = this.readFloatArray();
            float[] y = this.readFloatArray();
            float[] z = this.readFloatArray();
            BS bS = bs = this.xAll == null ? null : this.bsFree;
            if (bs == null) {
                this.xAll = x;
                this.yAll = y;
                this.zAll = z;
            }
            int vpt = 0;
            for (int i = 0; i < this.nAtoms; ++i) {
                P3 pt = new P3();
                if (bs == null || bs.get(i)) {
                    pt.set(x[vpt], y[vpt], z[vpt]);
                    ++vpt;
                } else {
                    pt.set(this.xAll[i], this.yAll[i], this.zAll[i]);
                }
                if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
                if (++n == ac) {
                    return true;
                }
                trajectoryStep[n] = pt;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private float[] calcUnitCell(double[] abc) {
        double a = abc[0];
        double angle1 = abc[1];
        double b = abc[2];
        double angle2 = abc[3];
        double angle3 = abc[4];
        double c = abc[5];
        double alpha = (1.5707963267948966 - Math.asin(angle3)) * 180.0 / Math.PI;
        double beta = (1.5707963267948966 - Math.asin(angle2)) * 180.0 / Math.PI;
        double gamma = (1.5707963267948966 - Math.asin(angle1)) * 180.0 / Math.PI;
        System.out.println("unitcell:[" + a + " " + b + " " + c + " " + alpha + " " + beta + " " + gamma + "]");
        return new float[]{(float)a, (float)b, (float)c, (float)alpha, (float)beta, (float)gamma};
    }
}

