/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.common.Coordinate;
import jspecview.common.ImageView;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class Spectrum
extends JDXDataObject {
    private Lst<Spectrum> subSpectra;
    private Lst<PeakInfo> peakList = new Lst();
    private String piUnitsX;
    private String piUnitsY;
    private PeakInfo selectedPeak;
    private PeakInfo highlightedPeak;
    private double specShift = 0.0;
    private int currentSubSpectrumIndex;
    private boolean isForcedSubset;
    public String id = "";
    private Spectrum convertedSpectrum;
    private double userYFactor = 1.0;
    public static final double MAXABS = 4.0;
    private boolean exportXAxisLeftToRight;
    GenericColor fillColor;
    ImageView imageView;

    public void finalize() {
        System.out.println("JDXSpectrum " + this + " finalized " + this.title);
    }

    public void dispose() {
    }

    public boolean isForcedSubset() {
        return this.isForcedSubset;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Spectrum() {
        this.headerTable = new Lst();
        this.xyCoords = new Coordinate[0];
        this.parent = this;
    }

    public Spectrum copy() {
        Spectrum spectrum = new Spectrum();
        this.copyTo(spectrum);
        spectrum.setPeakList(this.peakList, this.piUnitsX, null);
        spectrum.fillColor = this.fillColor;
        return spectrum;
    }

    public Coordinate[] getXYCoords() {
        return this.getCurrentSubSpectrum().xyCoords;
    }

    public Lst<PeakInfo> getPeakList() {
        return this.peakList;
    }

    public int setPeakList(Lst<PeakInfo> lst, String string, String string2) {
        this.peakList = lst;
        this.piUnitsX = string;
        this.piUnitsY = string2;
        int n = lst.size();
        while (--n >= 0) {
            ((PeakInfo)this.peakList.get((int)n)).spectrum = this;
        }
        if (Logger.debugging) {
            Logger.info("Spectrum " + this.getTitle() + " peaks: " + lst.size());
        }
        return lst.size();
    }

    public PeakInfo selectPeakByFileIndex(String string, String string2, String string3) {
        if (this.peakList != null && this.peakList.size() > 0 && (string3 == null || this.sourceID.equals(string2))) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkFileIndex(string, string2, string3)) continue;
                System.out.println("selecting peak by FileIndex " + this + " " + this.peakList.get(i));
                this.selectedPeak = (PeakInfo)this.peakList.get(i);
                return this.selectedPeak;
            }
        }
        return null;
    }

    public PeakInfo selectPeakByFilePathTypeModel(String string, String string2, String string3) {
        if (this.peakList != null && this.peakList.size() > 0) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkFileTypeModel(string, string2, string3)) continue;
                System.out.println("selecting peak byFilePathTypeModel " + this + " " + this.peakList.get(i));
                this.selectedPeak = (PeakInfo)this.peakList.get(i);
                return this.selectedPeak;
            }
        }
        return null;
    }

    public boolean matchesPeakTypeModel(String string, String string2) {
        if (string.equals("ID")) {
            return this.sourceID.equalsIgnoreCase(string2);
        }
        if (this.peakList != null && this.peakList.size() > 0) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkTypeModel(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectedPeak(PeakInfo peakInfo) {
        this.selectedPeak = peakInfo;
    }

    public void setHighlightedPeak(PeakInfo peakInfo) {
        this.highlightedPeak = peakInfo;
    }

    public PeakInfo getSelectedPeak() {
        return this.selectedPeak;
    }

    public PeakInfo getModelPeakInfoForAutoSelectOnLoad() {
        if (this.peakList != null) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).autoSelectOnLoad()) continue;
                return (PeakInfo)this.peakList.get(i);
            }
        }
        return null;
    }

    public PeakInfo getAssociatedPeakInfo(int n, Coordinate coordinate) {
        this.selectedPeak = this.findPeakByCoord(n, coordinate);
        return this.selectedPeak == null ? this.getBasePeakInfo() : this.selectedPeak;
    }

    public PeakInfo findPeakByCoord(int n, Coordinate coordinate) {
        if (coordinate != null && this.peakList != null && this.peakList.size() > 0) {
            double d = coordinate.getXVal();
            int n2 = -1;
            double d2 = 1.0E100;
            for (int i = 0; i < this.peakList.size(); ++i) {
                double d3 = ((PeakInfo)this.peakList.get(i)).checkRange(n, d);
                if (!(d3 < d2)) continue;
                d2 = d3;
                n2 = i;
            }
            if (n2 >= 0) {
                return (PeakInfo)this.peakList.get(n2);
            }
        }
        return null;
    }

    public String getPeakTitle() {
        return this.selectedPeak != null ? this.selectedPeak.getTitle() : (this.highlightedPeak != null ? this.highlightedPeak.getTitle() : this.getTitleLabel());
    }

    public String getTitleLabel() {
        String string;
        String string2 = string = this.peakList == null || this.peakList.size() == 0 ? this.getQualifiedDataType() : ((PeakInfo)this.peakList.get(0)).getType();
        if (string != null && string.startsWith("NMR")) {
            string = this.nucleusY != null && !this.nucleusY.equals("?") ? "2D" + string : this.nucleusX + string;
        }
        return (string != null && string.length() > 0 ? string + " " : "") + this.getTitle();
    }

    public int setNextPeak(Coordinate coordinate, int n) {
        if (this.peakList == null || this.peakList.size() == 0) {
            return -1;
        }
        double d = coordinate.getXVal() + (double)n * 1.0E-6;
        int n2 = -1;
        int n3 = -1;
        double d2 = Double.MAX_VALUE * (double)n;
        double d3 = 0.0;
        int n4 = this.peakList.size();
        while (--n4 >= 0) {
            double d4 = ((PeakInfo)this.peakList.get(n4)).getX();
            if (n > 0) {
                if (d4 > d && d4 < d2) {
                    n2 = n4;
                    d2 = d4;
                    continue;
                }
                if (!(d4 < d) || !(d4 - d < d3)) continue;
                n3 = n4;
                d3 = d4 - d;
                continue;
            }
            if (d4 < d && d4 > d2) {
                n2 = n4;
                d2 = d4;
                continue;
            }
            if (!(d4 > d) || !(d4 - d > d3)) continue;
            n3 = n4;
            d3 = d4 - d;
        }
        if (n2 < 0) {
            if (n3 < 0) {
                return -1;
            }
            n2 = n3;
        }
        return n2;
    }

    public double getPercentYValueAt(double d) {
        if (!this.isContinuous()) {
            return Double.NaN;
        }
        return this.getYValueAt(d);
    }

    public double getYValueAt(double d) {
        return Coordinate.getYValueAt(this.xyCoords, d);
    }

    public void setUserYFactor(double d) {
        this.userYFactor = d;
    }

    public double getUserYFactor() {
        return this.userYFactor;
    }

    public Spectrum getConvertedSpectrum() {
        return this.convertedSpectrum;
    }

    public void setConvertedSpectrum(Spectrum spectrum) {
        this.convertedSpectrum = spectrum;
    }

    public static Spectrum taConvert(Spectrum spectrum, IRMode iRMode) {
        if (!spectrum.isContinuous()) {
            return spectrum;
        }
        switch (iRMode) {
            case NO_CONVERT: {
                return spectrum;
            }
            case TO_ABS: {
                if (spectrum.isTransmittance()) break;
                return spectrum;
            }
            case TO_TRANS: {
                if (spectrum.isAbsorbance()) break;
                return spectrum;
            }
        }
        Spectrum spectrum2 = spectrum.getConvertedSpectrum();
        return spectrum2 != null ? spectrum2 : (spectrum.isAbsorbance() ? Spectrum.toT(spectrum) : Spectrum.toA(spectrum));
    }

    private static Spectrum toT(Spectrum spectrum) {
        if (!spectrum.isAbsorbance()) {
            return null;
        }
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        if (!Coordinate.isYInRange(coordinateArray, 0.0, 4.0)) {
            coordinateArray = Coordinate.normalise(coordinateArray, 0.0, 4.0);
        }
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinateArray2[i] = new Coordinate().set(coordinateArray[i].getXVal(), Spectrum.toTransmittance(coordinateArray[i].getYVal()));
        }
        return Spectrum.newSpectrum(spectrum, coordinateArray2, "TRANSMITTANCE");
    }

    private static Spectrum toA(Spectrum spectrum) {
        if (!spectrum.isTransmittance()) {
            return null;
        }
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        boolean bl = Coordinate.isYInRange(coordinateArray, -2.0, 2.0);
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinateArray2[i] = new Coordinate().set(coordinateArray[i].getXVal(), Spectrum.toAbsorbance(coordinateArray[i].getYVal(), bl));
        }
        return Spectrum.newSpectrum(spectrum, coordinateArray2, "ABSORBANCE");
    }

    public static Spectrum newSpectrum(Spectrum spectrum, Coordinate[] coordinateArray, String string) {
        Spectrum spectrum2 = spectrum.copy();
        spectrum2.setOrigin("JSpecView Converted");
        spectrum2.setOwner("JSpecView Generated");
        spectrum2.setXYCoords(coordinateArray);
        spectrum2.setYUnits(string);
        spectrum.setConvertedSpectrum(spectrum2);
        spectrum2.setConvertedSpectrum(spectrum);
        return spectrum2;
    }

    private static double toAbsorbance(double d, boolean bl) {
        return Math.min(4.0, bl ? 2.0 - Spectrum.log10(d) : -Spectrum.log10(d));
    }

    private static double toTransmittance(double d) {
        return d <= 0.0 ? 1.0 : Math.pow(10.0, -d);
    }

    private static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static boolean process(Lst<Spectrum> lst, IRMode iRMode) {
        if (iRMode == IRMode.TO_ABS || iRMode == IRMode.TO_TRANS) {
            for (int i = 0; i < lst.size(); ++i) {
                lst.set(i, Spectrum.taConvert((Spectrum)lst.get(i), iRMode));
            }
        }
        return true;
    }

    public Lst<Spectrum> getSubSpectra() {
        return this.subSpectra;
    }

    public Spectrum getCurrentSubSpectrum() {
        return this.subSpectra == null ? this : (Spectrum)this.subSpectra.get(this.currentSubSpectrumIndex);
    }

    public int advanceSubSpectrum(int n) {
        return this.setCurrentSubSpectrum(this.currentSubSpectrumIndex + n);
    }

    public int setCurrentSubSpectrum(int n) {
        this.currentSubSpectrumIndex = Coordinate.intoRange(n, 0, this.subSpectra.size() - 1);
        return this.currentSubSpectrumIndex;
    }

    public boolean addSubSpectrum(Spectrum spectrum, boolean bl) {
        if (!bl && (this.numDim < 2 || this.blockID != spectrum.blockID) || !Spectrum.allowSubSpec(this, spectrum)) {
            return false;
        }
        this.isForcedSubset = bl;
        if (this.subSpectra == null) {
            this.subSpectra = new Lst();
            this.addSubSpectrum(this, true);
        }
        this.subSpectra.addLast(spectrum);
        spectrum.parent = this;
        return true;
    }

    public int getSubIndex() {
        return this.subSpectra == null ? -1 : this.currentSubSpectrumIndex;
    }

    public void setExportXAxisDirection(boolean bl) {
        this.exportXAxisLeftToRight = bl;
    }

    public boolean isExportXAxisLeftToRight() {
        return this.exportXAxisLeftToRight;
    }

    public Map<String, Object> getInfo(String string) {
        String[][] stringArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if ("id".equalsIgnoreCase(string)) {
            hashtable.put(string, this.id);
            return hashtable;
        }
        String string2 = null;
        if ("".equals(string)) {
            string2 = "id specShift header";
        }
        hashtable.put("id", this.id);
        Parameters.putInfo(string, hashtable, "specShift", this.specShift);
        boolean bl = "header".equals(string);
        if (!bl && string != null && string2 == null) {
            int n = this.headerTable.size();
            while (--n >= 0) {
                stringArray = (String[])this.headerTable.get(n);
                if (!stringArray[0].equalsIgnoreCase(string) && !stringArray[2].equalsIgnoreCase(string)) continue;
                hashtable.put(string, stringArray[1]);
                return hashtable;
            }
        }
        Hashtable hashtable2 = new Hashtable();
        stringArray = this.getHeaderRowDataAsArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = JDXSourceStreamTokenizer.cleanLabel(stringArray[i][0]);
            if (string2 != null) {
                string2 = string2 + " " + string3;
                continue;
            }
            if (string != null && !bl && !string3.equals(string)) continue;
            Object object = Spectrum.fixInfoValue(stringArray[i][1]);
            if (string == null) {
                Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                hashtable3.put("value", object);
                hashtable3.put("index", i + 1);
                hashtable.put(string3, hashtable3);
                continue;
            }
            hashtable.put(string3, object);
        }
        if (hashtable2.size() > 0) {
            hashtable.put("header", hashtable2);
        }
        if (!bl) {
            if (string2 != null) {
                string2 = string2 + "  titleLabel type isHZToPPM subSpectrumCount";
            } else {
                Parameters.putInfo(string, hashtable, "titleLabel", this.getTitleLabel());
                Parameters.putInfo(string, hashtable, "type", this.getDataType());
                Parameters.putInfo(string, hashtable, "isHZToPPM", this.isHZtoPPM);
                Parameters.putInfo(string, hashtable, "subSpectrumCount", this.subSpectra == null ? 0 : this.subSpectra.size());
            }
        }
        if (string2 != null) {
            hashtable.put("KEYS", string2);
        }
        return hashtable;
    }

    private static Object fixInfoValue(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(string);
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public String toString() {
        return this.getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo peakInfo) {
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (!((PeakInfo)this.peakList.get(i)).checkTypeMatch(peakInfo)) continue;
            return (PeakInfo)this.peakList.get(i);
        }
        return null;
    }

    public PeakInfo getBasePeakInfo() {
        return this.peakList.size() == 0 ? new PeakInfo() : new PeakInfo(" baseModel=\"\" " + this.peakList.get(0));
    }

    public String getAxisLabel(boolean bl) {
        String string;
        String string2 = string = bl ? this.piUnitsX : this.piUnitsY;
        if (string == null) {
            String string3 = string = bl ? this.xLabel : this.yLabel;
        }
        if (string == null) {
            String string4 = string = bl ? this.xUnits : this.yUnits;
        }
        return string == null ? "" : (string.equalsIgnoreCase("WAVENUMBERS") ? "1/cm" : (string.equalsIgnoreCase("nanometers") ? "nm" : string));
    }

    public double findXForPeakNearest(double d) {
        return Coordinate.findXForPeakNearest(this.xyCoords, d, this.isInverted());
    }

    public double addSpecShift(double d) {
        if (d != 0.0) {
            this.specShift += d;
            Coordinate.shiftX(this.xyCoords, d);
            if (this.subSpectra != null) {
                int n = this.subSpectra.size();
                while (--n >= 0) {
                    Spectrum spectrum = (Spectrum)this.subSpectra.get(n);
                    if (spectrum == this || spectrum == this.parent) continue;
                    spectrum.addSpecShift(d);
                }
            }
        }
        return this.specShift;
    }

    public static boolean allowSubSpec(Spectrum spectrum, Spectrum spectrum2) {
        return spectrum.is1D() == spectrum2.is1D() && spectrum.xUnits.equalsIgnoreCase(spectrum2.xUnits) && spectrum.isHNMR() == spectrum2.isHNMR();
    }

    public static boolean areXScalesCompatible(Spectrum spectrum, Spectrum spectrum2, boolean bl, boolean bl2) {
        boolean bl3 = spectrum.isNMR();
        if (bl3 != spectrum2.isNMR() || spectrum.isContinuous() != spectrum2.isContinuous() || !bl2 && !Spectrum.areUnitsCompatible(spectrum.xUnits, spectrum2.xUnits)) {
            return false;
        }
        if (bl) {
            if (spectrum.is1D() != spectrum2.is1D()) {
                return false;
            }
        } else if (bl2) {
            if (!bl3) {
                return true;
            }
        } else if (!spectrum.is1D() || !spectrum2.is1D()) {
            return false;
        }
        return !bl3 || spectrum2.is1D() && spectrum.parent.nucleusX.equals(spectrum2.parent.nucleusX);
    }

    private static boolean areUnitsCompatible(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        return string.equals("HZ") && string2.equals("PPM") || string.equals("PPM") && string2.equals("HZ");
    }

    public static boolean areLinkableX(Spectrum spectrum, Spectrum spectrum2) {
        return spectrum.isNMR() && spectrum2.isNMR() && spectrum.nucleusX.equals(spectrum2.nucleusX);
    }

    public static boolean areLinkableY(Spectrum spectrum, Spectrum spectrum2) {
        return spectrum.isNMR() && spectrum2.isNMR() && spectrum.nucleusX.equals(spectrum2.nucleusY);
    }

    public void setNHydrogens(int n) {
        this.nH = n;
    }

    public float getPeakWidth() {
        double d = this.getLastX() - this.getFirstX();
        return (float)(d / 100.0);
    }

    public void setSimulated(String string) {
        this.isSimulation = true;
        String string2 = this.sourceID;
        if (string2.length() == 0) {
            string2 = PT.rep(string, "http://SIMULATION/", "");
        }
        if (string2.indexOf("MOL=") >= 0) {
            string2 = "";
        }
        this.title = "SIMULATED " + PT.rep(string2, "$", "");
    }

    public void setFillColor(GenericColor genericColor) {
        this.fillColor = genericColor;
        if (this.convertedSpectrum != null) {
            this.convertedSpectrum.fillColor = genericColor;
        }
    }

    public static enum IRMode {
        NO_CONVERT,
        TO_TRANS,
        TO_ABS,
        TOGGLE;


        public static IRMode getMode(String string) {
            switch (string == null ? 73 : (int)string.toUpperCase().charAt(0)) {
                case 65: {
                    return TO_ABS;
                }
                case 84: {
                    return string.equalsIgnoreCase("TOGGLE") ? TOGGLE : TO_TRANS;
                }
                case 78: {
                    return NO_CONVERT;
                }
            }
            return TOGGLE;
        }
    }
}

