/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javajs.util.JSJSONParser;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBORequest;
import org.gennbo.NBOUtil;
import org.jmol.viewer.Viewer;

class NBORun {
    protected NBODialog dialog;
    private Viewer vwr;
    protected static boolean ALLOW_SELECT_ALL = false;
    protected static final String[] RUN_KEYWORD_DESC = new String[]{"Bonding character of canonical MO's", "Dipole moment analysis", "Natural bond-bond polarizability indices", "Natural bond critical point analysis", "Natural coulomb electrostatics analysis", "Natural cluster unit analysis", "Natural resonance theory analysis", "Write files for orbital plotting", "Natural steric analysis"};
    protected static final String[] RUN_KEYWORD_NAMES = new String[]{"CMO", "DIPOLE", "NBBP", "NBCP", "NCE", "NCU", "NRT", "PLOT", "STERIC"};
    protected Box editBox;
    protected JRadioButton rbLocal;
    protected JRadioButton[] keywordButtons;
    protected JButton btnRun;
    protected JTextField tfJobName;
    private JPanel myPanel;
    JTextPane keywordTextPane;

    protected NBORun(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
    }

    protected JPanel buildRunPanel() {
        JPanel panel = this.myPanel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.dialog.getNewInputFileHandler(2);
        this.dialog.inputFileHandler.setBrowseEnabled(false);
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        panel.add(NBOUtil.createTitleBox(" Select Job ", nBODialog.new NBODialog.HelpBtn("run_job_help.htm")));
        Box inputBox = NBOUtil.createBorderBox(true);
        inputBox.add(this.createSourceBox());
        inputBox.add(this.dialog.inputFileHandler);
        inputBox.setMinimumSize(new Dimension(360, 80));
        inputBox.setPreferredSize(new Dimension(360, 80));
        inputBox.setMaximumSize(new Dimension(360, 80));
        panel.add(inputBox);
        NBODialog nBODialog2 = this.dialog;
        nBODialog2.getClass();
        panel.add(NBOUtil.createTitleBox(" Choose $NBO Keywords ", nBODialog2.new NBODialog.HelpBtn("run_keywords_help.htm"))).setVisible(false);
        this.editBox = NBOUtil.createBorderBox(true);
        this.editBox.setSize(new Dimension(350, 400));
        this.tfJobName = new JTextField();
        this.tfJobName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBORun.this.doLogJobName(null);
            }
        });
        this.tfJobName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                NBORun.this.doLogJobName(null);
            }
        });
        this.editBox.setVisible(false);
        panel.add(this.editBox);
        this.btnRun = new JButton("Run");
        this.btnRun.setFont(NBOConfig.runButtonFont);
        this.btnRun.setVisible(false);
        this.btnRun.setEnabled(true);
        this.btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBORun.this.doRunGenNBOJob("");
            }
        });
        panel.add(this.btnRun);
        if (this.dialog.inputFileHandler.tfExt.getText().equals("47")) {
            this.notifyFileLoaded();
        }
        this.dialog.inputFileHandler.setBrowseEnabled(true);
        return panel;
    }

    private Box createSourceBox() {
        Box box = Box.createHorizontalBox();
        ButtonGroup bg = new ButtonGroup();
        this.rbLocal = new JRadioButton("Local");
        this.rbLocal.setSelected(true);
        this.rbLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBORun.this.doLocalBtn();
            }
        });
        box.add(this.rbLocal);
        bg.add(this.rbLocal);
        JRadioButton btn = new JRadioButton("NBOrXiv");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBORun.this.doArchiveButton();
            }
        });
        box.add(btn);
        bg.add(btn);
        btn = new JRadioButton("WebMO");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://www.webmo.net/demoserver/cgi-bin/webmo/jobmgr.cgi";
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e1) {
                    NBORun.this.dialog.alertError("Could not open WebMO");
                }
            }
        });
        box.add(btn);
        bg.add(btn);
        return box;
    }

    protected void doArchiveButton() {
        ArchiveViewer aView = new ArchiveViewer(this.dialog, "http://nbo6.chem.wisc.edu/jmol_nborxiv/");
        aView.setVisible(true);
    }

    protected void doLocalBtn() {
        this.dialog.inputFileHandler.setBrowseEnabled(true);
        if (this.dialog.modelOrigin != 4) {
            this.dialog.inputFileHandler.doFileBrowsePressed();
        }
    }

    protected void addNBOKeylist() {
        if (this.dialog.inputFileHandler.inputFile == null) {
            return;
        }
        Box jobNameOuterBox = Box.createVerticalBox();
        jobNameOuterBox.setSize(new Dimension(250, 75));
        Box selectBox = Box.createHorizontalBox();
        selectBox.setSize(new Dimension(250, 50));
        Box mainBox = Box.createVerticalBox();
        mainBox.setSize(new Dimension(250, 275));
        final JPanel mainMenuOptions = this.addMenuOption();
        mainBox.add(mainMenuOptions);
        final JPanel mainTextEditor = this.addTextOption();
        mainBox.add(mainTextEditor);
        this.editBox.removeAll();
        this.editBox.add(Box.createRigidArea(new Dimension(350, 0)));
        this.editBox.add(jobNameOuterBox);
        this.editBox.add(selectBox);
        this.editBox.add(mainBox);
        Box jobNameInnerBox = Box.createHorizontalBox();
        jobNameInnerBox.add(new JLabel("Jobname ")).setFont(NBOConfig.nboFont);
        jobNameInnerBox.add(this.tfJobName).setMaximumSize(new Dimension(150, 30));
        jobNameInnerBox.setAlignmentX(0.5f);
        jobNameOuterBox.add(jobNameInnerBox);
        JLabel lab = new JLabel("(Plot files will be created with this name)");
        lab.setAlignmentX(0.5f);
        jobNameOuterBox.add(lab);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton btnMenuSelect = new JRadioButton("Menu Select");
        bg.add(btnMenuSelect);
        btnMenuSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainTextEditor.setVisible(false);
                mainMenuOptions.setVisible(true);
            }
        });
        JRadioButton btnTextEditor = new JRadioButton("Text Editor");
        btnTextEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainMenuOptions.setVisible(false);
                NBORun.this.doSetKeywordTextPane(NBORun.this.getKeywordsFromButtons());
                mainTextEditor.setVisible(true);
            }
        });
        bg.add(btnTextEditor);
        selectBox.add(new JLabel("Keywords:  ")).setFont(NBOConfig.nboFont);
        selectBox.add(btnMenuSelect);
        selectBox.add(btnTextEditor);
        mainTextEditor.setVisible(false);
        mainMenuOptions.setVisible(true);
        btnMenuSelect.doClick();
    }

    private JPanel addTextOption() {
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setPreferredSize(new Dimension(270, 240));
        textPanel.setMaximumSize(new Dimension(270, 240));
        textPanel.setAlignmentX(0.5f);
        this.keywordTextPane = new JTextPane();
        this.doSetKeywordTextPane(this.cleanNBOKeylist(this.dialog.inputFileHandler.read47File(false)[1], true));
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.keywordTextPane);
        textPanel.add((Component)sp, "Center");
        JButton saveBtn = new JButton("Save Changes");
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBORun.this.doRunSaveButton();
            }
        });
        textPanel.add((Component)saveBtn, "South");
        textPanel.setVisible(false);
        return textPanel;
    }

    protected void doRunSaveButton() {
        String s = this.keywordTextPane.getText();
        String keywords = "";
        String[] tokens = PT.getTokens(PT.rep(PT.rep(s, "$NBO", ""), "$END", "").trim());
        for (int i = 0; i < tokens.length; ++i) {
            String x = tokens[i];
            String xuc = x.toUpperCase();
            if (xuc.indexOf("FILE=") < 0) {
                keywords = keywords + xuc + " ";
                continue;
            }
            String jobName = x.substring(x.indexOf("=") + 1);
            if (!this.dialog.inputFileHandler.checkSwitch47To(jobName)) {
                return;
            }
            this.tfJobName.setText(jobName);
        }
        String name = this.tfJobName.getText().trim();
        name = this.dialog.inputFileHandler.fixJobName(name);
        this.dialog.inputFileHandler.update47File(name, keywords);
        this.addNBOKeylist();
        this.tfJobName.setText(name);
        this.editBox.repaint();
        this.editBox.revalidate();
    }

    private JPanel addMenuOption() {
        JPanel menuPanel = new JPanel();
        menuPanel.setPreferredSize(new Dimension(270, 240));
        menuPanel.setMaximumSize(new Dimension(270, 240));
        menuPanel.setLayout(new BoxLayout(menuPanel, 1));
        menuPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.keywordButtons = new JRadioButton[RUN_KEYWORD_NAMES.length];
        String keywords = " " + this.cleanNBOKeylist(this.dialog.inputFileHandler.read47File(false)[1], false) + " ";
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            this.keywordButtons[i] = new JRadioButton(RUN_KEYWORD_NAMES[i] + ": " + RUN_KEYWORD_DESC[i]);
            if (NBOUtil.findKeyword(keywords, RUN_KEYWORD_NAMES[i], true) >= 0) {
                this.keywordButtons[i].setSelected(true);
            }
            this.keywordButtons[i].setAlignmentX(0.0f);
            menuPanel.add(this.keywordButtons[i]);
            this.keywordButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBORun.this.doLogKeywords(null);
                }
            });
        }
        JLabel lab2 = new JLabel("(Select one or more)");
        menuPanel.add(lab2);
        menuPanel.setAlignmentX(0.5f);
        menuPanel.setVisible(true);
        return menuPanel;
    }

    protected String cleanNBOKeylist(String params, boolean setJobNameTextField) {
        setJobNameTextField &= this.tfJobName != null;
        String[] fname = new String[1];
        params = NBOUtil.removeNBOFileKeyword(params, fname);
        String[] tokens = PT.getTokens(PT.clean(params));
        String tmp = " ";
        for (int i = 0; i < tokens.length; ++i) {
            tmp = NBOUtil.addNBOKeyword(tmp, tokens[i]);
        }
        if (fname[0] != null && setJobNameTextField) {
            this.tfJobName.setText(fname[0]);
        }
        if (setJobNameTextField && (this.tfJobName.getText().equals("") || fname[0] == null)) {
            this.tfJobName.setText(this.dialog.inputFileHandler.jobStem);
        }
        return tmp.trim();
    }

    protected void doLogJobName(String name) {
        if (name == null) {
            name = this.tfJobName.getText().trim();
            this.tfJobName.setText(name);
        }
        this.dialog.logValue("Job: " + name);
    }

    protected void doLogKeywords(String keywords) {
        if (keywords == null) {
            keywords = this.getKeywordsFromButtons();
        }
        this.dialog.logValue("Keywords: " + keywords);
    }

    protected void doSetKeywordTextPane(String keywords) {
        this.keywordTextPane.setText(keywords);
    }

    protected void notifyFileLoaded() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.dialog.doSetStructure("alpha");
        this.addNBOKeylist();
        for (Component c : this.myPanel.getComponents()) {
            c.setVisible(true);
        }
        this.editBox.getParent().setVisible(true);
        this.editBox.setVisible(true);
        this.doLogKeywords(null);
        this.dialog.repaint();
        this.dialog.revalidate();
    }

    protected String getKeywordsFromButtons() {
        String keywords = " " + this.cleanNBOKeylist(this.dialog.inputFileHandler.read47File(false)[1], false) + " ";
        if (this.keywordButtons == null) {
            return keywords;
        }
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            String name = RUN_KEYWORD_NAMES[i];
            keywords = this.keywordButtons[i].isSelected() ? NBOUtil.addNBOKeyword(keywords, name) : NBOUtil.removeNBOKeyword(keywords, name);
        }
        return keywords;
    }

    public boolean retrieveFile(String s, String path) {
        int j;
        File f = null;
        if (path == null) {
            path = this.dialog.inputFileHandler.fullFilePath;
        }
        this.dialog.logCmd("retrieve " + s);
        String name = s.substring(s.lastIndexOf("/") + 1);
        path = path.endsWith("/") || path.endsWith("\\") ? path + name : path + (path.endsWith("\\") ? "\\" : "/") + name;
        f = new File(path);
        if (f.exists() && (j = JOptionPane.showConfirmDialog(null, "File " + f.getAbsolutePath() + " already exists, do you want to overwrite contents, along with its associated .nn and .nbo files?", "Warning", 0)) == 1) {
            return false;
        }
        try {
            String fileData = this.vwr.getAsciiFileOrNull(s);
            if (fileData == null) {
                this.dialog.logError("Error reading " + s);
                return false;
            }
            if (this.dialog.inputFileHandler.writeToFile(path, fileData)) {
                this.dialog.logInfo(f.getName() + " (" + fileData.length() + " bytes)", 4);
            } else {
                this.dialog.logError("Error writing to " + f);
            }
        }
        catch (Throwable e) {
            this.dialog.alertError("Error reading " + s + ": " + e);
        }
        this.dialog.modelOrigin = 4;
        this.dialog.inputFileHandler.setInputFile(f);
        this.dialog.modelOrigin = 4;
        this.rbLocal.doClick();
        this.dialog.modelOrigin = 3;
        return true;
    }

    protected void doRunGenNBOJob(String requiredKeyword) {
        String jobName;
        if (this.dialog.jmolOptionNONBO) {
            this.dialog.alertRequiresNBOServe();
            return;
        }
        String newKeywords = this.getKeywordsFromButtons();
        this.dialog.inputFileHandler.jobStem = this.dialog.inputFileHandler.jobStem.trim();
        if (requiredKeyword.length() > 0 && this.tfJobName != null) {
            this.tfJobName.setText(this.dialog.inputFileHandler.jobStem);
        }
        if (!this.dialog.inputFileHandler.checkSwitch47To(jobName = this.dialog.inputFileHandler.fixJobName(this.tfJobName == null ? null : this.tfJobName.getText().trim()))) {
            return;
        }
        String[] tokens = PT.getTokens(requiredKeyword);
        for (int i = 0; i < tokens.length; ++i) {
            String x = tokens[i];
            newKeywords = NBOUtil.addNBOKeyword(newKeywords, x);
        }
        newKeywords = NBOUtil.addNBOKeyword(newKeywords, "PLOT");
        String[] fileData = this.dialog.inputFileHandler.update47File(jobName = jobName.equals("") ? this.dialog.inputFileHandler.jobStem : jobName, newKeywords);
        if (fileData == null) {
            return;
        }
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", this.dialog.inputFileHandler.inputFile.getParent());
        NBOUtil.postAddGlobalC(sb, "JOBSTEM", this.dialog.inputFileHandler.jobStem);
        NBOUtil.postAddGlobalC(sb, "ESS", "gennbo");
        NBOUtil.postAddGlobalC(sb, "LABEL_1", "FILE=" + jobName);
        this.dialog.logCmd("RUN GenNBO FILE=" + jobName + " " + this.cleanNBOKeylist(fileData[1], false));
        this.postNBO(sb, "Running GenNBO...");
    }

    private void postNBO(SB sb, String statusMessage) {
        final NBORequest req = new NBORequest();
        req.set(new Runnable(){

            @Override
            public void run() {
                NBORun.this.processNBO(req);
            }
        }, true, statusMessage, "r_cmd.txt", sb.toString());
        this.dialog.nboService.postToNBO(req);
    }

    protected void processNBO(NBORequest req) {
        this.dialog.inputFileHandler.setInputFile(this.dialog.inputFileHandler.inputFile);
    }

    class ArchiveViewer
    extends JDialog
    implements ActionListener {
        private JScrollPane archivePanel;
        private JButton selectAll;
        private JButton download;
        private JCheckBox[] jcLinks;
        private JTextField tfPath;
        private String baseDir;

        public ArchiveViewer(NBODialog d, String url) {
            super((Dialog)d, "NBO Archive Files");
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth() / 2 - 250;
            int height = gd.getDisplayMode().getHeight() / 2 - 120;
            this.setLocation(width, height);
            this.setSize(new Dimension(500, 240));
            this.setLayout(new BorderLayout());
            this.setResizable(false);
            this.archivePanel = new JScrollPane();
            this.archivePanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.archivePanel, "Center");
            String[] links = this.getLinks(url);
            this.setLinks(links, null);
            Box bottom = Box.createHorizontalBox();
            this.tfPath = new JTextField(d.inputFileHandler.fullFilePath);
            bottom.add(new JLabel("  Download to: "));
            bottom.add(this.tfPath);
            if (ALLOW_SELECT_ALL) {
                this.selectAll = new JButton("Select All");
                this.selectAll.addActionListener(this);
                bottom.add(this.selectAll);
            }
            this.download = new JButton("Download");
            this.download.addActionListener(this);
            bottom.add(this.download);
            this.add((Component)bottom, "South");
        }

        private String[] getLinks(String baseDir) {
            String sep;
            String html;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            this.baseDir = baseDir;
            String fileList = NBORun.this.dialog.inputFileHandler.getFileData(baseDir + "47files.txt");
            if (fileList == null) {
                html = NBORun.this.dialog.inputFileHandler.getFileData(baseDir);
                sep = "<a";
            } else {
                if (fileList.indexOf("{") == 0 || fileList.indexOf("[") == 0) {
                    ArrayList list;
                    Map<String, Object> map = new JSJSONParser().parseMap(fileList, true);
                    ArrayList arrayList = list = map == null ? null : (ArrayList)map.get("47files");
                    if (list == null || list.size() == 0) {
                        return new String[0];
                    }
                    String ext = ((String)list.get(0)).indexOf(".47") >= 0 ? "" : ".47";
                    String[] a = list.toArray(new String[0]);
                    for (int i = 0; i < list.size(); ++i) {
                        a[i] = baseDir + (String)list.get(i) + ext;
                    }
                    return a;
                }
                html = PT.rep(fileList, "\r", "");
                sep = "\n";
            }
            ArrayList<String> files = new ArrayList<String>();
            String[] toks = html.split(sep);
            for (int i = 1; i < toks.length; ++i) {
                String file = PT.getQuotedAttribute(toks[i], "href");
                if (file == null || !file.endsWith(".47")) continue;
                files.add(file);
            }
            return files.toArray(new String[0]);
        }

        private void setLinks(String[] links, String startsWith) {
            this.jcLinks = new JCheckBox[links.length];
            JPanel filePanel = new JPanel(new FlowLayout());
            if (startsWith == null) {
                startsWith = "";
            }
            ButtonGroup bg = ALLOW_SELECT_ALL ? null : new ButtonGroup();
            for (int i = 0; i < links.length; i += 6) {
                Box box = Box.createVerticalBox();
                for (int j = 0; j < 6 && i + j < this.jcLinks.length; ++j) {
                    this.jcLinks[i + j] = new JCheckBox(links[i + j]);
                    if (bg != null) {
                        bg.add(this.jcLinks[i + j]);
                    }
                    this.jcLinks[i + j].setBackground(Color.white);
                    box.add(this.jcLinks[i + j]);
                }
                filePanel.add(box);
            }
            filePanel.setBackground(Color.white);
            this.archivePanel.getViewport().add(filePanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.selectAll) {
                int i;
                boolean didCheck = false;
                for (i = 0; i < this.jcLinks.length; ++i) {
                    if (this.jcLinks[i].isSelected()) continue;
                    didCheck = true;
                    this.jcLinks[i].setSelected(true);
                }
                if (!didCheck) {
                    for (i = 0; i < this.jcLinks.length; ++i) {
                        this.jcLinks[i].setSelected(false);
                    }
                }
                this.repaint();
            } else if (e.getSource() == this.download) {
                String s = null;
                for (int i = 0; i < this.jcLinks.length; ++i) {
                    if (!this.jcLinks[i].isSelected()) continue;
                    s = this.baseDir + this.jcLinks[i].getText();
                    break;
                }
                if (s == null) {
                    return;
                }
                this.setVisible(false);
                if (!NBORun.this.retrieveFile(s, this.tfPath.getText())) {
                    this.setVisible(true);
                    return;
                }
            }
        }
    }
}

