/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gennbo.NBOConfig;
import org.gennbo.NBOFileHandler;

public class NBOUtil {
    public static final String sep = System.getProperty("line.separator");
    private static String KEYWORD_IGNORE = "_";

    public static void postAddGlobalC(SB sb, String label, String val) {
        sb.append("GLOBAL C_").append(label).append(" ").append(val).append(sep);
    }

    public static void postAddGlobalI(SB sb, String label, int offset, JComboBox<String> cb) {
        sb.append("GLOBAL I_").append(label).append(" ").appendI(cb == null ? offset : cb.getSelectedIndex() + offset).append(sep);
    }

    public static void postAddGlobalT(SB sb, String key, JTextField t) {
        sb.append("GLOBAL ").append(key).append(" ").append(t.getText()).append(sep);
    }

    public static void postAddGlobal(SB sb, String key, String val) {
        sb.append("GLOBAL ").append(key).append(" ").append(val).append(sep);
    }

    public static SB postAddCmd(SB sb, String cmd) {
        return sb.append("CMD ").append(cmd).append(sep);
    }

    public static Box createTitleBox(String title, Component rightSideComponent) {
        Box box = Box.createVerticalBox();
        JLabel label = new JLabel(title);
        label.setAlignmentX(0.0f);
        label.setBackground(NBOConfig.titleColor);
        label.setForeground(Color.white);
        label.setFont(NBOConfig.titleFont);
        label.setOpaque(true);
        if (rightSideComponent != null) {
            JPanel box2 = new JPanel(new BorderLayout());
            box2.setAlignmentX(0.0f);
            box2.add((Component)label, "West");
            box2.add(rightSideComponent, "East");
            box2.setMaximumSize(new Dimension(360, 25));
            box.add(box2);
        } else {
            box.add(label);
        }
        box.setAlignmentX(0.0f);
        return box;
    }

    public static Box createBorderBox(boolean isVertical) {
        Box box = isVertical ? Box.createVerticalBox() : Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        return box;
    }

    public static String round(double value, int places) {
        return PT.formatD(value, places, -1 - places, false, false, true);
    }

    public static int[] getAtomsPicked(Object[] data) {
        int atom1 = (Integer)data[2];
        if (atom1 >= 0) {
            return new int[]{atom1 + 1, Integer.MIN_VALUE};
        }
        if (atom1 != -3) {
            return new int[]{Integer.MIN_VALUE, 0};
        }
        String[] sdata = PT.split(data[1].toString(), "#");
        atom1 = PT.parseInt(sdata[1]);
        int atom2 = PT.parseInt(sdata[2]);
        System.out.println(atom1 + " picked " + atom2);
        return new int[]{atom1, atom2};
    }

    public static String addNBOKeyword(String tmp, String s) {
        int pt = NBOUtil.findKeyword(tmp, s, false);
        if (pt >= 0) {
            return tmp.substring(0, pt) + tmp.substring(pt + 1);
        }
        if (NBOUtil.findKeyword(tmp, s, true) >= 0) {
            return tmp;
        }
        if (tmp.length() + s.length() - tmp.lastIndexOf(sep) >= 80) {
            tmp = tmp + sep + " ";
        }
        if (tmp.length() == 0) {
            tmp = " ";
        }
        tmp = tmp + s.toUpperCase() + " ";
        return tmp;
    }

    public static int findKeyword(String keywords, String s, boolean ifPresent) {
        String prefix;
        int pt;
        if (!keywords.startsWith(" ")) {
            keywords = " " + keywords + " ";
        }
        return (pt = keywords.indexOf((prefix = ifPresent ? " " : KEYWORD_IGNORE) + s + " ")) >= 0 ? pt : ((pt = keywords.indexOf(prefix + s + "=")) >= 0 ? pt : -1);
    }

    public static String removeNBOKeyword(String keywords, String name) {
        int pt = NBOUtil.findKeyword(keywords, name, false);
        if (pt >= 0) {
            return keywords;
        }
        pt = NBOUtil.findKeyword(keywords, name, true);
        if (pt < 0) {
            return keywords;
        }
        return keywords.substring(0, pt) + " " + KEYWORD_IGNORE + keywords.substring(pt + 1);
    }

    public static String removeNBOFileKeyword(String nboKeywords, String[] fnameRet) {
        String[] tokens = PT.getTokens(nboKeywords);
        nboKeywords = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].indexOf("=") < 0 || tokens[i].toUpperCase().indexOf("FILE=") < 0) {
                nboKeywords = nboKeywords + " " + tokens[i].toUpperCase();
                continue;
            }
            if (fnameRet == null) continue;
            fnameRet[0] = tokens[i].substring(5);
        }
        return nboKeywords.trim();
    }

    public static boolean lineContainsUncommented(String line, String key) {
        int ptComment;
        int ptKey = line.indexOf(key);
        return ptKey >= 0 && ((ptComment = line.indexOf("!")) < 0 || ptComment > ptKey);
    }

    public static String removeNBOComment(String line) {
        int ptComment = line.indexOf("!");
        return ptComment < 0 ? line : line.substring(0, ptComment);
    }

    public static boolean read47FileBuffered(File inputFile, SB data, boolean doAll) {
        try {
            String line;
            boolean have$NBO = false;
            boolean haveNBO$END = false;
            BufferedReader b = null;
            b = new BufferedReader(new FileReader(inputFile));
            while ((line = b.readLine()) != null && (doAll || !line.contains("$COORD"))) {
                if ((have$NBO && !haveNBO$END || !have$NBO && (have$NBO = NBOUtil.lineContainsUncommented(line, "$NBO"))) && (line = NBOUtil.removeNBOComment(line)).indexOf("$END") >= 0) {
                    haveNBO$END = true;
                }
                data.append(line + NBOFileHandler.sep);
            }
            b.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getExt(File newFile) {
        String fname = newFile.toString();
        return fname.substring(fname.lastIndexOf(".") + 1);
    }

    public static String getJobStem(File inputFile) {
        String fname = inputFile.getName();
        return fname.substring(0, fname.lastIndexOf("."));
    }

    public static String pathWithoutExtension(String fname) {
        int pt = fname.lastIndexOf(".");
        return pt < 0 ? fname : fname.substring(0, pt);
    }

    public static File newNBOFile(File f, String ext) {
        return new File(NBOUtil.pathWithoutExtension(NBOUtil.fixPath(f.toString())) + "." + ext);
    }

    public static String fix47File(String data) {
        return PT.rep(data, "FORMAT=PRECISE", "");
    }

    public static String fixPath(String path) {
        return path.replace('\\', '/');
    }

    public static String getWindowsFolderFor(String folder, String fullFilePath) {
        return folder.equals("") ? new File(fullFilePath).getParent() : (!folder.contains(":") ? (folder = "C:/" + folder) : folder);
    }

    public static String getWindowsFullNameFor(String folder, String name, String ext) {
        if (!folder.equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
            folder = folder + "/" + (name.equals("") ? "" : name + (ext == null ? "" : "." + ext));
        }
        return folder;
    }
}

