/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.java.BS;
import org.jmol.modelset.ModelSet;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class AnimationManager {
    public JmolThread animationThread;
    public Viewer vwr;
    public boolean animationOn;
    public int animationFps;
    public int firstFrameDelayMs;
    public int lastFrameDelayMs;
    static final int FRAME_FIRST = -1;
    static final int FRAME_LAST = 1;
    static final int MODEL_CURRENT = 0;
    final BS bsVisibleModels = new BS();
    public int animationReplayMode = 1073742070;
    BS bsDisplay;
    int[] animationFrames;
    public boolean isMovie;
    boolean animationPaused;
    public int cmi;
    int caf;
    int morphCount;
    int animationDirection = 1;
    int currentDirection = 1;
    int firstFrameIndex;
    int lastFrameIndex;
    int frameStep;
    int backgroundModelIndex = -1;
    float currentMorphModel;
    float firstFrameDelay;
    float lastFrameDelay = 1.0f;
    private int lastFramePainted;
    private int lastModelPainted;
    private int intAnimThread;
    public int cai = -1;

    AnimationManager(Viewer vwr) {
        this.vwr = vwr;
    }

    public void setAnimationOn(boolean animationOn) {
        if (animationOn == this.animationOn) {
            return;
        }
        if (!animationOn || this.vwr.headless) {
            this.stopThread(false);
            return;
        }
        if (!this.vwr.tm.spinOn) {
            this.vwr.refresh(3, "Anim:setAnimationOn");
        }
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    public void stopThread(boolean isPaused) {
        boolean stopped = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
            stopped = true;
        }
        this.animationPaused = isPaused;
        if (stopped && !this.vwr.tm.spinOn) {
            this.vwr.refresh(3, "Viewer:setAnimationOff");
        }
        this.animation(false);
        this.vwr.setStatusFrameChanged(false, false);
    }

    public boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    public boolean currentIsLast() {
        return this.isMovie ? this.lastFramePainted == this.caf : this.lastModelPainted == this.cmi;
    }

    public boolean currentFrameIs(int f) {
        int i = this.cmi;
        return this.morphCount == 0 ? i == f : Math.abs(this.currentMorphModel - (float)f) < 0.001f;
    }

    void clear() {
        this.setMovie(null);
        this.initializePointers(0);
        this.setAnimationOn(false);
        this.setModel(0, true);
        this.currentDirection = 1;
        this.cai = -1;
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(1073742070, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    String getModelSpecial(int i) {
        switch (i) {
            case -1: {
                if (this.animationFrames != null) {
                    return "1";
                }
                i = this.firstFrameIndex;
                break;
            }
            case 0: {
                if (this.morphCount > 0) {
                    return "-" + (1.0f + this.currentMorphModel);
                }
                i = this.cmi;
                break;
            }
            case 1: {
                if (this.animationFrames != null) {
                    return "" + this.animationFrames.length;
                }
                i = this.lastFrameIndex;
            }
        }
        return this.vwr.getModelNumberDotted(i);
    }

    void setDisplay(BS bs) {
        this.bsDisplay = bs == null || bs.isEmpty() ? null : BSUtil.copy(bs);
    }

    public void setMorphCount(int n) {
        this.morphCount = this.isMovie ? 0 : n;
    }

    public void morph(float modelIndex) {
        int m = (int)modelIndex;
        if (Math.abs((float)m - modelIndex) < 0.001f) {
            modelIndex = m;
        } else if (Math.abs((float)m - modelIndex) > 0.999f) {
            modelIndex = ++m;
        }
        float f = modelIndex - (float)m;
        --m;
        if (f == 0.0f) {
            this.currentMorphModel = m;
            this.setModel(m, true);
            return;
        }
        this.setModel(m, true);
        int m1 = m + 1;
        this.currentMorphModel = (float)m + f;
        if (m1 == m || m1 < 0 || m < 0) {
            return;
        }
        this.vwr.ms.morphTrajectories(m, m1, f);
    }

    void setModel(int modelIndex, boolean clearBackgroundModel) {
        int modelCount;
        if (modelIndex < 0) {
            this.stopThread(false);
        }
        int formerModelIndex = this.cmi;
        ModelSet modelSet = this.vwr.ms;
        int n = modelCount = modelSet == null ? 0 : modelSet.mc;
        if (modelCount == 1) {
            modelIndex = 0;
            this.cmi = 0;
        } else if (modelIndex < 0 || modelIndex >= modelCount) {
            modelIndex = -1;
        }
        String ids = null;
        boolean isSameSource = false;
        if (this.cmi != modelIndex) {
            if (modelCount > 0) {
                ModelSet ms = this.vwr.ms;
                boolean toDataModel = ms.isJmolDataFrameForModel(modelIndex);
                boolean fromDataModel = ms.isJmolDataFrameForModel(this.cmi);
                if (fromDataModel) {
                    ms.setJmolDataFrame(null, -1, this.cmi);
                }
                if (this.cmi != -1) {
                    this.vwr.saveModelOrientation();
                }
                if (fromDataModel || toDataModel) {
                    ids = ms.getJmolFrameType(modelIndex) + " " + modelIndex + " <-- " + " " + this.cmi + " " + ms.getJmolFrameType(this.cmi);
                    isSameSource = ms.getJmolDataSourceFrame(modelIndex) == ms.getJmolDataSourceFrame(this.cmi);
                }
            }
            this.cmi = modelIndex;
            if (ids != null) {
                if (modelIndex >= 0) {
                    this.vwr.restoreModelOrientation(modelIndex);
                }
                if (isSameSource && (ids.indexOf("quaternion") >= 0 || ids.indexOf("plot") < 0 && ids.indexOf("ramachandran") < 0 && ids.indexOf(" property ") < 0)) {
                    this.vwr.restoreModelRotation(formerModelIndex);
                }
            }
        }
        this.setViewer(clearBackgroundModel);
    }

    void setBackgroundModelIndex(int modelIndex) {
        ModelSet modelSet = this.vwr.ms;
        if (modelSet == null || modelIndex < 0 || modelIndex >= modelSet.mc) {
            modelIndex = -1;
        }
        this.backgroundModelIndex = modelIndex;
        if (modelIndex >= 0) {
            this.vwr.ms.setTrajectory(modelIndex);
        }
        this.vwr.setTainted(true);
        this.setFrameRangeVisible();
    }

    void initializePointers(int frameStep) {
        this.firstFrameIndex = 0;
        this.lastFrameIndex = (frameStep == 0 ? 0 : this.getFrameCount()) - 1;
        this.frameStep = frameStep;
        this.vwr.setFrameVariables();
    }

    public void setAnimationDirection(int animationDirection) {
        this.animationDirection = animationDirection;
    }

    void setAnimationFps(int fps) {
        if (fps < 1) {
            fps = 1;
        }
        if (fps > 50) {
            fps = 50;
        }
        this.animationFps = fps;
        this.vwr.setFrameVariables();
    }

    public void setAnimationReplayMode(int animationReplayMode, float firstFrameDelay, float lastFrameDelay) {
        this.firstFrameDelay = firstFrameDelay > 0.0f ? firstFrameDelay : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = lastFrameDelay > 0.0f ? lastFrameDelay : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        this.animationReplayMode = animationReplayMode;
        this.vwr.setFrameVariables();
    }

    void setAnimationRange(int framePointer, int framePointer2) {
        int frameCount = this.getFrameCount();
        if (framePointer < 0) {
            framePointer = 0;
        }
        if (framePointer2 < 0) {
            framePointer2 = frameCount;
        }
        if (framePointer >= frameCount) {
            framePointer = frameCount - 1;
        }
        if (framePointer2 >= frameCount) {
            framePointer2 = frameCount - 1;
        }
        this.firstFrameIndex = framePointer;
        this.currentMorphModel = this.firstFrameIndex;
        this.lastFrameIndex = framePointer2;
        this.frameStep = framePointer2 < framePointer ? -1 : 1;
        this.rewindAnimation();
    }

    void pauseAnimation() {
        this.stopThread(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void repaintDone() {
        this.lastModelPainted = this.cmi;
        this.lastFramePainted = this.caf;
    }

    void resumeAnimation() {
        if (this.cmi < 0) {
            this.setAnimationRange(this.firstFrameIndex, this.lastFrameIndex);
        }
        if (this.getFrameCount() <= 1) {
            this.animation(false);
            return;
        }
        this.animation(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            this.animationThread = (JmolThread)Interface.getOption("thread.AnimationThread", this.vwr, "script");
            this.animationThread.setManager(this, this.vwr, new int[]{this.firstFrameIndex, this.lastFrameIndex, ++this.intAnimThread});
            this.animationThread.start();
        }
    }

    void setAnimationLast() {
        this.setFrame(this.animationDirection > 0 ? this.lastFrameIndex : this.firstFrameIndex);
    }

    void rewindAnimation() {
        this.setFrame(this.animationDirection > 0 ? this.firstFrameIndex : this.lastFrameIndex);
        this.currentDirection = 1;
        this.vwr.setFrameVariables();
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    float getAnimRunTimeSeconds() {
        int frameCount = this.getFrameCount();
        if (this.firstFrameIndex == this.lastFrameIndex || this.lastFrameIndex < 0 || this.firstFrameIndex < 0 || this.lastFrameIndex >= frameCount || this.firstFrameIndex >= frameCount) {
            return 0.0f;
        }
        int i0 = Math.min(this.firstFrameIndex, this.lastFrameIndex);
        int i1 = Math.max(this.firstFrameIndex, this.lastFrameIndex);
        float nsec = 1.0f * (float)(i1 - i0) / (float)this.animationFps + this.firstFrameDelay + this.lastFrameDelay;
        for (int i = i0; i <= i1; ++i) {
            nsec += (float)this.vwr.ms.getFrameDelayMs(this.modelIndexForFrame(i)) / 1000.0f;
        }
        return nsec;
    }

    public void setMovie(Map<String, Object> info) {
        boolean bl = this.isMovie = info != null && info.get("scripts") == null;
        if (this.isMovie) {
            this.animationFrames = (int[])info.get("frames");
            if (this.animationFrames == null || this.animationFrames.length == 0) {
                this.isMovie = false;
            } else {
                this.caf = (Integer)info.get("currentFrame");
                if (this.caf < 0 || this.caf >= this.animationFrames.length) {
                    this.caf = 0;
                }
            }
            this.setFrame(this.caf);
        }
        if (!this.isMovie) {
            this.animationFrames = null;
        }
        this.vwr.setBooleanProperty("_ismovie", this.isMovie);
        this.bsDisplay = null;
        this.morphCount = 0;
        this.currentMorphModel = 0;
        this.vwr.setFrameVariables();
    }

    int modelIndexForFrame(int i) {
        return this.isMovie ? this.animationFrames[i] - 1 : i;
    }

    public int getFrameCount() {
        return this.isMovie ? this.animationFrames.length : this.vwr.ms.mc;
    }

    public void setFrame(int i) {
        try {
            if (this.isMovie) {
                int iModel = this.modelIndexForFrame(i);
                this.caf = i;
                i = iModel;
            } else {
                this.caf = i;
            }
            this.setModel(i, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setViewer(boolean clearBackgroundModel) {
        this.vwr.ms.setTrajectory(this.cmi);
        this.vwr.tm.setFrameOffset(this.cmi);
        if (this.cmi == -1 && clearBackgroundModel) {
            this.setBackgroundModelIndex(-1);
        }
        this.vwr.setTainted(true);
        int nDisplay = this.setFrameRangeVisible();
        this.vwr.setStatusFrameChanged(false, false);
        if (!this.vwr.g.selectAllModels) {
            this.setSelectAllSubset(nDisplay < 2);
        }
    }

    void setSelectAllSubset(boolean justOne) {
        if (this.vwr.ms != null) {
            this.vwr.slm.setSelectionSubset(justOne ? this.vwr.ms.getModelAtomBitSetIncludingDeleted(this.cmi, true) : this.vwr.ms.getModelAtomBitSetIncludingDeletedBs(this.bsVisibleModels));
        }
    }

    private int setFrameRangeVisible() {
        int nDisplayed = 0;
        this.bsVisibleModels.clearAll();
        if (this.backgroundModelIndex >= 0) {
            this.bsVisibleModels.set(this.backgroundModelIndex);
            nDisplayed = 1;
        }
        if (this.cmi >= 0) {
            this.bsVisibleModels.set(this.cmi);
            return ++nDisplayed;
        }
        if (this.frameStep == 0) {
            return nDisplayed;
        }
        int frameDisplayed = 0;
        nDisplayed = 0;
        for (int iframe = this.firstFrameIndex; iframe != this.lastFrameIndex; iframe += this.frameStep) {
            int i = this.modelIndexForFrame(iframe);
            if (this.vwr.ms.isJmolDataFrameForModel(i)) continue;
            this.bsVisibleModels.set(i);
            ++nDisplayed;
            frameDisplayed = iframe;
        }
        int i = this.modelIndexForFrame(this.lastFrameIndex);
        if (this.firstFrameIndex == this.lastFrameIndex || !this.vwr.ms.isJmolDataFrameForModel(i) || nDisplayed == 0) {
            this.bsVisibleModels.set(i);
            if (nDisplayed == 0) {
                this.firstFrameIndex = this.lastFrameIndex;
            }
            nDisplayed = 0;
        }
        if (nDisplayed == 1 && this.cmi < 0) {
            this.setFrame(frameDisplayed);
        }
        return nDisplayed;
    }

    private void animation(boolean TF) {
        this.animationOn = TF;
        this.vwr.setBooleanProperty("_animating", TF);
    }

    private boolean setAnimationRelative(int direction) {
        boolean isDone;
        int frameStep = this.getFrameStep(direction);
        int thisFrame = this.isMovie ? this.caf : this.cmi;
        int frameNext = thisFrame + frameStep;
        float morphStep = 0.0f;
        float nextMorphFrame = 0.0f;
        if (this.morphCount > 0) {
            morphStep = 1.0f / (float)(this.morphCount + 1);
            nextMorphFrame = this.currentMorphModel + (float)frameStep * morphStep;
            isDone = this.isNotInRange(nextMorphFrame);
        } else {
            isDone = this.isNotInRange(frameNext);
        }
        if (isDone) {
            switch (this.animationReplayMode) {
                case 1073742070: {
                    return false;
                }
                case 528411: {
                    frameNext = this.animationDirection == this.currentDirection ? this.firstFrameIndex : this.lastFrameIndex;
                    nextMorphFrame = frameNext;
                    break;
                }
                case 1073742082: {
                    this.currentDirection = -this.currentDirection;
                    frameNext -= 2 * frameStep;
                    nextMorphFrame -= (float)(2 * frameStep) * morphStep;
                }
            }
        }
        if (this.morphCount < 1) {
            if (frameNext < 0 || frameNext >= this.getFrameCount()) {
                return false;
            }
            this.setFrame(frameNext);
            return true;
        }
        this.morph(nextMorphFrame + 1.0f);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNotInRange(float frameNext) {
        float f;
        float f2 = frameNext - 0.001f;
        if (f2 > (float)this.firstFrameIndex) {
            if (f2 > (float)this.lastFrameIndex) return true;
        }
        f2 = frameNext + 0.001f;
        if (!(f < (float)this.firstFrameIndex)) return false;
        if (!(f2 < (float)this.lastFrameIndex)) return false;
        return true;
    }

    private int getFrameStep(int direction) {
        return this.frameStep * direction * this.currentDirection;
    }
}

