/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javajs.util.SB;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class AtomSetChooser
extends JFrame
implements TreeSelectionListener,
PropertyChangeListener,
ActionListener,
ChangeListener,
Runnable {
    private Thread animThread = null;
    private JTextArea propertiesTextArea;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private Viewer vwr;
    private JCheckBox repeatCheckBox;
    private JSlider selectSlider;
    private JLabel infoLabel;
    private JSlider fpsSlider;
    private JSlider amplitudeSlider;
    private JSlider periodSlider;
    private JSlider scaleSlider;
    private JSlider radiusSlider;
    private JFileChooser saveChooser;
    static final String REWIND = "rewind";
    static final String PREVIOUS = "prev";
    static final String PLAY = "play";
    static final String PAUSE = "pause";
    static final String NEXT = "next";
    static final String FF = "ff";
    static final String SAVE = "save";
    static final String COLLECTION = "collection";
    static final String VECTOR = "vector";
    private int[] indexes;
    private int currentIndex = -1;
    private static final int FPS_MAX = 30;
    private static final float AMPLITUDE_PRECISION = 0.01f;
    private static final float AMPLITUDE_MAX = 1.0f;
    private static final float AMPLITUDE_VALUE = 0.5f;
    private static final float PERIOD_PRECISION = 0.001f;
    private static final float PERIOD_MAX = 1.0f;
    private static final float PERIOD_VALUE = 0.5f;
    private static final int RADIUS_MAX = 19;
    private static final int RADIUS_VALUE = 3;
    private static final float SCALE_PRECISION = 0.01f;
    private static final float SCALE_MAX = 2.0f;
    private static final float SCALE_VALUE = 1.0f;
    private int radiusValue = 1;

    public AtomSetChooser(Viewer vwr, JFrame frame) {
        super(GT._("AtomSetChooser"));
        this.vwr = vwr;
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(GT._("No AtomSets")));
        this.layoutWindow(this.getContentPane());
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void layoutWindow(Container container) {
        container.setLayout(new BorderLayout());
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        this.tree = new JTree(this.treeModel);
        this.tree.setVisibleRowCount(5);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setEnabled(false);
        treePanel.add((Component)new JScrollPane(this.tree), "Center");
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setLayout(new BorderLayout());
        propertiesPanel.setBorder(new TitledBorder(GT._("Properties")));
        this.propertiesTextArea = new JTextArea();
        this.propertiesTextArea.setEditable(false);
        propertiesPanel.add((Component)new JScrollPane(this.propertiesTextArea), "Center");
        JPanel astPanel = new JPanel();
        astPanel.setLayout(new BorderLayout());
        astPanel.setBorder(new TitledBorder(GT._("Atom Set Collection")));
        JSplitPane splitPane = new JSplitPane(0, treePanel, propertiesPanel);
        astPanel.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.5);
        container.add((Component)astPanel, "Center");
        JPanel controllerPanel = new JPanel();
        controllerPanel.setLayout(new BoxLayout(controllerPanel, 1));
        container.add((Component)controllerPanel, "South");
        JPanel collectionPanel = new JPanel();
        collectionPanel.setLayout(new BoxLayout(collectionPanel, 1));
        collectionPanel.setBorder(new TitledBorder(GT._("Collection")));
        controllerPanel.add(collectionPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.setBorder(new TitledBorder(GT._("Info")));
        this.infoLabel = new JLabel(" ");
        infoPanel.add((Component)this.infoLabel, "South");
        collectionPanel.add(infoPanel);
        JPanel cpsPanel = new JPanel();
        cpsPanel.setLayout(new BorderLayout());
        cpsPanel.setBorder(new TitledBorder(GT._("Select")));
        this.selectSlider = new JSlider(0, 0, 0);
        this.selectSlider.addChangeListener(this);
        this.selectSlider.setMajorTickSpacing(5);
        this.selectSlider.setMinorTickSpacing(1);
        this.selectSlider.setPaintTicks(true);
        this.selectSlider.setSnapToTicks(true);
        this.selectSlider.setEnabled(false);
        cpsPanel.add((Component)this.selectSlider, "South");
        collectionPanel.add(cpsPanel);
        JPanel row = new JPanel();
        collectionPanel.add(row);
        row.setLayout(new BoxLayout(row, 0));
        this.repeatCheckBox = new JCheckBox(GT._("Repeat"), false);
        JPanel vcrpanel = this.createVCRController(COLLECTION);
        vcrpanel.add(this.repeatCheckBox);
        row.add(vcrpanel);
        JPanel fpsPanel = new JPanel();
        row.add(fpsPanel);
        int fps = this.vwr.getInt(553648132);
        if (fps > 30) {
            fps = 30;
        }
        fpsPanel.setLayout(new BorderLayout());
        fpsPanel.setBorder(new TitledBorder(GT._("FPS")));
        this.fpsSlider = new JSlider(0, 30, fps);
        this.fpsSlider.setMajorTickSpacing(5);
        this.fpsSlider.setMinorTickSpacing(1);
        this.fpsSlider.setPaintTicks(true);
        this.fpsSlider.setSnapToTicks(true);
        this.fpsSlider.addChangeListener(this);
        fpsPanel.add((Component)this.fpsSlider, "South");
        JPanel vectorPanel = new JPanel();
        controllerPanel.add(vectorPanel);
        vectorPanel.setLayout(new BoxLayout(vectorPanel, 1));
        vectorPanel.setBorder(new TitledBorder(GT._("Vector")));
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        JPanel radiusPanel = new JPanel();
        radiusPanel.setLayout(new BorderLayout());
        radiusPanel.setBorder(new TitledBorder(GT._("Radius")));
        this.radiusSlider = new JSlider(0, 19, 3);
        this.radiusSlider.setMajorTickSpacing(5);
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setSnapToTicks(true);
        this.radiusSlider.addChangeListener(this);
        this.script("vector 3");
        radiusPanel.add(this.radiusSlider);
        row1.add(radiusPanel);
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new BorderLayout());
        scalePanel.setBorder(new TitledBorder(GT._("Scale")));
        this.scaleSlider = new JSlider(0, 200, 100);
        this.scaleSlider.addChangeListener(this);
        this.script("vector scale 1.0");
        scalePanel.add(this.scaleSlider);
        row1.add(scalePanel);
        vectorPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        JPanel amplitudePanel = new JPanel();
        amplitudePanel.setLayout(new BorderLayout());
        amplitudePanel.setBorder(new TitledBorder(GT._("Amplitude")));
        this.amplitudeSlider = new JSlider(0, 100, 50);
        this.script("vibration scale 0.5");
        this.amplitudeSlider.addChangeListener(this);
        amplitudePanel.add(this.amplitudeSlider);
        row2.add(amplitudePanel);
        JPanel periodPanel = new JPanel();
        periodPanel.setLayout(new BorderLayout());
        periodPanel.setBorder(new TitledBorder(GT._("Period")));
        this.periodSlider = new JSlider(0, 999, 499);
        this.script("vibration 0.5;vibration off;");
        this.periodSlider.addChangeListener(this);
        periodPanel.add(this.periodSlider);
        row2.add(periodPanel);
        vectorPanel.add(row2);
        vectorPanel.add(this.createVCRController(VECTOR));
    }

    private JPanel createVCRController(String section) {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setBorder(new TitledBorder(section.equals(COLLECTION) ? GT._("Frame") : GT._("Vibration")));
        Insets inset = new Insets(1, 1, 1, 1);
        String[] buttons = new String[]{REWIND, PREVIOUS, PLAY, PAUSE, NEXT, FF};
        String[] tooltips = null;
        if (section.equals(COLLECTION)) {
            tooltips = new String[]{GT._("Go to first atom set in the collection"), GT._("Go to previous atom set in the collection"), GT._("Play the whole collection of atom sets"), GT._("Pause playing"), GT._("Go to next atom set in the collection"), GT._("Jump to last atom set in the collection")};
        } else if (section.equals(VECTOR)) {
            tooltips = new String[]{GT._("Go to first atom set in the collection"), GT._("Go to previous atom set in the collection"), GT._("Vibration ON"), GT._("Vibration OFF"), GT._("Go to next atom set in the collection"), GT._("Jump to last atom set in the collection")};
        }
        int i = buttons.length;
        int idx = 0;
        while (--i >= 0) {
            String action = buttons[idx];
            JButton btn = new JButton(JmolResourceHandler.getIconX("AtomSetChooser." + action + "Image"));
            if (tooltips != null && tooltips.length > idx) {
                btn.setToolTipText(tooltips[idx]);
            }
            btn.setMargin(inset);
            btn.setActionCommand(section + "." + action);
            btn.addActionListener(this);
            controlPanel.add(btn);
            ++idx;
        }
        controlPanel.add(Box.createHorizontalGlue());
        return controlPanel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            int index = 0;
            if (node.isLeaf()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this.setIndexes(parent);
                index = parent.getIndex(node);
            } else {
                this.setIndexes(node);
            }
            this.showAtomSetIndex(index, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showAtomSetIndex(int index, boolean bSetSelectSlider) {
        if (bSetSelectSlider) {
            this.selectSlider.setValue(index);
            return;
        }
        try {
            this.currentIndex = index;
            int atomSetIndex = this.indexes[index];
            this.script("frame " + this.vwr.getModelNumberDotted(atomSetIndex));
            this.infoLabel.setText(this.vwr.getModelName(atomSetIndex));
            this.showProperties(this.vwr.ms.am[atomSetIndex].properties);
            this.showAuxiliaryInfo(this.vwr.ms.getModelAuxiliaryInfo(atomSetIndex));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setIndexes(DefaultMutableTreeNode node) {
        int atomSetCount = node.getLeafCount();
        this.indexes = new int[atomSetCount];
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        int idx = 0;
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            this.indexes[idx++] = ((AtomSet)node).getAtomSetIndex();
        }
        this.selectSlider.setEnabled(atomSetCount > 0);
        this.selectSlider.setMaximum(atomSetCount - 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String[] parts = cmd.split("\\.");
        try {
            if (parts.length == 2) {
                String section = parts[0];
                cmd = parts[1];
                if (COLLECTION.equals(section)) {
                    if (REWIND.equals(cmd)) {
                        this.animThread = null;
                        this.showAtomSetIndex(0, true);
                    } else if (PREVIOUS.equals(cmd)) {
                        this.showAtomSetIndex(this.currentIndex - 1, true);
                    } else if (PLAY.equals(cmd)) {
                        if (this.animThread == null) {
                            this.animThread = new Thread((Runnable)this, "AtomSetChooserAnimationThread");
                            this.animThread.start();
                        }
                    } else if (PAUSE.equals(cmd)) {
                        this.animThread = null;
                    } else if (NEXT.equals(cmd)) {
                        this.showAtomSetIndex(this.currentIndex + 1, true);
                    } else if (FF.equals(cmd)) {
                        this.animThread = null;
                        this.showAtomSetIndex(this.indexes.length - 1, true);
                    } else if (SAVE.equals(cmd)) {
                        this.saveXYZCollection();
                    }
                } else if (VECTOR.equals(section)) {
                    if (REWIND.equals(cmd)) {
                        this.findFrequency(0, 1);
                    } else if (PREVIOUS.equals(cmd)) {
                        this.findFrequency(this.currentIndex - 1, -1);
                    } else if (PLAY.equals(cmd)) {
                        this.script("vibration on; vectors " + this.radiusValue);
                    } else if (PAUSE.equals(cmd)) {
                        this.script("vibration off; vectors off");
                    } else if (NEXT.equals(cmd)) {
                        this.findFrequency(this.currentIndex + 1, 1);
                    } else if (FF.equals(cmd)) {
                        this.findFrequency(this.indexes.length - 1, -1);
                    } else if (SAVE.equals(cmd)) {
                        Logger.warn("Not implemented");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveXYZCollection() {
        int retval;
        int nidx = this.indexes.length;
        if (nidx == 0) {
            Logger.warn("No collection selected.");
            return;
        }
        if (this.saveChooser == null) {
            this.saveChooser = new JFileChooser();
        }
        if ((retval = this.saveChooser.showSaveDialog(this)) == 0) {
            File file = this.saveChooser.getSelectedFile();
            String fname = file.getAbsolutePath();
            try {
                PrintWriter f = new PrintWriter(new FileOutputStream(fname));
                for (int idx = 0; idx < nidx; ++idx) {
                    int modelIndex = this.indexes[idx];
                    SB str = new SB();
                    str.append(this.vwr.getModelName(modelIndex)).append("\n");
                    int natoms = 0;
                    int n = this.vwr.ms.ac;
                    for (int i = 0; i < n; ++i) {
                        if (this.vwr.ms.at[i].mi != modelIndex) continue;
                        ++natoms;
                        Atom p = this.vwr.ms.at[i];
                        str.append(this.vwr.ms.at[i].getAtomName()).append("\t");
                        str.appendF(p.x).append("\t").appendF(p.y).append("\t").appendF(p.z).append("\n");
                    }
                    f.println(natoms);
                    f.print(str);
                }
                f.close();
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void findFrequency(int index, int increment) {
        int maxIndex = this.indexes.length;
        boolean foundFrequency = false;
        while (index >= 0 && index < maxIndex && !(foundFrequency = this.vwr.modelHasVibrationVectors(this.indexes[index]))) {
            index += increment;
        }
        if (foundFrequency) {
            this.showAtomSetIndex(index, true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        int value = ((JSlider)src).getValue();
        String cmd = null;
        if (src == this.selectSlider) {
            this.showAtomSetIndex(value, false);
        } else if (src == this.fpsSlider) {
            if (value == 0) {
                this.fpsSlider.setValue(1);
            } else {
                cmd = "animation fps " + value;
            }
        } else if (src == this.radiusSlider) {
            if (value == 0) {
                value = 1;
                this.radiusSlider.setValue(1);
            } else {
                cmd = "vector " + value;
            }
            this.radiusValue = value;
        } else if (src == this.scaleSlider) {
            cmd = "vector scale " + (float)value * 0.01f;
        } else if (src == this.amplitudeSlider) {
            cmd = "vibration scale " + (float)value * 0.01f;
        } else if (src == this.periodSlider) {
            cmd = "vibration " + (float)value * 0.001f;
        }
        if (cmd != null) {
            this.script(cmd);
        }
    }

    private void script(String cmd) {
        this.vwr.evalStringQuiet(cmd + "\u0001## REPAINT_IGNORE ##");
    }

    protected void showProperties(Properties properties) {
        boolean needLF = false;
        this.propertiesTextArea.setText("");
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (propertyName.startsWith(".")) continue;
                this.propertiesTextArea.append((needLF ? "\n " : " ") + propertyName + "=" + properties.getProperty(propertyName));
                needLF = true;
            }
        }
    }

    protected void showAuxiliaryInfo(Map<String, Object> auxiliaryInfo) {
        String separator = " ";
        if (auxiliaryInfo != null) {
            for (String keyName : auxiliaryInfo.keySet()) {
                if (keyName.startsWith(".")) continue;
                this.propertiesTextArea.append(separator + keyName + "=" + auxiliaryInfo.get(keyName));
                separator = "\n ";
            }
        }
    }

    private void createTreeModel() {
        Properties modelSetProperties;
        String key = null;
        String separator = null;
        String name = this.vwr.ms.modelSetName;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(name == null ? "zapped" : name);
        Properties properties = modelSetProperties = name == null ? null : this.vwr.getModelSetProperties();
        if (modelSetProperties != null) {
            key = modelSetProperties.getProperty("PATH_KEY");
            separator = modelSetProperties.getProperty("PATH_SEPARATOR");
        }
        if (key == null || separator == null) {
            if (name != null) {
                int count = this.vwr.ms.mc;
                for (int atomSetIndex = 0; atomSetIndex < count; ++atomSetIndex) {
                    root.add(new AtomSet(atomSetIndex, this.vwr.getModelName(atomSetIndex)));
                }
            }
        } else {
            int count = this.vwr.ms.mc;
            for (int atomSetIndex = 0; atomSetIndex < count; ++atomSetIndex) {
                DefaultMutableTreeNode current = root;
                String path = this.vwr.ms.getModelProperty(atomSetIndex, key);
                if (path != null) {
                    DefaultMutableTreeNode child = null;
                    String[] folders = path.split(separator);
                    int i = 0;
                    int nFolders = folders.length;
                    while (--nFolders >= 0) {
                        boolean found = false;
                        String lookForFolder = folders[i];
                        int childIndex = current.getChildCount();
                        while (--childIndex >= 0 && !(found = lookForFolder.equals((child = (DefaultMutableTreeNode)current.getChildAt(childIndex)).toString()))) {
                        }
                        if (found) {
                            current = child;
                        } else {
                            DefaultMutableTreeNode newFolder = new DefaultMutableTreeNode(lookForFolder);
                            current.add(newFolder);
                            current = newFolder;
                        }
                        ++i;
                    }
                }
                current.add(new AtomSet(atomSetIndex, this.vwr.getModelName(atomSetIndex)));
            }
        }
        this.treeModel.setRoot(root);
        this.treeModel.reload();
        this.tree.setEnabled(root.getChildCount() > 0);
        this.indexes = null;
        this.currentIndex = -1;
        this.selectSlider.setEnabled(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String eventName = propertyChangeEvent.getPropertyName();
        if (eventName.equals("chemFile")) {
            this.createTreeModel();
        }
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        myThread.setPriority(1);
        while (this.animThread == myThread) {
            if (this.currentIndex < 0) {
                this.animThread = null;
                continue;
            }
            ++this.currentIndex;
            if (this.currentIndex == this.indexes.length) {
                if (this.repeatCheckBox.isSelected()) {
                    this.currentIndex = 0;
                } else {
                    --this.currentIndex;
                    this.animThread = null;
                }
            }
            this.showAtomSetIndex(this.currentIndex, true);
            try {
                int fps = this.vwr.getInt(553648132);
                Thread.sleep((int)(1000.0 / (double)(fps == 0 ? 1 : fps)));
            }
            catch (InterruptedException e) {
                Logger.errorEx(null, e);
            }
        }
    }

    private static class AtomSet
    extends DefaultMutableTreeNode {
        private int atomSetIndex;
        private String atomSetName;

        public AtomSet(int atomSetIndex, String atomSetName) {
            this.atomSetIndex = atomSetIndex;
            this.atomSetName = atomSetName;
        }

        public int getAtomSetIndex() {
            return this.atomSetIndex;
        }

        @Override
        public String toString() {
            return this.atomSetName;
        }
    }
}

