/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlMOReader;

public class XmlMolproReader
extends XmlMOReader {
    public XmlMolproReader() {
        this.dslist = "d0 d2- d1+ d2+ d1-";
        this.fclist = "XXX YYY ZZZ XXY XXZ XYY YYZ XZZ YZZ XYZ";
        this.fslist = "f1+ f1- f0 f3+ f2- f3- f2+";
        this.iHaveCoefMaps = true;
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if (!this.processing) {
            return;
        }
        this.processStart2(localName);
        if (!this.processStartMO(localName)) {
            if (localName.equals("normalcoordinate")) {
                this.setKeepChars(false);
                if (!this.parent.doGetVibration(++this.vibrationNumber)) {
                    return;
                }
                try {
                    this.asc.cloneLastAtomSet();
                }
                catch (Exception e) {
                    System.out.println("" + e);
                    this.asc.errorMessage = "Error processing normalCoordinate: " + e.getMessage();
                    this.vibrationNumber = 0;
                    return;
                }
                if (this.atts.containsKey("wavenumber")) {
                    String wavenumber = (String)this.atts.get("wavenumber");
                    String units = "cm^-1";
                    if (this.atts.containsKey("units") && (units = (String)this.atts.get("units")).startsWith("inverseCent")) {
                        units = "cm^-1";
                    }
                    this.asc.setAtomSetFrequency(null, null, wavenumber, units);
                    this.setKeepChars(true);
                }
                return;
            }
            if (localName.equals("vibrations")) {
                this.vibrationNumber = 0;
                return;
            }
        }
    }

    @Override
    void processEndElement(String localName) {
        if (!this.processEndMO(localName) && localName.equals("normalcoordinate")) {
            if (!this.keepChars) {
                return;
            }
            int ac = this.asc.getLastAtomSetAtomCount();
            int baseAtomIndex = this.asc.getLastAtomSetAtomIndex();
            this.tokens = PT.getTokens((String)this.chars.toString());
            int offset = this.tokens.length - ac * 3;
            for (int i = 0; i < ac; ++i) {
                this.asc.addVibrationVector(i + baseAtomIndex, this.parseFloatStr(this.tokens[offset++]), this.parseFloatStr(this.tokens[offset++]), this.parseFloatStr(this.tokens[offset++]));
            }
            this.setKeepChars(false);
        }
        this.processEnd2(localName);
    }
}

