/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;

class UFFDistanceCalc
extends Calculation {
    double r0;
    double kb;

    UFFDistanceCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ia, int ib, double bondOrder) {
        this.calcs.parA = (FFParam)this.calcs.getParameter(this.calcs.minAtoms[ia].sType);
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.calcs.minAtoms[ib].sType);
        this.r0 = CalculationsUFF.calculateR0(this.calcs.parA.dVal[0], this.calcs.parB.dVal[0], this.calcs.parA.dVal[8], this.calcs.parB.dVal[8], bondOrder);
        this.kb = 1390.2842991599998 * this.calcs.parA.dVal[5] * this.calcs.parB.dVal[5] / (this.r0 * this.r0 * this.r0);
        calc.addLast((Object)new Object[]{new int[]{ia, ib}, new double[]{this.r0, this.kb, bondOrder}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        this.r0 = this.dData[0];
        this.kb = this.dData[1];
        this.calcs.setPairVariables(this);
        this.delta = this.rab - this.r0;
        this.energy = this.kb * this.delta * this.delta;
        if (this.calcs.gradients) {
            this.dE = 2.0 * this.kb * this.delta;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(0, this));
        }
        return this.energy;
    }
}

