/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericOutputChannel;
import javajs.util.BC;
import javajs.util.SB;

public class BinaryDocument
extends BC
implements GenericBinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    protected BufferedInputStream bis;
    protected long nBytes;
    protected GenericOutputChannel out;
    byte[] t8 = new byte[8];

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
    }

    @Override
    public BinaryDocument setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        this.bis = bufferedInputStream;
        if (bufferedInputStream != null) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.isBigEndian = bl;
        return this;
    }

    @Override
    public BufferedInputStream getInputStream() {
        return this.bis;
    }

    @Override
    public void setStreamData(DataInputStream dataInputStream, boolean bl) {
        if (dataInputStream != null) {
            this.stream = dataInputStream;
        }
        this.isBigEndian = bl;
    }

    @Override
    public void setOutputChannel(GenericOutputChannel genericOutputChannel) {
        this.out = genericOutputChannel;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    @Override
    public byte readByte() throws IOException {
        ++this.nBytes;
        return this.ioReadByte();
    }

    @Override
    public int readUInt8() throws IOException {
        ++this.nBytes;
        int n = this.stream.readUnsignedByte();
        if (this.out != null) {
            this.out.writeByteAsInt(n);
        }
        return n;
    }

    private byte ioReadByte() throws IOException {
        byte by = this.stream.readByte();
        if (this.out != null) {
            this.out.writeByteAsInt(by);
        }
        return by;
    }

    @Override
    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readByteArray(byArray, 0, n);
        return byArray;
    }

    @Override
    public int readByteArray(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.ioRead(byArray, n, n2);
        this.nBytes += (long)n3;
        return n3;
    }

    private int ioRead(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.stream.read(byArray, n, n2);
            n3 += n4;
            if (n4 > 0 && this.out != null) {
                this.out.write(byArray, n, n4);
            }
            if (n4 >= n2) break;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    @Override
    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.readByteArray(byArray, 0, n);
        return new String(byArray, 0, n2, "UTF-8");
    }

    @Override
    public short readShort() throws IOException {
        this.nBytes += 2L;
        short s = this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
        return s;
    }

    private short ioReadShort() throws IOException {
        short s = this.stream.readShort();
        if (this.out != null) {
            this.out.writeShort(s);
        }
        return s;
    }

    @Override
    public int readIntLE() throws IOException {
        this.nBytes += 4L;
        return this.readLEInt();
    }

    @Override
    public int readInt() throws IOException {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws IOException {
        int n = this.stream.readInt();
        if (this.out != null) {
            this.out.writeInt(n);
        }
        return n;
    }

    @Override
    public int swapBytesI(int n) {
        return n >> 24 & 0xFF | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    @Override
    public short swapBytesS(short s) {
        return (short)(s >> 8 & 0xFF | (s & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.nBytes += 2L;
        int n = this.ioReadByte() & 0xFF;
        int n2 = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (n << 8) + n2 : (n2 << 8) + n;
    }

    @Override
    public long readLong() throws IOException {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws IOException {
        long l = this.stream.readLong();
        if (this.out != null) {
            this.out.writeLong(l);
        }
        return l;
    }

    private int readLEInt() throws IOException {
        this.ioRead(this.t8, 0, 4);
        return BinaryDocument.bytesToInt(this.t8, 0, false);
    }

    @Override
    public float readFloat() throws Exception {
        return BinaryDocument.intToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private double ioReadDouble() throws IOException {
        double d = this.stream.readDouble();
        if (this.out != null) {
            this.out.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private long readLELong() throws IOException {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    @Override
    public void seek(long l) {
        try {
            if (l == this.nBytes) {
                return;
            }
            if (l < this.nBytes) {
                this.stream.reset();
                if (this.out != null && this.nBytes != 0L) {
                    this.out.reset();
                }
                this.nBytes = 0L;
            } else {
                l -= this.nBytes;
            }
            if (this.out == null) {
                this.stream.skipBytes((int)l);
            } else {
                this.readByteArray(new byte[(int)l], 0, (int)l);
            }
            this.nBytes += l;
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    @Override
    public long getPosition() {
        return this.nBytes;
    }

    @Override
    public SB getAllDataFiles(String string, String string2) {
        return null;
    }

    @Override
    public void getAllDataMapped(String string, String string2, Map<String, String> map) {
    }
}

