/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.DateTime;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openoffice.da.comp.w2lcommon.helper.DialogBase;
import org.openoffice.da.comp.w2lcommon.helper.SimpleDialog;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;

public class EpubMetadataDialog
extends DialogBase {
    private static final String IDENTIFIER = "Identifier";
    private static final String CREATOR = "Creator";
    private static final String CONTRIBUTOR = "Contributor";
    private static final String DATE = "Date";
    private static final String PUBLISHER = "Publisher";
    private static final String TYPE = "Type";
    private static final String FORMAT = "Format";
    private static final String SOURCE = "Source";
    private static final String RELATION = "Relation";
    private static final String COVERAGE = "Coverage";
    private static final String RIGHTS = "Rights";
    private static final String[] sRoles = new String[]{"", "adp", "ann", "arr", "art", "asn", "aut", "aqt", "aft", "aui", "ant", "bkp", "clb", "cmm", "dsr", "edt", "ill", "lyr", "mdc", "mus", "nrt", "oth", "pht", "prt", "red", "rev", "spn", "ths", "trc", "trl"};
    private static HashMap<String, Short> backRoles = new HashMap();
    private XDocumentProperties xDocumentProperties = null;
    private XPropertyContainer xUserProperties = null;
    private XPropertySet xUserPropertySet = null;
    private Vector<AuthorInfo> authors = new Vector();
    private Vector<DateInfo> dates = new Vector();
    private NumberFormat formatter = new DecimalFormat("00");
    Pattern datePattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
    public static String __serviceName;
    public static String __implementationName;

    public EpubMetadataDialog(XComponentContext xContext) {
        super(xContext);
    }

    @Override
    public String getDialogLibraryName() {
        return "W2XDialogs2";
    }

    @Override
    public String getDialogName() {
        return "EpubMetadata";
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("UseCustomIdentifierChange")) {
            return this.useCustomIdentifierChange();
        }
        if (sMethod.equals("AuthorAddClick")) {
            return this.authorAddclick();
        }
        if (sMethod.equals("AuthorModifyClick")) {
            return this.authorModifyclick();
        }
        if (sMethod.equals("AuthorDeleteClick")) {
            return this.authorDeleteclick();
        }
        if (sMethod.equals("AuthorUpClick")) {
            return this.authorUpclick();
        }
        if (sMethod.equals("AuthorDownClick")) {
            return this.authorDownclick();
        }
        if (sMethod.equals("DateAddClick")) {
            return this.dateAddClick();
        }
        if (sMethod.equals("DateModifyClick")) {
            return this.dateModifyClick();
        }
        if (sMethod.equals("DateDeleteClick")) {
            return this.dateDeleteClick();
        }
        if (sMethod.equals("DateUpClick")) {
            return this.dateUpClick();
        }
        if (sMethod.equals("DateDownClick")) {
            return this.dateDownClick();
        }
        return false;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"UseCustomIdentifierChange", "AuthorAddClick", "AuthorModifyClick", "AuthorDeleteClick", "AuthorUpClick", "AuthorDownClick", "DataAddClick", "DateModifyClick", "DateDeleteClick", "DateUpClick", "DateDownClick"};
        return sNames;
    }

    private boolean useCustomIdentifierChange() {
        boolean bEnabled = this.getCheckBoxStateAsBoolean("UseCustomIdentifier");
        this.setControlEnabled("IdentifierLabel", bEnabled);
        this.setControlEnabled(IDENTIFIER, bEnabled);
        this.setControlEnabled("IdentifierTypeLabel", bEnabled);
        this.setControlEnabled("IdentifierType", bEnabled);
        return true;
    }

    private boolean authorAddclick() {
        SimpleDialog dialog = new SimpleDialog(this.xContext, "W2XDialogs2.AuthorDialog");
        if (dialog.getDialog() != null) {
            dialog.getControls().setListBoxSelectedItem(TYPE, (short)0);
            dialog.getControls().setListBoxSelectedItem("Role", (short)0);
            if (dialog.getDialog().execute() == 1) {
                AuthorInfo author = new AuthorInfo();
                author.sName = dialog.getControls().getTextFieldText("Author");
                author.sRole = sRoles[dialog.getControls().getListBoxSelectedItem("Role")];
                author.isCreator = dialog.getControls().getListBoxSelectedItem(TYPE) == 0;
                this.authors.add(author);
                this.updateAuthorList((short)(this.authors.size() - 1));
            }
            dialog.getDialog().endExecute();
        }
        return true;
    }

    private boolean authorModifyclick() {
        short nIndex = this.getListBoxSelectedItem("Authors");
        AuthorInfo author = this.authors.get(nIndex);
        SimpleDialog dialog = new SimpleDialog(this.xContext, "W2XDialogs2.AuthorDialog");
        if (dialog.getDialog() != null) {
            dialog.getControls().setTextFieldText("Author", author.sName);
            dialog.getControls().setListBoxSelectedItem(TYPE, author.isCreator ? (short)0 : 1);
            dialog.getControls().setListBoxSelectedItem("Role", backRoles.containsKey(author.sRole) ? backRoles.get(author.sRole) : (short)0);
            if (dialog.getDialog().execute() == 1) {
                author.sName = dialog.getControls().getTextFieldText("Author");
                author.sRole = sRoles[dialog.getControls().getListBoxSelectedItem("Role")];
                author.isCreator = dialog.getControls().getListBoxSelectedItem(TYPE) == 0;
                this.updateAuthorList(nIndex);
            }
            dialog.getDialog().endExecute();
        }
        return true;
    }

    private boolean authorDeleteclick() {
        SimpleDialog dialog;
        if (this.authors.size() > 0 && (dialog = new SimpleDialog(this.xContext, "W2XDialogs2.DeleteDialog")).getDialog() != null) {
            short nIndex = this.getListBoxSelectedItem("Authors");
            String sLabel = dialog.getControls().getLabelText("DeleteLabel");
            sLabel = sLabel.replaceAll("%s", this.authors.get((int)nIndex).sName);
            dialog.getControls().setLabelText("DeleteLabel", sLabel);
            if (dialog.getDialog().execute() == 1) {
                this.authors.remove(nIndex);
                this.updateAuthorList(nIndex < this.authors.size() ? nIndex : (short)(nIndex - 1));
            }
        }
        return true;
    }

    private boolean authorUpclick() {
        short nIndex = this.getListBoxSelectedItem("Authors");
        if (nIndex > 0) {
            AuthorInfo author = this.authors.get(nIndex);
            this.authors.set(nIndex, this.authors.get(nIndex - 1));
            this.authors.set(nIndex - 1, author);
            this.updateAuthorList((short)(nIndex - 1));
        }
        return true;
    }

    private boolean authorDownclick() {
        short nIndex = this.getListBoxSelectedItem("Authors");
        if (nIndex + 1 < this.authors.size()) {
            AuthorInfo author = this.authors.get(nIndex);
            this.authors.set(nIndex, this.authors.get(nIndex + 1));
            this.authors.set(nIndex + 1, author);
            this.updateAuthorList((short)(nIndex + 1));
        }
        return true;
    }

    private boolean dateAddClick() {
        SimpleDialog dialog = new SimpleDialog(this.xContext, "W2XDialogs2.DateDialog");
        if (dialog.getDialog() != null) {
            dialog.getControls().setDateFieldValue(DATE, this.datetime2int(this.xDocumentProperties.getModificationDate()));
            if (dialog.getDialog().execute() == 1) {
                DateInfo date = new DateInfo();
                date.nDate = dialog.getControls().getDateFieldValue(DATE);
                date.sEvent = dialog.getControls().getTextFieldText("Event").trim();
                this.dates.add(date);
                this.updateDateList((short)(this.dates.size() - 1));
            }
            dialog.getDialog().endExecute();
        }
        return true;
    }

    private boolean dateModifyClick() {
        short nIndex = this.getListBoxSelectedItem("Dates");
        DateInfo date = this.dates.get(nIndex);
        SimpleDialog dialog = new SimpleDialog(this.xContext, "W2XDialogs2.DateDialog");
        if (dialog.getDialog() != null) {
            dialog.getControls().setDateFieldValue(DATE, date.nDate);
            dialog.getControls().setTextFieldText("Event", date.sEvent);
            if (dialog.getDialog().execute() == 1) {
                date.nDate = dialog.getControls().getDateFieldValue(DATE);
                date.sEvent = dialog.getControls().getTextFieldText("Event").trim();
                this.updateDateList(nIndex);
            }
            dialog.getDialog().endExecute();
        }
        return true;
    }

    private boolean dateDeleteClick() {
        SimpleDialog dialog;
        if (this.dates.size() > 0 && (dialog = new SimpleDialog(this.xContext, "W2XDialogs2.DeleteDialog")).getDialog() != null) {
            short nIndex = this.getListBoxSelectedItem("Dates");
            String sLabel = dialog.getControls().getLabelText("DeleteLabel");
            sLabel = sLabel.replaceAll("%s", this.formatDate(this.dates.get((int)nIndex).nDate));
            dialog.getControls().setLabelText("DeleteLabel", sLabel);
            if (dialog.getDialog().execute() == 1) {
                this.dates.remove(nIndex);
                this.updateDateList(nIndex < this.dates.size() ? nIndex : (short)(nIndex - 1));
            }
        }
        return true;
    }

    private boolean dateUpClick() {
        short nIndex = this.getListBoxSelectedItem("Dates");
        if (nIndex > 0) {
            DateInfo date = this.dates.get(nIndex);
            this.dates.set(nIndex, this.dates.get(nIndex - 1));
            this.dates.set(nIndex - 1, date);
            this.updateDateList((short)(nIndex - 1));
        }
        return true;
    }

    private boolean dateDownClick() {
        short nIndex = this.getListBoxSelectedItem("Dates");
        if (nIndex + 1 < this.dates.size()) {
            DateInfo date = this.dates.get(nIndex);
            this.dates.set(nIndex, this.dates.get(nIndex + 1));
            this.dates.set(nIndex + 1, date);
            this.updateDateList((short)(nIndex + 1));
        }
        return true;
    }

    @Override
    protected void initialize() {
        String[] sDates;
        String[] sContributors;
        String[] sCreators;
        Object desktop;
        try {
            desktop = this.xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
        }
        catch (Exception e) {
            return;
        }
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        XComponent xComponent = xDesktop.getCurrentComponent();
        XDocumentPropertiesSupplier xSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xComponent);
        this.xDocumentProperties = xSupplier.getDocumentProperties();
        this.xUserProperties = this.xDocumentProperties.getUserDefinedProperties();
        this.xUserPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xUserProperties);
        String[] sIdentifiers = this.getProperties(IDENTIFIER, false);
        this.setCheckBoxStateAsBoolean("UseCustomIdentifier", sIdentifiers.length > 0);
        this.useCustomIdentifierChange();
        if (sIdentifiers.length > 0) {
            this.setTextFieldText(IDENTIFIER, this.getStringValue(sIdentifiers[0]));
            this.setTextFieldText("IdentifierType", this.getSuffix(sIdentifiers[0]));
        }
        for (String sCreator : sCreators = this.getProperties(CREATOR, false)) {
            AuthorInfo creator = new AuthorInfo();
            creator.sName = this.getStringValue(sCreator);
            creator.sRole = this.getSuffix(sCreator);
            creator.isCreator = true;
            this.authors.add(creator);
        }
        for (String sContributor : sContributors = this.getProperties(CONTRIBUTOR, false)) {
            AuthorInfo contributor = new AuthorInfo();
            contributor.sName = this.getStringValue(sContributor);
            contributor.sRole = this.getSuffix(sContributor);
            contributor.isCreator = false;
            this.authors.add(contributor);
        }
        this.updateAuthorList((short)0);
        for (String sDate : sDates = this.getProperties(DATE, false)) {
            DateInfo date = new DateInfo();
            DateTime dt = this.getDateValue(sDate);
            date.nDate = dt != null ? this.datetime2int(dt) : this.parseDate(this.getStringValue(sDate));
            date.sEvent = this.getSuffix(sDate);
            this.dates.add(date);
        }
        this.updateDateList((short)0);
        this.setTextFieldText("Title", this.xDocumentProperties.getTitle());
        this.setTextFieldText("Subject", this.xDocumentProperties.getSubject());
        String[] sKeywords = this.xDocumentProperties.getKeywords();
        CSVList keywords = new CSVList(", ");
        for (String sKeyword : sKeywords) {
            keywords.addValue(sKeyword);
        }
        this.setTextFieldText("Keywords", keywords.toString());
        this.setTextFieldText("Description", this.xDocumentProperties.getDescription());
        this.readSimpleProperty(PUBLISHER);
        this.readSimpleProperty(TYPE);
        this.readSimpleProperty(FORMAT);
        this.readSimpleProperty(SOURCE);
        this.readSimpleProperty(RELATION);
        this.readSimpleProperty(COVERAGE);
        this.readSimpleProperty(RIGHTS);
    }

    @Override
    protected void endDialog() {
        String[] sDates;
        String[] sContributors;
        String[] sCreators;
        String[] sIdentifiers;
        for (String sIdentifier : sIdentifiers = this.getProperties(IDENTIFIER, false)) {
            this.removeProperty(sIdentifier);
        }
        if (this.getCheckBoxStateAsBoolean("UseCustomIdentifier")) {
            String sName = IDENTIFIER;
            if (this.getTextFieldText("IdentifierType").trim().length() > 0) {
                sName = sName + "." + this.getTextFieldText("IdentifierType").trim();
            }
            this.addProperty(sName);
            this.setValue(sName, this.getTextFieldText(IDENTIFIER));
        }
        for (String sCreator : sCreators = this.getProperties(CREATOR, false)) {
            this.removeProperty(sCreator);
        }
        for (String sContributor : sContributors = this.getProperties(CONTRIBUTOR, false)) {
            this.removeProperty(sContributor);
        }
        int i = 0;
        for (AuthorInfo author : this.authors) {
            String sName = (author.isCreator ? CREATOR : CONTRIBUTOR) + this.formatter.format(++i);
            if (author.sRole.length() > 0) {
                sName = sName + "." + author.sRole;
            }
            this.addProperty(sName);
            this.setValue(sName, author.sName);
        }
        for (String sDate : sDates = this.getProperties(DATE, false)) {
            this.removeProperty(sDate);
        }
        i = 0;
        for (DateInfo date : this.dates) {
            String sName = DATE + this.formatter.format(++i);
            if (date.sEvent.length() > 0) {
                sName = sName + "." + date.sEvent;
            }
            this.addProperty(sName);
            this.setValue(sName, this.formatDate(date.nDate));
        }
        this.xDocumentProperties.setTitle(this.getTextFieldText("Title"));
        this.xDocumentProperties.setSubject(this.getTextFieldText("Subject"));
        String[] sKeywords = this.getTextFieldText("Keywords").split(",");
        for (int j = 0; j < sKeywords.length; ++j) {
            sKeywords[j] = sKeywords[j].trim();
        }
        this.xDocumentProperties.setKeywords(sKeywords);
        this.xDocumentProperties.setDescription(this.getTextFieldText("Description"));
        this.writeSimpleProperty(PUBLISHER);
        this.writeSimpleProperty(TYPE);
        this.writeSimpleProperty(FORMAT);
        this.writeSimpleProperty(SOURCE);
        this.writeSimpleProperty(RELATION);
        this.writeSimpleProperty(COVERAGE);
        this.writeSimpleProperty(RIGHTS);
    }

    private String getSuffix(String sPropertyName) {
        int nDot = sPropertyName.indexOf(".");
        return nDot > -1 ? sPropertyName.substring(nDot + 1) : "";
    }

    private String[] getProperties(String sPrefix, boolean bComplete) {
        Property[] xProps;
        HashSet<String> names = new HashSet<String>();
        for (Property prop : xProps = this.xUserPropertySet.getPropertySetInfo().getProperties()) {
            String sName = prop.Name;
            String sLCName = sName.toLowerCase();
            String sLCPrefix = sPrefix.toLowerCase();
            if ((!bComplete || !sLCName.equals(sLCPrefix)) && (bComplete || !sLCName.startsWith(sLCPrefix))) continue;
            names.add(sName);
        }
        return Misc.sortStringSet(names);
    }

    private void addProperty(String sName) {
        try {
            this.xUserProperties.addProperty(sName, (short)128, (Object)"");
        }
        catch (PropertyExistException e) {
        }
        catch (IllegalTypeException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void removeProperty(String sName) {
        try {
            this.xUserProperties.removeProperty(sName);
        }
        catch (UnknownPropertyException e) {
        }
        catch (NotRemoveableException notRemoveableException) {
            // empty catch block
        }
    }

    private void setValue(String sName, Object value) {
        try {
            this.xUserPropertySet.setPropertyValue(sName, value);
        }
        catch (UnknownPropertyException e) {
        }
        catch (PropertyVetoException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (WrappedTargetException wrappedTargetException) {
            // empty catch block
        }
    }

    private String getStringValue(String sName) {
        Object value = this.getValue(sName);
        if (value != null && AnyConverter.isString((Object)value)) {
            try {
                return AnyConverter.toString((Object)value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private DateTime getDateValue(String sName) {
        Object value = this.getValue(sName);
        if (value != null && value instanceof DateTime) {
            return (DateTime)value;
        }
        return null;
    }

    private Object getValue(String sName) {
        try {
            return this.xUserPropertySet.getPropertyValue(sName);
        }
        catch (UnknownPropertyException e) {
            return null;
        }
        catch (WrappedTargetException e) {
            return null;
        }
    }

    private void updateAuthorList(short nItem) {
        int nCount = this.authors.size();
        if (nCount > 0) {
            String[] sAuthors = new String[nCount];
            for (int i = 0; i < nCount; ++i) {
                AuthorInfo author = this.authors.get(i);
                sAuthors[i] = author.sName + " (" + (author.isCreator ? "creator" : "contributor") + (author.sRole.length() > 0 ? ", " + author.sRole : "") + ")";
            }
            this.setListBoxStringItemList("Authors", sAuthors);
            this.setListBoxSelectedItem("Authors", nItem);
            this.setControlEnabled("Authors", true);
        } else {
            String[] sAuthors = new String[]{this.xDocumentProperties.getModifiedBy() + " (default creator)"};
            this.setListBoxStringItemList("Authors", sAuthors);
            this.setControlEnabled("Authors", false);
        }
        this.setControlEnabled("ModifyAuthorButton", nCount > 0);
        this.setControlEnabled("DeleteAuthorButton", nCount > 0);
        this.setControlEnabled("AuthorUpButton", nCount > 1);
        this.setControlEnabled("AuthorDownButton", nCount > 1);
    }

    private void updateDateList(short nItem) {
        int nCount = this.dates.size();
        if (nCount > 0) {
            String[] sDates = new String[nCount];
            for (int i = 0; i < nCount; ++i) {
                DateInfo date = this.dates.get(i);
                sDates[i] = this.formatDate(date.nDate);
                if (date.sEvent.length() <= 0) continue;
                int n = i;
                sDates[n] = sDates[n] + " (" + date.sEvent + ")";
            }
            this.setListBoxStringItemList("Dates", sDates);
            this.setListBoxSelectedItem("Dates", nItem);
            this.setControlEnabled("Dates", true);
        } else {
            String[] sDates = new String[]{this.formatDate(this.datetime2int(this.xDocumentProperties.getModificationDate())) + " (default date)"};
            this.setListBoxStringItemList("Dates", sDates);
            this.setControlEnabled("Dates", false);
        }
        this.setControlEnabled("ModifyDateButton", nCount > 0);
        this.setControlEnabled("DeleteDateButton", nCount > 0);
        this.setControlEnabled("DateUpButton", nCount > 1);
        this.setControlEnabled("DateDownButton", nCount > 1);
    }

    private void readSimpleProperty(String sName) {
        String sValue;
        String[] sNames = this.getProperties(sName, true);
        if (sNames.length > 0 && (sValue = this.getStringValue(sNames[0])) != null) {
            this.setTextFieldText(sName, sValue);
        }
    }

    private void writeSimpleProperty(String sName) {
        String[] sOldNames;
        for (String sOldName : sOldNames = this.getProperties(sName, true)) {
            this.removeProperty(sOldName);
        }
        String sValue = this.getTextFieldText(sName);
        if (sValue.length() > 0) {
            this.addProperty(sName);
            this.setValue(sName, sValue);
        }
    }

    private String formatDate(int nDate) {
        String sDate = Integer.toString(nDate);
        if (sDate.length() == 8) {
            return sDate.substring(0, 4) + "-" + sDate.substring(4, 6) + "-" + sDate.substring(6);
        }
        return "???";
    }

    private int parseDate(String sDate) {
        Matcher matcher = this.datePattern.matcher(sDate);
        if (matcher.matches()) {
            return Misc.getPosInteger(matcher.group(1) + matcher.group(2) + matcher.group(3), 0);
        }
        return 0;
    }

    private int datetime2int(DateTime date) {
        return 10000 * date.Year + 100 * date.Month + date.Day;
    }

    static {
        short nCount = sRoles.length;
        for (short i = 0; i < nCount; i = (short)(i + 1)) {
            backRoles.put(sRoles[i], i);
        }
        __serviceName = "org.openoffice.da.writer2xhtml.EpubMetadataDialog";
        __implementationName = "org.openoffice.da.comp.writer2xhtml.EpubMetadataDialog";
    }

    private class DateInfo {
        int nDate = 0;
        String sEvent = "";

        private DateInfo() {
        }
    }

    private class AuthorInfo {
        String sName = "";
        boolean isCreator = true;
        String sRole = "";

        private AuthorInfo() {
        }
    }
}

