<?php

/*
	Phoronix Test Suite
	URLs: http://www.phoronix.com, http://www.phoronix-test-suite.com/
	Copyright (C) 2008 - 2017, Phoronix Media
	Copyright (C) 2008 - 2017, Michael Larabel

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class show_result implements pts_option_interface
{
	const doc_section = 'Result Management';
	const doc_description = 'Open up the test results in the Phoronix Test Suite Result Viewer or on OpenBenchmarking.org.';

	public static function argument_checks()
	{
		return array(
		new pts_argument_check(0, array('pts_types', 'is_result_file'), null)
		);
	}
	public static function invalid_command($passed_args = null)
	{
		pts_tests::recently_saved_results();
	}
	public static function run($r)
	{
		$URL = PTS_SAVE_RESULTS_PATH . $r[0];

		if(!is_dir($URL . '/result-graphs/'))
		{
			pts_client::generate_result_file_graphs($r[0], PTS_SAVE_RESULTS_PATH . $r[0] . '/');
		}

		if(pts_client::read_env('DISPLAY') == false)
		{
			$rf = new pts_result_file($r[0]);
			echo pts_result_file_output::result_file_to_text($rf, pts_client::terminal_width());
		}
		else
		{
			pts_client::display_web_page($URL . '/index.html', null, false, true);
		}
	}
}

?>
