/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificIntegerValue;

final class ParticularIntegerValue
extends SpecificIntegerValue {
    private final int value;

    public ParticularIntegerValue(int n) {
        this.value = n;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public IntegerValue negate() {
        return new ParticularIntegerValue(-this.value);
    }

    @Override
    public IntegerValue convertToByte() {
        byte by = (byte)this.value;
        return by == this.value ? this : new ParticularIntegerValue(by);
    }

    @Override
    public IntegerValue convertToCharacter() {
        char c = (char)this.value;
        return c == this.value ? this : new ParticularIntegerValue(c);
    }

    @Override
    public IntegerValue convertToShort() {
        short s = (short)this.value;
        return s == this.value ? this : new ParticularIntegerValue(s);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue(this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public IntegerValue generalize(IntegerValue integerValue) {
        return integerValue.generalize(this);
    }

    @Override
    public IntegerValue add(IntegerValue integerValue) {
        return integerValue.add(this);
    }

    @Override
    public IntegerValue subtract(IntegerValue integerValue) {
        return integerValue.subtractFrom(this);
    }

    @Override
    public IntegerValue subtractFrom(IntegerValue integerValue) {
        return integerValue.subtract(this);
    }

    @Override
    public IntegerValue multiply(IntegerValue integerValue) {
        return integerValue.multiply(this);
    }

    @Override
    public IntegerValue divide(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divideOf(this);
    }

    @Override
    public IntegerValue divideOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divide(this);
    }

    @Override
    public IntegerValue remainder(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainderOf(this);
    }

    @Override
    public IntegerValue remainderOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainder(this);
    }

    @Override
    public IntegerValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    @Override
    public IntegerValue shiftLeftOf(IntegerValue integerValue) {
        return integerValue.shiftLeft(this);
    }

    @Override
    public IntegerValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    @Override
    public IntegerValue shiftRightOf(IntegerValue integerValue) {
        return integerValue.shiftRight(this);
    }

    @Override
    public IntegerValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(IntegerValue integerValue) {
        return integerValue.unsignedShiftRight(this);
    }

    @Override
    public LongValue shiftLeftOf(LongValue longValue) {
        return longValue.shiftLeft(this);
    }

    @Override
    public LongValue shiftRightOf(LongValue longValue) {
        return longValue.shiftRight(this);
    }

    @Override
    public LongValue unsignedShiftRightOf(LongValue longValue) {
        return longValue.unsignedShiftRight(this);
    }

    @Override
    public IntegerValue and(IntegerValue integerValue) {
        return integerValue.and(this);
    }

    @Override
    public IntegerValue or(IntegerValue integerValue) {
        return integerValue.or(this);
    }

    @Override
    public IntegerValue xor(IntegerValue integerValue) {
        return integerValue.xor(this);
    }

    @Override
    public int equal(IntegerValue integerValue) {
        return integerValue.equal(this);
    }

    @Override
    public int lessThan(IntegerValue integerValue) {
        return integerValue.greaterThan(this);
    }

    @Override
    public int lessThanOrEqual(IntegerValue integerValue) {
        return integerValue.greaterThanOrEqual(this);
    }

    @Override
    public IntegerValue generalize(ParticularIntegerValue particularIntegerValue) {
        return this.generalize((SpecificIntegerValue)particularIntegerValue);
    }

    @Override
    public IntegerValue add(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value + particularIntegerValue.value);
    }

    @Override
    public IntegerValue subtract(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value - particularIntegerValue.value);
    }

    @Override
    public IntegerValue subtractFrom(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value - this.value);
    }

    @Override
    public IntegerValue multiply(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value * particularIntegerValue.value);
    }

    @Override
    public IntegerValue divide(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(this.value / particularIntegerValue.value);
    }

    @Override
    public IntegerValue divideOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(particularIntegerValue.value / this.value);
    }

    @Override
    public IntegerValue remainder(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(this.value % particularIntegerValue.value);
    }

    @Override
    public IntegerValue remainderOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(particularIntegerValue.value % this.value);
    }

    @Override
    public IntegerValue shiftLeft(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value << particularIntegerValue.value);
    }

    @Override
    public IntegerValue shiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value >> particularIntegerValue.value);
    }

    @Override
    public IntegerValue unsignedShiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value >>> particularIntegerValue.value);
    }

    @Override
    public IntegerValue shiftLeftOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value << this.value);
    }

    @Override
    public IntegerValue shiftRightOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value >> this.value);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value >>> this.value);
    }

    @Override
    public LongValue shiftLeftOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() << this.value);
    }

    @Override
    public LongValue shiftRightOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() >> this.value);
    }

    @Override
    public LongValue unsignedShiftRightOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() >>> this.value);
    }

    @Override
    public IntegerValue and(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value & particularIntegerValue.value);
    }

    @Override
    public IntegerValue or(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value | particularIntegerValue.value);
    }

    @Override
    public IntegerValue xor(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value ^ particularIntegerValue.value);
    }

    @Override
    public int equal(ParticularIntegerValue particularIntegerValue) {
        return this.value == particularIntegerValue.value ? 1 : -1;
    }

    @Override
    public int lessThan(ParticularIntegerValue particularIntegerValue) {
        return this.value < particularIntegerValue.value ? 1 : -1;
    }

    @Override
    public int lessThanOrEqual(ParticularIntegerValue particularIntegerValue) {
        return this.value <= particularIntegerValue.value ? 1 : -1;
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularIntegerValue)object).value;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

