/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.Exception;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class SocketDescriptor
implements FileDescriptor {
    protected SocketChannel channel;
    protected Selector writeSelector;
    protected Selector readSelector;

    public SocketDescriptor() throws Exception {
        SocketDescriptor.DefaultSelectorProvider();
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException closedChannelException) {
            throw new Exception(closedChannelException.getMessage());
        }
    }

    public void shutdown() throws IOException {
        try {
            this.channel.socket().shutdownInput();
            this.channel.socket().shutdownOutput();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    private static SelectorProvider DefaultSelectorProvider() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac OS X")) {
            System.setProperty("java.nio.channels.spi.SelectorProvider", "sun.nio.ch.PollSelectorProvider");
        }
        return SelectorProvider.provider();
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            n3 = this.channel.read(byteBuffer);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        if (n3 <= 0) {
            return n3 == 0 ? -1 : 0;
        }
        byteBuffer.flip();
        byteBuffer.get(byArray, n, n3);
        byteBuffer.clear();
        return n3;
    }

    @Override
    public synchronized int write(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(byArray, n, n2);
        byteBuffer.flip();
        try {
            n3 = this.channel.write(byteBuffer);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        byteBuffer.clear();
        return n3;
    }

    @Override
    public synchronized int select(int n, Integer n2) throws Exception {
        int n3;
        Selector selector = (n & 1) != 0 ? this.readSelector : this.writeSelector;
        selector.selectedKeys().clear();
        try {
            if (n2 == null) {
                n3 = selector.select();
            } else {
                int n4 = n2;
                switch (n4) {
                    case 0: {
                        n3 = selector.selectNow();
                        break;
                    }
                    default: {
                        n3 = selector.select(n4);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return n3;
    }

    public int write(ByteBuffer byteBuffer) throws Exception {
        int n = 0;
        try {
            n = this.channel.write(byteBuffer);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return n;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        try {
            l = this.channel.write(byteBufferArray, n, n2);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return l;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        try {
            n = this.channel.read(byteBuffer);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return n;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        try {
            l = this.channel.read(byteBufferArray, n, n2);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return l;
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public SocketAddress getRemoteAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getRemoteSocketAddress();
        }
        return null;
    }

    public SocketAddress getLocalAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getLocalSocketAddress();
        }
        return null;
    }

    public boolean isConnectionPending() {
        return this.channel.isConnectionPending();
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.channel.connect(socketAddress);
    }

    public boolean finishConnect() throws IOException {
        return this.channel.finishConnect();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.channel.configureBlocking(bl);
    }

    protected synchronized void implCloseSelectableChannel() throws IOException {
        this.channel.close();
        this.notifyAll();
    }

    protected void setChannel(SocketChannel socketChannel) {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.readSelector != null) {
                this.readSelector.close();
            }
            if (this.writeSelector != null) {
                this.writeSelector.close();
            }
            this.channel = socketChannel;
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException closedChannelException) {
            System.out.println(closedChannelException.toString());
        }
    }
}

