/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.Message;
import com.baselet.element.facet.specific.sequence_aio.OccurrenceSpecification;
import com.baselet.element.relation.helper.RelationDrawer;
import java.util.Map;

public class GateMessage
extends Message {
    private final boolean sendGate;
    private final boolean dockToLeftBorder;

    private GateMessage(Lifeline from, Lifeline to, int sendTick, String text, Message.ArrowType arrowType, LineType lineType, boolean sendGate, boolean dockToLeftBorder) {
        super(from, to, 0, sendTick, text, arrowType, lineType);
        this.sendGate = sendGate;
        this.dockToLeftBorder = dockToLeftBorder;
    }

    public static GateMessage createSendGateMessage(Lifeline receiver, int sendTick, String text, Message.ArrowType arrowType, LineType lineType, Lifeline leftMostLifeline, Lifeline rightMostLifeline) {
        if (Math.abs(receiver.getIndex() - leftMostLifeline.getIndex()) <= Math.abs(receiver.getIndex() - rightMostLifeline.getIndex())) {
            return new GateMessage(leftMostLifeline, receiver, sendTick, text, arrowType, lineType, true, true);
        }
        return new GateMessage(rightMostLifeline, receiver, sendTick, text, arrowType, lineType, true, false);
    }

    public static GateMessage createReceiveGateMessage(Lifeline sender, int sendTick, String text, Message.ArrowType arrowType, LineType lineType, Lifeline leftMostLifeline, Lifeline rightMostLifeline) {
        if (Math.abs(sender.getIndex() - leftMostLifeline.getIndex()) < Math.abs(sender.getIndex() - rightMostLifeline.getIndex())) {
            return new GateMessage(sender, leftMostLifeline, sendTick, text, arrowType, lineType, false, true);
        }
        return new GateMessage(sender, rightMostLifeline, sendTick, text, arrowType, lineType, false, false);
    }

    @Override
    protected double getSendX(HorizontalDrawingInfo hDrawingInfo) {
        if (this.sendGate) {
            if (this.dockToLeftBorder) {
                return hDrawingInfo.getDiagramHorizontalStart();
            }
            return hDrawingInfo.getDiagramHorizontalEnd();
        }
        return super.getSendX(hDrawingInfo);
    }

    @Override
    protected double getReceiveX(HorizontalDrawingInfo hDrawingInfo) {
        if (this.sendGate) {
            return super.getReceiveX(hDrawingInfo);
        }
        if (this.dockToLeftBorder) {
            return hDrawingInfo.getDiagramHorizontalStart();
        }
        return hDrawingInfo.getDiagramHorizontalEnd();
    }

    @Override
    protected void drawSelfMessage(DrawHandler drawHandler, PointDouble send, PointDouble receive, RelationDrawer.ArrowEndType arrowEndType, boolean fillArrow, DrawingInfo hInfo) {
        super.drawNormalMessage(drawHandler, send, receive, arrowEndType, fillArrow, hInfo);
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        double executionSpecWidth = !this.sendGate ? Math.abs(this.getSendCenterXOffset()) : Math.abs(this.getReceiveCenterXOffset());
        double neededWidth = executionSpecWidth + TextSplitter.getTextMinWidth(this.textLines, drawHandler) + 32.0;
        if (this.from == this.to) {
            return neededWidth * 2.0;
        }
        int affectedLifelineCount = this.getLastLifeline().getIndex() - this.getFirstLifeline().getIndex();
        double padding = lifelineHorizontalPadding * (double)affectedLifelineCount;
        return (neededWidth - padding) * (double)(affectedLifelineCount + 1) / ((double)affectedLifelineCount + 0.5);
    }

    @Override
    protected void getEveryAdditionalYHeightSelfMessage(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight, Map<Integer, Double> ret) {
        super.getEveryAdditionalYHeightNormalMessage(drawHandler, hInfo, defaultTickHeight, ret);
    }

    @Override
    public OccurrenceSpecification sendOccurrenceSpecification() {
        if (this.sendGate) {
            throw new IllegalStateException("This GateMessage was created with an sender gate, and a gate has no associated occurrence specification.");
        }
        return super.sendOccurrenceSpecification();
    }

    @Override
    public OccurrenceSpecification receiveOccurrenceSpecification() {
        if (!this.sendGate) {
            throw new IllegalStateException("This GateMessage was created with an receiver gate, and a gate has no associated occurrence specification.");
        }
        return super.receiveOccurrenceSpecification();
    }
}

