/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.facet.specific.sequence_aio.PentagonDrawingHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InteractionUse
implements LifelineSpanningTickSpanningOccurrence {
    private static final double TEXT_X_PADDING = 5.0;
    private static final double TEXT_Y_PADDING = 5.0;
    private static final double HEADER_BOTTOM_PADDING = 4.0;
    private static final String[] HEADER_TEXT = new String[]{"ref"};
    private final int tick;
    private final String[] textLines;
    private final Lifeline[] coveredLifelines;

    public InteractionUse(int tick, String text, Lifeline[] coveredLifelines) {
        this.tick = tick;
        this.textLines = text.split("\n");
        this.coveredLifelines = Arrays.copyOf(coveredLifelines, coveredLifelines.length);
    }

    @Override
    public Lifeline getFirstLifeline() {
        return this.coveredLifelines[0];
    }

    @Override
    public Lifeline getLastLifeline() {
        return this.coveredLifelines[this.coveredLifelines.length - 1];
    }

    @Override
    public void draw(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        double width = drawingInfo.getSymmetricWidth(this.getFirstLifeline(), this.getLastLifeline(), this.tick);
        double height = this.getHeight(drawHandler, width);
        double topY = drawingInfo.getVerticalStart(this.tick) + (drawingInfo.getTickHeight(this.tick) - height) / 2.0;
        PointDouble topLeft = new PointDouble(drawingInfo.getHDrawingInfo(this.getFirstLifeline()).getSymmetricHorizontalStart(this.tick), topY);
        drawHandler.drawRectangle(topLeft.x, topLeft.y, width, height);
        PointDouble pentagonSize = PentagonDrawingHelper.draw(drawHandler, HEADER_TEXT, width, topLeft);
        TextSplitter.drawText(drawHandler, this.textLines, topLeft.x + pentagonSize.x + 5.0, topLeft.y, width - (pentagonSize.x + 5.0) * 2.0, height, AlignHorizontal.CENTER, AlignVertical.CENTER);
        Lifeline[] lifelineArray = this.coveredLifelines;
        int n = this.coveredLifelines.length;
        int n2 = 0;
        while (n2 < n) {
            Lifeline ll = lifelineArray[n2];
            drawingInfo.getDrawingInfo(ll).addInterruptedArea(new Line1D(topLeft.y, topLeft.y + height));
            ++n2;
        }
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        return PentagonDrawingHelper.getPentagonMinimumWidth(drawHandler, HEADER_TEXT) * 2.0 + 10.0 + TextSplitter.getTextMinWidth(this.textLines, drawHandler);
    }

    @Override
    public Map<Integer, Double> getEveryAdditionalYHeight(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight) {
        HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        double width = hInfo.getSymmetricWidth(this.getFirstLifeline(), this.getLastLifeline(), this.tick);
        if (this.getHeight(drawHandler, width) > defaultTickHeight) {
            ret.put(this.tick, this.getHeight(drawHandler, width) - defaultTickHeight);
        }
        return ret;
    }

    @Override
    public LifelineSpanningTickSpanningOccurrence.ContainerPadding getPaddingInformation() {
        return null;
    }

    private double getHeight(DrawHandler drawHandler, double width) {
        double textWidth = width - 10.0 - PentagonDrawingHelper.getPentagonMinimumWidth(drawHandler, HEADER_TEXT) * 2.0;
        return Math.max(PentagonDrawingHelper.getHeight(drawHandler, HEADER_TEXT, width) + 4.0, TextSplitter.getSplitStringHeight(this.textLines, textWidth, drawHandler) + 10.0);
    }
}

