/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.menu;

import com.baselet.control.config.ConfigClassGen;
import com.baselet.control.enums.generator.FieldOptions;
import com.baselet.control.enums.generator.MethodOptions;
import com.baselet.control.enums.generator.SignatureOptions;
import com.baselet.control.enums.generator.SortOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GenerateOptionPanel
extends JDialog {
    private static GenerateOptionPanel optionpanel;
    private JCheckBox packageInfo;
    private ButtonGroup fields;
    private ButtonGroup methods;
    private ButtonGroup signatures;
    private ButtonGroup sortings;
    private static final String okButton = "Ok";
    private static final String cancelButton = "Cancel";

    private GenerateOptionPanel() {
        Container content = this.getContentPane();
        content.add((Component)this.createOptionPanel(), "Center");
        content.add((Component)this.createButtonPanel(), "South");
        this.setTitle("Import Details");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getWidth() / 2);
    }

    private JPanel createOptionPanel() {
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.packageInfo = new JCheckBox("Show package");
        this.packageInfo.setSelected(true);
        optionPanel.add((Component)this.packageInfo, this.layout(c, 0, 0));
        this.fields = this.createButtonGroup(FieldOptions.values());
        optionPanel.add((Component)this.createSubPanel("Show fields", this.fields), this.layout(c, 0, 1));
        this.methods = this.createButtonGroup(MethodOptions.values());
        optionPanel.add((Component)this.createSubPanel("Show methods", this.methods), this.layout(c, 1, 1));
        this.signatures = this.createButtonGroup(SignatureOptions.values());
        optionPanel.add((Component)this.createSubPanel("Show signatures", this.signatures), this.layout(c, 0, 2));
        this.sortings = this.createButtonGroup(SortOptions.values());
        optionPanel.add((Component)this.createSubPanel("Sorting", this.sortings), this.layout(c, 1, 2));
        optionPanel.validate();
        return optionPanel;
    }

    private <E extends Enum<E>> ButtonGroup createButtonGroup(E[] values) {
        ButtonGroup group = new ButtonGroup();
        for (E value : values) {
            JRadioButton button = new JRadioButton(((Enum)value).toString());
            button.setActionCommand(((Enum)value).toString());
            group.add(button);
        }
        return group;
    }

    private GridBagConstraints layout(GridBagConstraints c, int gridx, int gridy) {
        c.fill = 2;
        c.gridx = gridx;
        c.gridy = gridy;
        return c;
    }

    private JPanel createSubPanel(String title, ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createTitledBorder(title));
        while (e.hasMoreElements()) {
            panel.add(e.nextElement());
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        CancelOkListener listener = new CancelOkListener();
        JButton button_ok = new JButton(okButton);
        button_ok.setActionCommand(okButton);
        button_ok.addActionListener(listener);
        JButton button_cancel = new JButton(cancelButton);
        button_cancel.setActionCommand(cancelButton);
        button_cancel.addActionListener(listener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(button_cancel);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPanel.add(button_ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setAlignmentX(0.0f);
        return buttonPanel;
    }

    public static GenerateOptionPanel getInstance() {
        if (optionpanel == null) {
            optionpanel = new GenerateOptionPanel();
        }
        return optionpanel;
    }

    public void showPanel() {
        ConfigClassGen genCfg = ConfigClassGen.getInstance();
        this.packageInfo.setSelected(genCfg.isGenerateClassPackage());
        this.setSelectedRadioButton(this.fields, genCfg.getGenerateClassFields());
        this.setSelectedRadioButton(this.methods, genCfg.getGenerateClassMethods());
        this.setSelectedRadioButton(this.signatures, genCfg.getGenerateClassSignatures());
        this.setSelectedRadioButton(this.sortings, genCfg.getGenerateClassSortings());
        this.setVisible(true);
        this.toFront();
    }

    private <E extends Enum<E>> void setSelectedRadioButton(ButtonGroup group, E value) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.getActionCommand().equals(value.toString())) continue;
            button.setSelected(true);
        }
    }

    private class CancelOkListener
    implements ActionListener {
        private CancelOkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            optionpanel.setVisible(false);
            if (e.getActionCommand().equals(GenerateOptionPanel.okButton)) {
                ConfigClassGen genCfg = ConfigClassGen.getInstance();
                genCfg.setGenerateClassPackage(GenerateOptionPanel.this.packageInfo.isSelected());
                genCfg.setGenerateClassFields(FieldOptions.getEnum(GenerateOptionPanel.this.fields.getSelection().getActionCommand().toString()));
                genCfg.setGenerateClassMethods(MethodOptions.getEnum(GenerateOptionPanel.this.methods.getSelection().getActionCommand().toString()));
                genCfg.setGenerateClassSignatures(SignatureOptions.getEnum(GenerateOptionPanel.this.signatures.getSelection().getActionCommand().toString()));
                genCfg.setGenerateClassSortings(SortOptions.getEnum(GenerateOptionPanel.this.sortings.getSelection().getActionCommand().toString()));
            }
        }
    }
}

