/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharGB18030DB;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.GB18030;

public class ByteToCharGB18030
extends ByteToCharGB18030DB {
    private static final int GB18030_SINGLE_BYTE = 1;
    private static final int GB18030_DOUBLE_BYTE = 2;
    private static final int GB18030_FOUR_BYTE = 3;
    private static short[] decoderIndex1;
    private static String[] decoderIndex2;
    private int currentState;
    private int savedSize;
    private byte[] savedBytes;

    public ByteToCharGB18030() {
        GB18030 nioCoder = new GB18030();
        this.savedBytes = new byte[3];
        this.currentState = 2;
        decoderIndex1 = nioCoder.getDecoderIndex1();
        decoderIndex2 = nioCoder.getDecoderIndex2();
        this.savedSize = 0;
    }

    public short[] getOuter() {
        return this.index1;
    }

    public String[] getInner() {
        return this.index2;
    }

    public short[] getDBIndex1() {
        return this.index1;
    }

    public String[] getDBIndex2() {
        return this.index2;
    }

    @Override
    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedSize != 0) {
            this.savedSize = 0;
            this.currentState = 2;
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int inputSize = 0;
        int outputChar = 65533;
        int readOff = this.byteOff = inOff;
        if (this.savedSize != 0) {
            if ((this.savedBytes[0] & 0xFF) < 129 || this.savedBytes[0] > 254 || this.savedSize > 1 && (this.savedBytes[1] & 0xFF) < 48 || this.savedSize > 2 && ((this.savedBytes[2] & 0xFF) < 129 || (this.savedBytes[2] & 0xFF) > 254)) {
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
            byte[] newBuf = new byte[inEnd - inOff + this.savedSize];
            for (int i = 0; i < this.savedSize; ++i) {
                newBuf[i] = this.savedBytes[i];
            }
            System.arraycopy(input, inOff, newBuf, this.savedSize, inEnd - inOff);
            this.byteOff -= this.savedSize;
            input = newBuf;
            inOff = 0;
            inEnd = newBuf.length;
            this.savedSize = 0;
        }
        this.charOff = outOff;
        readOff = inOff;
        while (readOff < inEnd) {
            int byte1 = 0;
            int byte2 = 0;
            int byte3 = 0;
            int byte4 = 0;
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            byte1 = input[readOff++] & 0xFF;
            inputSize = 1;
            if ((byte1 & 0xFFFFFF80) == 0) {
                outputChar = (char)byte1;
                this.currentState = 1;
            } else if (byte1 < 129 || byte1 > 254) {
                if (!this.subMode) {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
                outputChar = this.subChars[0];
            } else {
                if (readOff + inputSize > inEnd) {
                    this.savedBytes[0] = (byte)byte1;
                    this.savedSize = 1;
                    break;
                }
                byte2 = input[readOff++] & 0xFF;
                inputSize = 2;
                if (byte2 < 48) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (byte2 >= 48 && byte2 <= 57) {
                    this.currentState = 3;
                    inputSize = 4;
                    if (readOff + 2 > inEnd) {
                        if (readOff + 1 > inEnd) {
                            this.savedBytes[0] = (byte)byte1;
                            this.savedBytes[1] = (byte)byte2;
                            this.savedSize = 2;
                            break;
                        }
                        this.savedBytes[0] = (byte)byte1;
                        this.savedBytes[1] = (byte)byte2;
                        this.savedBytes[2] = input[readOff++];
                        this.savedSize = 3;
                        break;
                    }
                    if ((byte3 = input[readOff++] & 0xFF) < 129 || byte3 > 254) {
                        this.badInputLength = 3;
                        throw new MalformedInputException();
                    }
                    if ((byte4 = input[readOff++] & 0xFF) < 48 || byte4 > 57) {
                        this.badInputLength = 4;
                        throw new MalformedInputException();
                    }
                } else {
                    if (byte2 == 127 || byte2 == 255 || byte2 < 64) {
                        this.badInputLength = 2;
                        throw new MalformedInputException();
                    }
                    this.currentState = 2;
                }
            }
            switch (this.currentState) {
                case 1: {
                    output[this.charOff++] = (char)byte1;
                    break;
                }
                case 2: {
                    output[this.charOff++] = super.getUnicode(byte1, byte2);
                    break;
                }
                case 3: {
                    int offset = (((byte1 - 129) * 10 + (byte2 - 48)) * 126 + byte3 - 129) * 10 + byte4 - 48;
                    int hiByte = offset >> 8 & 0xFF;
                    int lowByte = offset & 0xFF;
                    if (offset <= 19042) {
                        output[this.charOff++] = this.getChar(offset);
                        break;
                    }
                    if (offset > 19042 && offset <= 33468) {
                        output[this.charOff++] = (char)(offset + 21827);
                        break;
                    }
                    if (offset >= 33469 && offset <= 33549) {
                        output[this.charOff++] = this.getChar(offset);
                        break;
                    }
                    if (offset >= 33549 && offset <= 37800) {
                        output[this.charOff++] = (char)(offset + 25943);
                        break;
                    }
                    if (offset >= 37801 && offset <= 39419) {
                        output[this.charOff++] = this.getChar(offset);
                        break;
                    }
                    if (offset >= 189000 && offset < 1237576) {
                        if (offset >= 1237576) {
                            if (this.subMode) {
                                return this.subChars[0];
                            }
                            this.badInputLength = 4;
                            throw new UnknownCharacterException();
                        }
                        if (this.charOff + 2 > outEnd) {
                            throw new ConversionBufferFullException();
                        }
                        char highSurr = (char)(((offset -= 123464) - 65536) / 1024 + 55296);
                        char lowSurr = (char)((offset - 65536) % 1024 + 56320);
                        output[this.charOff++] = highSurr;
                        output[this.charOff++] = lowSurr;
                        break;
                    }
                    this.badInputLength = 4;
                    throw new MalformedInputException();
                }
            }
            this.byteOff += inputSize;
        }
        this.byteOff += this.savedSize;
        return this.charOff - outOff;
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.currentState = 2;
        this.savedSize = 0;
    }

    @Override
    public String getCharacterEncoding() {
        return "GB18030";
    }

    private char getChar(int offset) throws UnknownCharacterException {
        int byte1 = offset >> 8 & 0xFF;
        int byte2 = offset & 0xFF;
        int start = 0;
        int end = 255;
        if (byte1 < 0 || byte1 > this.getOuter().length || byte2 < start || byte2 > end) {
            if (this.subMode) {
                return this.subChars[0];
            }
            this.badInputLength = 1;
            throw new UnknownCharacterException();
        }
        int n = (decoderIndex1[byte1] & 0xF) * (end - start + 1) + (byte2 - start);
        return decoderIndex2[decoderIndex1[byte1] >> 4].charAt(n);
    }
}

