/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.GCTR;
import com.sun.crypto.provider.GHASH;
import com.sun.crypto.provider.SymmetricCipher;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

final class GaloisCounterMode
extends FeedbackCipher {
    static int DEFAULT_TAG_LEN = 16;
    static int DEFAULT_IV_LEN = 12;
    private static final int MAX_BUF_SIZE = Integer.MAX_VALUE;
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private int sizeOfAAD = 0;
    private ByteArrayOutputStream ibuffer = null;
    private int tagLenBytes = DEFAULT_TAG_LEN;
    private byte[] subkeyH = null;
    private byte[] preCounterBlock = null;
    private GCTR gctrPAndC = null;
    private GHASH ghashAllToS = null;
    private int processed = 0;
    private byte[] aadBufferSave = null;
    private int sizeOfAADSave = 0;
    private byte[] ibufferSave = null;
    private int processedSave = 0;

    static void increment32(byte[] byArray) {
        if (byArray.length != 16) {
            throw new ProviderException("Illegal counter block length");
        }
        int n = byArray.length - 1;
        while (n >= byArray.length - 4) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    private static byte[] getLengthBlock(int n) {
        long l = (long)n << 3;
        byte[] byArray = new byte[16];
        byArray[8] = (byte)(l >>> 56);
        byArray[9] = (byte)(l >>> 48);
        byArray[10] = (byte)(l >>> 40);
        byArray[11] = (byte)(l >>> 32);
        byArray[12] = (byte)(l >>> 24);
        byArray[13] = (byte)(l >>> 16);
        byArray[14] = (byte)(l >>> 8);
        byArray[15] = (byte)l;
        return byArray;
    }

    private static byte[] getLengthBlock(int n, int n2) {
        long l = (long)n << 3;
        long l2 = (long)n2 << 3;
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l, (byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
        return byArray;
    }

    private static byte[] expandToOneBlock(byte[] byArray, int n, int n2) {
        if (n2 > 16) {
            throw new ProviderException("input " + n2 + " too long");
        }
        if (n2 == 16 && n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static byte[] getJ0(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray.length == 12) {
            byArray3 = GaloisCounterMode.expandToOneBlock(byArray, 0, byArray.length);
            byArray3[15] = 1;
        } else {
            byte[] byArray4;
            GHASH gHASH = new GHASH(byArray2);
            int n = byArray.length % 16;
            if (n != 0) {
                gHASH.update(byArray, 0, byArray.length - n);
                byArray4 = GaloisCounterMode.expandToOneBlock(byArray, byArray.length - n, n);
                gHASH.update(byArray4);
            } else {
                gHASH.update(byArray);
            }
            byArray4 = GaloisCounterMode.getLengthBlock(byArray.length);
            gHASH.update(byArray4);
            byArray3 = gHASH.digest();
        }
        return byArray3;
    }

    private static void checkDataLength(int n, int n2) {
        if (n > Integer.MAX_VALUE - n2) {
            throw new ProviderException("SunJCE provider only supports input size up to 2147483647 bytes");
        }
    }

    GaloisCounterMode(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
        this.aadBuffer = new ByteArrayOutputStream();
    }

    @Override
    String getFeedback() {
        return "GCM";
    }

    @Override
    void reset() {
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        if (this.gctrPAndC != null) {
            this.gctrPAndC.reset();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.reset();
        }
        this.processed = 0;
        this.sizeOfAAD = 0;
        if (this.ibuffer != null) {
            this.ibuffer.reset();
        }
    }

    @Override
    void save() {
        this.processedSave = this.processed;
        this.sizeOfAADSave = this.sizeOfAAD;
        byte[] byArray = this.aadBufferSave = this.aadBuffer == null || this.aadBuffer.size() == 0 ? null : this.aadBuffer.toByteArray();
        if (this.gctrPAndC != null) {
            this.gctrPAndC.save();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.save();
        }
        if (this.ibuffer != null) {
            this.ibufferSave = this.ibuffer.toByteArray();
        }
    }

    @Override
    void restore() {
        this.processed = this.processedSave;
        this.sizeOfAAD = this.sizeOfAADSave;
        if (this.aadBuffer != null) {
            this.aadBuffer.reset();
            if (this.aadBufferSave != null) {
                this.aadBuffer.write(this.aadBufferSave, 0, this.aadBufferSave.length);
            }
        }
        if (this.gctrPAndC != null) {
            this.gctrPAndC.restore();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.restore();
        }
        if (this.ibuffer != null) {
            this.ibuffer.reset();
            this.ibuffer.write(this.ibufferSave, 0, this.ibufferSave.length);
        }
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        this.init(bl, string, byArray, byArray2, DEFAULT_TAG_LEN);
    }

    void init(boolean bl, String string, byte[] byArray, byte[] byArray2, int n) throws InvalidKeyException {
        if (byArray == null || byArray2 == null) {
            throw new InvalidKeyException("Internal error");
        }
        this.embeddedCipher.init(false, string, byArray);
        this.subkeyH = new byte[16];
        this.embeddedCipher.encryptBlock(new byte[16], 0, this.subkeyH, 0);
        this.iv = (byte[])byArray2.clone();
        this.preCounterBlock = GaloisCounterMode.getJ0(this.iv, this.subkeyH);
        byte[] byArray3 = (byte[])this.preCounterBlock.clone();
        GaloisCounterMode.increment32(byArray3);
        this.gctrPAndC = new GCTR(this.embeddedCipher, byArray3);
        this.ghashAllToS = new GHASH(this.subkeyH);
        this.tagLenBytes = n;
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        this.processed = 0;
        this.sizeOfAAD = 0;
        if (bl) {
            this.ibuffer = new ByteArrayOutputStream();
        }
    }

    @Override
    void updateAAD(byte[] byArray, int n, int n2) {
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(byArray, n, n2);
    }

    void processAAD() {
        if (this.aadBuffer != null) {
            if (this.aadBuffer.size() > 0) {
                byte[] byArray = this.aadBuffer.toByteArray();
                this.sizeOfAAD = byArray.length;
                int n = byArray.length % 16;
                if (n != 0) {
                    this.ghashAllToS.update(byArray, 0, byArray.length - n);
                    byte[] byArray2 = GaloisCounterMode.expandToOneBlock(byArray, byArray.length - n, n);
                    this.ghashAllToS.update(byArray2);
                } else {
                    this.ghashAllToS.update(byArray);
                }
            }
            this.aadBuffer = null;
        }
    }

    void doLastBlock(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalBlockSizeException {
        int n4;
        byte[] byArray3;
        this.gctrPAndC.doFinal(byArray, n, n2, byArray2, n3);
        this.processed += n2;
        if (bl) {
            byArray3 = byArray2;
            n4 = n3;
        } else {
            byArray3 = byArray;
            n4 = n;
        }
        int n5 = n2 % 16;
        if (n5 != 0) {
            this.ghashAllToS.update(byArray3, n4, n2 - n5);
            byte[] byArray4 = GaloisCounterMode.expandToOneBlock(byArray3, n4 + n2 - n5, n5);
            this.ghashAllToS.update(byArray4);
        } else {
            this.ghashAllToS.update(byArray3, n4, n2);
        }
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        GaloisCounterMode.checkDataLength(this.processed, n2);
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        this.processAAD();
        if (n2 > 0) {
            this.gctrPAndC.update(byArray, n, n2, byArray2, n3);
            this.processed += n2;
            this.ghashAllToS.update(byArray2, n3, n2);
        }
        return n2;
    }

    @Override
    int encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException {
        if (n2 > Integer.MAX_VALUE - this.tagLenBytes) {
            throw new ShortBufferException("Can't fit both data and tag into one buffer");
        }
        if (byArray2.length - n3 < n2 + this.tagLenBytes) {
            throw new ShortBufferException("Output buffer too small");
        }
        GaloisCounterMode.checkDataLength(this.processed, n2);
        this.processAAD();
        if (n2 > 0) {
            this.doLastBlock(byArray, n, n2, byArray2, n3, true);
        }
        byte[] byArray3 = GaloisCounterMode.getLengthBlock(this.sizeOfAAD, this.processed);
        this.ghashAllToS.update(byArray3);
        byte[] byArray4 = this.ghashAllToS.digest();
        byte[] byArray5 = new byte[byArray4.length];
        GCTR gCTR = new GCTR(this.embeddedCipher, this.preCounterBlock);
        gCTR.doFinal(byArray4, 0, byArray4.length, byArray5, 0);
        System.arraycopy(byArray5, 0, byArray2, n3 + n2, this.tagLenBytes);
        return n2 + this.tagLenBytes;
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        GaloisCounterMode.checkDataLength(this.ibuffer.size(), n2);
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        this.processAAD();
        if (n2 > 0) {
            this.ibuffer.write(byArray, n, n2);
        }
        return 0;
    }

    @Override
    int decryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        if (n2 < this.tagLenBytes) {
            throw new AEADBadTagException("Input too short - need tag");
        }
        GaloisCounterMode.checkDataLength(this.ibuffer.size(), n2 - this.tagLenBytes);
        if (byArray2.length - n3 < this.ibuffer.size() + n2 - this.tagLenBytes) {
            throw new ShortBufferException("Output buffer too small");
        }
        this.processAAD();
        byte[] byArray3 = new byte[this.tagLenBytes];
        System.arraycopy(byArray, n + n2 - this.tagLenBytes, byArray3, 0, this.tagLenBytes);
        if ((n2 -= this.tagLenBytes) != 0) {
            this.ibuffer.write(byArray, n, n2);
        }
        byArray = this.ibuffer.toByteArray();
        n = 0;
        n2 = byArray.length;
        this.ibuffer.reset();
        if (n2 > 0) {
            this.doLastBlock(byArray, n, n2, byArray2, n3, false);
        }
        byte[] byArray4 = GaloisCounterMode.getLengthBlock(this.sizeOfAAD, this.processed);
        this.ghashAllToS.update(byArray4);
        byte[] byArray5 = this.ghashAllToS.digest();
        byte[] byArray6 = new byte[byArray5.length];
        GCTR gCTR = new GCTR(this.embeddedCipher, this.preCounterBlock);
        gCTR.doFinal(byArray5, 0, byArray5.length, byArray6, 0);
        int n4 = 0;
        for (int i = 0; i < this.tagLenBytes; ++i) {
            n4 |= byArray3[i] ^ byArray6[i];
        }
        if (n4 != 0) {
            throw new AEADBadTagException("Tag mismatch!");
        }
        return n2;
    }

    int getTagLen() {
        return this.tagLenBytes;
    }

    @Override
    int getBufferedLength() {
        if (this.ibuffer == null) {
            return 0;
        }
        return this.ibuffer.size();
    }
}

