/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObjectList;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class TeXReader
implements Readable,
Closeable {
    private Reader reader;
    private TeXReader parent;
    private Object source;
    private TeXObjectList pending;

    public TeXReader(TeXReader teXReader, String string) throws IOException {
        this.parent = teXReader;
        this.source = string;
        this.reader = new StringReader(string);
    }

    public TeXReader(String string) throws IOException {
        this(null, string);
    }

    public TeXReader(TeXReader teXReader, File file, Charset charset) throws IOException {
        this.parent = teXReader;
        this.source = file;
        this.reader = charset == null ? new LineNumberReader(new FileReader(file)) : new LineNumberReader(new LineNumberReader(Files.newBufferedReader(file.toPath(), charset)));
    }

    public TeXReader(TeXReader teXReader, File file) throws IOException {
        this(teXReader, file, null);
    }

    public TeXReader(File file) throws IOException {
        this(null, file, null);
    }

    public int getLineNumber() {
        if (this.reader instanceof LineNumberReader) {
            return ((LineNumberReader)this.reader).getLineNumber();
        }
        return -1;
    }

    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public int read() throws IOException {
        return this.reader.read();
    }

    public int read(char[] cArray) throws IOException {
        return this.reader.read(cArray);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.reader.read(cArray, n, n2);
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        return this.reader.read(charBuffer);
    }

    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public Object getSource() {
        return this.source;
    }

    public TeXReader getParent() {
        return this.parent;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setParent(TeXReader teXReader) {
        if (this == teXReader) {
            throw new IllegalArgumentException("Reader can't be its own parent");
        }
        this.parent = teXReader;
    }

    public String toString() {
        return "TeXReader[reader:" + this.reader + ",source:" + this.source + ",parent=" + this.parent + "]";
    }

    public void setPending(TeXObjectList teXObjectList) {
        this.pending = teXObjectList;
    }

    public TeXObjectList getPending() {
        return this.pending;
    }
}

