/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXCellAlignList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.awt.Color;
import java.util.Hashtable;

public class TeXSettings {
    private TeXSettings parent;
    public static final int INHERIT = -1;
    public static final int USER = -2;
    public static final int FAMILY_RM = 0;
    public static final int FAMILY_SF = 1;
    public static final int FAMILY_TT = 2;
    public static final int FAMILY_CAL = 3;
    public static final int SHAPE_UP = 0;
    public static final int SHAPE_IT = 1;
    public static final int SHAPE_SL = 2;
    public static final int SHAPE_EM = 3;
    public static final int SHAPE_SC = 4;
    public static final int WEIGHT_MD = 0;
    public static final int WEIGHT_BF = 1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_XLARGE = 2;
    public static final int SIZE_XXLARGE = 3;
    public static final int SIZE_HUGE = 4;
    public static final int SIZE_XHUGE = 5;
    public static final int SIZE_XXHUGE = 6;
    public static final int SIZE_SMALL = 7;
    public static final int SIZE_FOOTNOTE = 8;
    public static final int SIZE_SCRIPT = 9;
    public static final int SIZE_TINY = 10;
    public static final int MATH_STYLE_RM = 0;
    public static final int MATH_STYLE_SF = 1;
    public static final int MATH_STYLE_TT = 2;
    public static final int MATH_STYLE_IT = 3;
    public static final int MATH_STYLE_BF = 4;
    public static final int MATH_STYLE_CAL = 5;
    public static final int MATH_STYLE_BB = 6;
    public static final int MATH_STYLE_FRAK = 7;
    public static final int MATH_STYLE_BOLDSYMBOL = 8;
    public static final int MATH_STYLE_PMB = 9;
    public static final int MATH_STYLE_NORMAL = 10;
    public static final int PAR_ALIGN_NORMAL = 0;
    public static final int PAR_ALIGN_LEFT = 1;
    public static final int PAR_ALIGN_RIGHT = 2;
    public static final int PAR_ALIGN_CENTER = 3;
    public static final int MODE_TEXT = 0;
    public static final int MODE_INLINE_MATH = 1;
    public static final int MODE_DISPLAY_MATH = 2;
    public static final int CHAR_MAP_OFF = 0;
    public static final int CHAR_MAP_ON = 1;
    public static final int ALIGN_MODE_FALSE = 0;
    public static final int ALIGN_MODE_TRUE = 1;
    public static final int START_ROW_MODE_FALSE = 0;
    public static final int START_ROW_MODE_TRUE = 1;
    public static final int START_COLUMN_MODE_FALSE = 0;
    public static final int START_COLUMN_MODE_TRUE = 1;
    public static final int[][] BLACKBOARD_BOLD = new int[][]{{67, 8450}, {72, 8461}, {78, 8469}, {80, 8473}, {81, 8474}, {82, 8477}, {90, 8484}, {68, 8517}, {100, 8518}, {101, 8519}, {105, 8520}, {106, 8521}, {65, 120120}, {66, 120121}, {68, 120123}, {69, 120124}, {70, 120125}, {71, 120126}, {73, 120128}, {74, 120129}, {75, 120130}, {76, 120131}, {76, 120132}, {76, 120134}, {83, 120138}, {84, 120139}, {85, 120140}, {86, 120141}, {87, 120142}, {88, 120143}, {89, 120144}, {97, 120146}, {98, 120146}, {99, 120147}, {100, 120149}, {101, 120150}, {102, 120151}, {103, 120152}, {104, 120153}, {105, 120154}, {106, 120155}, {107, 120156}, {108, 120157}, {109, 120158}, {110, 120159}, {111, 120160}, {112, 120161}, {113, 120162}, {114, 120163}, {115, 120164}, {116, 120165}, {117, 120166}, {118, 120167}, {119, 120168}, {120, 120169}, {121, 120170}, {122, 120171}, {48, 120792}, {49, 120793}, {50, 120794}, {51, 120795}, {52, 120796}, {53, 120797}, {54, 120798}, {55, 120799}, {56, 120800}, {57, 120801}, {120587, 8508}, {120574, 8509}, {120548, 8510}, {120561, 8511}, {120564, 8512}};
    public static final int[][] FRAKTUR = new int[][]{{65, 120068}, {66, 120069}, {68, 120071}, {69, 120072}, {70, 120073}, {71, 120074}, {74, 120077}, {75, 120078}, {76, 120079}, {77, 120080}, {78, 120081}, {79, 120082}, {80, 120083}, {81, 120084}, {83, 120086}, {84, 120087}, {85, 120088}, {86, 120089}, {87, 120090}, {88, 120091}, {89, 120092}, {97, 120094}, {98, 120095}, {99, 120096}, {100, 120097}, {101, 120098}, {102, 120099}, {103, 120100}, {104, 120101}, {105, 120102}, {106, 120103}, {107, 120104}, {108, 120105}, {109, 120106}, {110, 120107}, {111, 120108}, {112, 120109}, {113, 120110}, {114, 120111}, {115, 120112}, {116, 120113}, {116, 120113}, {117, 120114}, {118, 120115}, {119, 120116}, {120, 120117}, {121, 120118}, {122, 120119}};
    public static final int[][] FRAKTUR_BOLD = new int[][]{{65, 120172}, {66, 120173}, {67, 120174}, {68, 120175}, {69, 120176}, {70, 120177}, {71, 120178}, {72, 120179}, {73, 120180}, {74, 120181}, {75, 120182}, {76, 120183}, {77, 120184}, {78, 120185}, {79, 120186}, {80, 120187}, {81, 120188}, {82, 120189}, {83, 120190}, {84, 120191}, {85, 120192}, {86, 120193}, {87, 120194}, {88, 120195}, {89, 120196}, {90, 120197}, {97, 120198}, {98, 120199}, {99, 120200}, {100, 120201}, {101, 120202}, {102, 120203}, {103, 120204}, {104, 120205}, {105, 120206}, {106, 120207}, {107, 120208}, {108, 120209}, {109, 120210}, {110, 120211}, {111, 120212}, {112, 120213}, {113, 120214}, {114, 120215}, {115, 120216}, {116, 120217}, {117, 120218}, {118, 120219}, {119, 120220}, {120, 120221}, {121, 120222}, {122, 120223}};
    public static final int[][] MATHCALSCRIPT = new int[][]{{103, 8458}, {72, 8459}, {73, 8464}, {76, 8466}, {82, 8475}, {66, 8492}, {101, 8495}, {69, 8496}, {70, 8497}, {77, 8499}, {111, 8500}, {65, 119964}, {67, 119966}, {68, 119967}, {71, 119970}, {74, 119973}, {75, 119974}, {78, 119977}, {79, 119978}, {80, 119979}, {81, 119980}, {83, 119982}, {84, 119983}, {85, 119984}, {86, 119985}, {87, 119986}, {88, 119987}, {89, 119988}, {90, 119989}, {97, 119990}, {98, 119991}, {99, 119992}, {100, 119993}, {102, 119995}, {104, 119997}, {105, 119998}, {106, 119999}, {107, 120000}, {108, 120001}, {109, 120002}, {110, 120003}, {112, 120005}, {113, 120006}, {114, 120007}, {115, 120008}, {116, 120009}, {117, 120010}, {118, 120011}, {119, 120012}, {120, 120013}, {121, 120014}, {122, 120015}};
    public static final int[][] MATHCALSCRIPT_BOLD = new int[][]{{65, 120016}, {66, 120017}, {67, 120018}, {68, 120019}, {69, 120020}, {70, 120021}, {71, 120022}, {72, 120023}, {73, 120024}, {74, 120025}, {75, 120026}, {76, 120027}, {77, 120028}, {78, 120029}, {79, 120030}, {80, 120031}, {81, 120032}, {82, 120033}, {83, 120034}, {84, 120035}, {85, 120036}, {86, 120037}, {87, 120038}, {88, 120039}, {89, 120040}, {90, 120041}, {97, 120042}, {98, 120043}, {99, 120044}, {100, 120045}, {101, 120046}, {102, 120047}, {103, 120048}, {104, 120049}, {105, 120050}, {106, 120051}, {107, 120052}, {108, 120053}, {109, 120054}, {110, 120055}, {111, 120056}, {112, 120057}, {113, 120058}, {114, 120059}, {115, 120060}, {116, 120061}, {117, 120062}, {118, 120063}, {119, 120064}, {120, 120065}, {121, 120066}, {122, 120067}};
    public static final int[][] MATH_IT = new int[][]{{65, 119860}, {66, 119861}, {67, 119862}, {68, 119863}, {69, 119864}, {70, 119865}, {71, 119866}, {72, 119867}, {73, 119868}, {74, 119869}, {75, 119870}, {76, 119871}, {77, 119872}, {78, 119873}, {79, 119874}, {80, 119875}, {81, 119876}, {82, 119877}, {83, 119878}, {84, 119879}, {85, 119880}, {86, 119881}, {87, 119882}, {88, 119883}, {89, 119884}, {90, 119885}, {97, 119886}, {98, 119887}, {99, 119888}, {100, 119889}, {101, 119890}, {102, 119891}, {103, 119892}, {105, 119894}, {106, 119895}, {107, 119896}, {108, 119897}, {109, 119898}, {110, 119899}, {111, 119900}, {112, 119901}, {113, 119902}, {114, 119903}, {115, 119904}, {116, 119905}, {117, 119906}, {118, 119907}, {119, 119908}, {120, 119909}, {121, 119910}, {122, 119911}, {120546, 120546}, {120547, 120547}, {120548, 120548}, {120549, 120549}, {120550, 120550}, {120551, 120551}, {120552, 120552}, {120553, 120553}, {120554, 120554}, {120555, 120555}, {120556, 120556}, {120557, 120557}, {120558, 120558}, {120559, 120559}, {120560, 120560}, {120561, 120561}, {120562, 120562}, {120563, 120563}, {120564, 120564}, {120565, 120565}, {120566, 120566}, {120567, 120567}, {120568, 120568}, {120569, 120569}, {120570, 120570}, {120571, 8711}, {120572, 120572}, {120573, 120573}, {120574, 120574}, {120575, 120575}, {120576, 120576}, {120577, 120577}, {120578, 120578}, {120579, 120579}, {120580, 120580}, {120581, 120581}, {120582, 120582}, {120583, 120583}, {120584, 120584}, {120585, 120585}, {120586, 120586}, {120587, 120587}, {120588, 120588}, {120589, 120589}, {120590, 120590}, {120591, 120591}, {120592, 120592}, {120593, 120593}, {120594, 120594}, {120595, 120595}, {120596, 120596}, {120597, 120597}, {120598, 120598}, {120599, 120599}, {120600, 120600}, {120601, 120601}, {120602, 120602}, {120603, 120603}};
    public static final int[][] MATH_IT_BOLD = new int[][]{{65, 119912}, {66, 119913}, {67, 119914}, {68, 119915}, {69, 119916}, {70, 119917}, {71, 119918}, {72, 119919}, {73, 119920}, {74, 119921}, {75, 119922}, {76, 119923}, {77, 119924}, {78, 119925}, {79, 119926}, {80, 119927}, {81, 119928}, {82, 119929}, {83, 119930}, {84, 119931}, {85, 119932}, {86, 119933}, {87, 119934}, {88, 119935}, {89, 119936}, {90, 119937}, {97, 119938}, {98, 119939}, {99, 119940}, {100, 119941}, {101, 119942}, {102, 119943}, {103, 119944}, {104, 119945}, {105, 119946}, {106, 119947}, {107, 119948}, {108, 119949}, {109, 119950}, {110, 119951}, {111, 119952}, {112, 119953}, {113, 119954}, {114, 119955}, {115, 119956}, {116, 119957}, {117, 119958}, {118, 119959}, {119, 119960}, {120, 119961}, {121, 119962}, {122, 119963}, {120546, 120604}, {120547, 120605}, {120548, 120606}, {120549, 120607}, {120550, 120608}, {120551, 120609}, {120552, 120610}, {120553, 120611}, {120554, 120612}, {120555, 120613}, {120556, 120614}, {120557, 120615}, {120558, 120616}, {120559, 120617}, {120560, 120618}, {120561, 120619}, {120562, 120620}, {120563, 120621}, {120564, 120622}, {120565, 120623}, {120566, 120624}, {120567, 120625}, {120568, 120626}, {120569, 120627}, {120570, 120628}, {120571, 120629}, {120572, 120630}, {120573, 120631}, {120574, 120632}, {120575, 120633}, {120576, 120634}, {120577, 120635}, {120578, 120636}, {120579, 120637}, {120580, 120638}, {120581, 120639}, {120582, 120640}, {120583, 120641}, {120584, 120642}, {120585, 120643}, {120586, 120644}, {120587, 120645}, {120588, 120646}, {120589, 120647}, {120590, 120648}, {120591, 120649}, {120592, 120650}, {120593, 120651}, {120594, 120652}, {120595, 120653}, {120596, 120654}, {120597, 120655}, {120598, 120656}, {120599, 120657}, {120600, 120658}, {120601, 120659}, {120602, 120660}, {120603, 120661}};
    public static final int[][] MATH_UP_BOLD = new int[][]{{65, 119808}, {66, 119809}, {67, 119810}, {68, 119811}, {69, 119812}, {70, 119813}, {71, 119814}, {72, 119815}, {73, 119816}, {74, 119817}, {75, 119818}, {76, 119819}, {77, 119820}, {78, 119821}, {79, 119822}, {80, 119823}, {81, 119824}, {82, 119825}, {83, 119826}, {84, 119827}, {85, 119828}, {86, 119829}, {87, 119830}, {88, 119831}, {89, 119832}, {90, 119833}, {97, 119834}, {98, 119835}, {99, 119836}, {100, 119837}, {101, 119838}, {102, 119839}, {103, 119840}, {104, 119841}, {105, 119842}, {106, 119843}, {107, 119844}, {108, 119845}, {109, 119846}, {110, 119847}, {111, 119848}, {112, 119849}, {113, 119850}, {114, 119851}, {115, 119852}, {116, 119853}, {117, 119854}, {118, 119855}, {119, 119856}, {120, 119857}, {121, 119858}, {122, 119859}, {48, 120782}, {49, 120783}, {50, 120784}, {51, 120785}, {52, 120786}, {53, 120787}, {54, 120788}, {55, 120789}, {56, 120790}, {57, 120791}, {120546, 120488}, {120547, 120489}, {120548, 120490}, {120549, 120491}, {120550, 120492}, {120551, 120493}, {120552, 120494}, {120553, 120495}, {120554, 120496}, {120555, 120497}, {120556, 120498}, {120557, 120499}, {120558, 120500}, {120559, 120501}, {120560, 120502}, {120561, 120503}, {120562, 120504}, {120563, 120505}, {120564, 120506}, {120565, 120507}, {120566, 120508}, {120567, 120509}, {120568, 120510}, {120569, 120511}, {120570, 120512}, {120571, 120513}, {120572, 120514}, {120573, 120515}, {120574, 120516}, {120575, 120517}, {120576, 120518}, {120577, 120519}, {120578, 120520}, {120579, 120521}, {120580, 120522}, {120581, 120523}, {120582, 120524}, {120583, 120525}, {120584, 120526}, {120585, 120527}, {120586, 120528}, {120587, 120529}, {120588, 120530}, {120589, 120531}, {120590, 120532}, {120591, 120533}, {120592, 120534}, {120593, 120535}, {120594, 120536}, {120595, 120537}, {120596, 120538}, {120597, 120539}, {120598, 120540}, {120599, 120541}, {120600, 120542}, {120601, 120543}, {120602, 120544}, {120603, 120545}};
    public static final int[][] MATH_UP_SF = new int[][]{{65, 120224}, {66, 120225}, {67, 120226}, {68, 120227}, {69, 120228}, {70, 120229}, {71, 120230}, {72, 120231}, {73, 120232}, {74, 120233}, {75, 120234}, {76, 120235}, {77, 120236}, {78, 120237}, {79, 120238}, {80, 120239}, {81, 120240}, {82, 120241}, {83, 120242}, {84, 120243}, {85, 120244}, {86, 120245}, {87, 120246}, {88, 120247}, {89, 120248}, {90, 120249}, {97, 120250}, {98, 120251}, {99, 120252}, {100, 120253}, {101, 120254}, {102, 120255}, {103, 120256}, {104, 120257}, {105, 120258}, {106, 120259}, {107, 120260}, {108, 120261}, {109, 120262}, {110, 120263}, {111, 120264}, {112, 120265}, {113, 120266}, {114, 120267}, {115, 120268}, {116, 120269}, {117, 120270}, {118, 120271}, {119, 120272}, {120, 120273}, {121, 120274}, {122, 120275}, {48, 120802}, {49, 120803}, {50, 120804}, {51, 120805}, {52, 120806}, {53, 120807}, {54, 120808}, {55, 120809}, {56, 120810}, {57, 120811}};
    public static final int[][] MATH_UP_BOLD_SF = new int[][]{{65, 120276}, {66, 120277}, {67, 120278}, {68, 120279}, {69, 120280}, {70, 120281}, {71, 120282}, {72, 120283}, {73, 120284}, {74, 120285}, {75, 120286}, {76, 120287}, {77, 120288}, {78, 120289}, {79, 120290}, {80, 120291}, {81, 120292}, {82, 120293}, {83, 120294}, {84, 120295}, {85, 120296}, {86, 120297}, {87, 120298}, {88, 120299}, {89, 120300}, {90, 120301}, {97, 120302}, {98, 120303}, {99, 120304}, {100, 120305}, {101, 120306}, {102, 120307}, {103, 120308}, {104, 120309}, {105, 120310}, {106, 120311}, {107, 120312}, {108, 120313}, {109, 120314}, {110, 120315}, {111, 120316}, {112, 120317}, {113, 120318}, {114, 120319}, {115, 120320}, {116, 120321}, {117, 120322}, {118, 120323}, {119, 120324}, {120, 120325}, {121, 120326}, {122, 120327}, {48, 120812}, {49, 120813}, {50, 120814}, {51, 120815}, {52, 120816}, {53, 120817}, {54, 120818}, {55, 120819}, {56, 120820}, {57, 120821}, {120546, 120662}, {120547, 120663}, {120548, 120664}, {120549, 120665}, {120550, 120666}, {120551, 120667}, {120552, 120668}, {120553, 120669}, {120554, 120670}, {120555, 120671}, {120556, 120672}, {120557, 120673}, {120558, 120674}, {120559, 120675}, {120560, 120676}, {120561, 120677}, {120562, 120678}, {120563, 120679}, {120564, 120680}, {120565, 120681}, {120566, 120682}, {120567, 120683}, {120568, 120684}, {120569, 120685}, {120570, 120686}, {120571, 120687}, {120572, 120688}, {120573, 120689}, {120574, 120690}, {120575, 120691}, {120576, 120692}, {120577, 120693}, {120578, 120694}, {120579, 120695}, {120580, 120696}, {120581, 120697}, {120582, 120698}, {120583, 120699}, {120584, 120700}, {120585, 120701}, {120586, 120702}, {120587, 120703}, {120588, 120704}, {120589, 120705}, {120590, 120706}, {120591, 120707}, {120592, 120708}, {120593, 120709}, {120594, 120710}, {120595, 120711}, {120596, 120712}, {120597, 120713}, {120598, 120714}, {120599, 120715}, {120600, 120716}, {120601, 120717}, {120602, 120718}, {120603, 120719}};
    public static final int[][] MATH_IT_SF = new int[][]{{65, 120328}, {66, 120329}, {67, 120330}, {68, 120331}, {69, 120332}, {70, 120333}, {71, 120334}, {72, 120335}, {73, 120336}, {74, 120337}, {75, 120338}, {76, 120339}, {77, 120340}, {78, 120341}, {79, 120342}, {80, 120343}, {81, 120344}, {82, 120345}, {83, 120346}, {84, 120347}, {85, 120348}, {86, 120349}, {87, 120350}, {88, 120351}, {89, 120352}, {90, 120353}, {97, 120354}, {98, 120355}, {99, 120356}, {100, 120357}, {101, 120358}, {102, 120359}, {103, 120360}, {104, 120361}, {105, 120362}, {106, 120363}, {107, 120364}, {108, 120365}, {109, 120366}, {110, 120367}, {111, 120368}, {112, 120369}, {113, 120370}, {114, 120371}, {115, 120372}, {116, 120373}, {117, 120374}, {118, 120375}, {119, 120376}, {120, 120377}, {121, 120378}, {122, 120379}};
    public static final int[][] MATH_IT_BOLD_SF = new int[][]{{65, 120380}, {66, 120381}, {67, 120382}, {68, 120383}, {69, 120384}, {70, 120385}, {71, 120386}, {72, 120387}, {73, 120388}, {74, 120389}, {75, 120390}, {76, 120391}, {77, 120392}, {78, 120393}, {79, 120394}, {80, 120395}, {81, 120396}, {82, 120397}, {83, 120398}, {84, 120399}, {85, 120400}, {86, 120401}, {87, 120402}, {88, 120403}, {89, 120404}, {90, 120405}, {97, 120406}, {98, 120407}, {99, 120408}, {100, 120409}, {101, 120410}, {102, 120411}, {103, 120412}, {104, 120413}, {105, 120414}, {106, 120415}, {107, 120416}, {108, 120417}, {109, 120418}, {110, 120419}, {111, 120420}, {112, 120421}, {113, 120422}, {114, 120423}, {115, 120424}, {116, 120425}, {117, 120426}, {118, 120427}, {119, 120428}, {120, 120429}, {121, 120430}, {122, 120431}, {120546, 120720}, {120547, 120721}, {120548, 120722}, {120549, 120723}, {120550, 120724}, {120551, 120725}, {120552, 120726}, {120553, 120727}, {120554, 120728}, {120555, 120729}, {120556, 120730}, {120557, 120731}, {120558, 120732}, {120559, 120733}, {120560, 120734}, {120561, 120735}, {120562, 120736}, {120563, 120737}, {120564, 120738}, {120565, 120739}, {120566, 120740}, {120567, 120741}, {120568, 120742}, {120569, 120743}, {120570, 120744}, {120571, 120745}, {120572, 120746}, {120573, 120747}, {120574, 120748}, {120575, 120749}, {120576, 120750}, {120577, 120751}, {120578, 120752}, {120579, 120753}, {120580, 120754}, {120581, 120755}, {120582, 120756}, {120583, 120757}, {120584, 120758}, {120585, 120759}, {120586, 120760}, {120587, 120761}, {120588, 120762}, {120589, 120763}, {120590, 120764}, {120591, 120765}, {120592, 120766}, {120593, 120767}, {120594, 120768}, {120595, 120769}, {120596, 120770}, {120597, 120771}, {120598, 120772}, {120599, 120773}, {120600, 120774}, {120601, 120775}, {120602, 120776}, {120603, 120777}};
    public static final int[][] MATH_TT = new int[][]{{65, 120432}, {66, 120433}, {67, 120434}, {68, 120435}, {69, 120436}, {70, 120437}, {71, 120438}, {72, 120439}, {73, 120440}, {74, 120441}, {75, 120442}, {76, 120443}, {77, 120444}, {78, 120445}, {79, 120446}, {80, 120447}, {81, 120448}, {82, 120449}, {83, 120450}, {84, 120451}, {85, 120452}, {86, 120453}, {87, 120454}, {88, 120455}, {89, 120456}, {90, 120457}, {97, 120458}, {98, 120459}, {99, 120460}, {100, 120461}, {101, 120462}, {102, 120463}, {103, 120464}, {104, 120465}, {105, 120466}, {106, 120467}, {107, 120468}, {108, 120469}, {109, 120470}, {110, 120471}, {111, 120472}, {112, 120473}, {113, 120474}, {114, 120475}, {115, 120476}, {116, 120477}, {117, 120478}, {118, 120479}, {119, 120480}, {120, 120481}, {121, 120482}, {122, 120483}, {48, 120822}, {49, 120823}, {50, 120824}, {51, 120825}, {52, 120826}, {53, 120827}, {54, 120828}, {55, 120829}, {56, 120830}, {57, 120831}};
    private int currentFontFamily = -1;
    private int currentFontShape = -1;
    private int currentFontWeight = -1;
    private int currentFontSize = -1;
    private int currentMathFont = -1;
    private int currentParAlign = -1;
    private int currentMode = -1;
    private int currentCharMapMode = -1;
    private int currentAlignMode = -1;
    private int currentStartRowMode = -1;
    private int currentStartColumnMode = -1;
    private int currentAlignmentColumn = -1;
    private TeXCellAlignList currentAlignmentList = null;
    private Color currentFgColor = null;
    private Color currentBgColor = null;
    private TeXParser parser;
    private Hashtable<String, Register> localRegisters = new Hashtable();
    protected Hashtable<String, ControlSequence> csTable;
    protected Hashtable<Integer, ActiveChar> activeTable = new Hashtable();

    private TeXSettings() {
        this.csTable = new Hashtable();
    }

    public TeXSettings(TeXParser teXParser) {
        this(null, teXParser);
    }

    public TeXSettings(TeXSettings teXSettings, TeXParser teXParser) {
        this();
        this.parent = teXSettings;
        this.parser = teXParser;
    }

    public TeXSettings getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getMode() {
        if (this.currentMode == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getMode();
        }
        return this.currentMode;
    }

    public void setMode(int n) {
        if (n == -1 || n == 0 || n == 1 || n == 2) {
            this.currentMode = n;
            return;
        }
        throw new IllegalArgumentException("Invalid argument '" + n + "' for setMode(int)");
    }

    public int getCurrentCharMapMode() {
        return this.currentCharMapMode;
    }

    public int getCharMapMode() {
        if (this.currentCharMapMode == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getCharMapMode();
        }
        return this.currentCharMapMode;
    }

    public void setCharMapMode(int n) {
        if (n == -1 || n == 0 || n == 1) {
            this.currentCharMapMode = n;
            return;
        }
        throw new IllegalArgumentException("Invalid argument '" + n + "' for setCharMapMode(int)");
    }

    public int getCurrentFontFamily() {
        return this.currentFontFamily;
    }

    public int getFontFamily() {
        if (this.currentFontFamily == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getFontFamily();
        }
        return this.currentFontFamily;
    }

    public int getCurrentFontShape() {
        return this.currentFontShape;
    }

    public int getFontShape() {
        if (this.currentFontShape == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getFontShape();
        }
        return this.currentFontShape;
    }

    public int getCurrentFontWeight() {
        return this.currentFontWeight;
    }

    public int getFontWeight() {
        if (this.currentFontWeight == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getFontWeight();
        }
        return this.currentFontWeight;
    }

    public int getCurrentFontSize() {
        return this.currentFontSize;
    }

    public int getFontSize() {
        if (this.currentFontSize == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getFontSize();
        }
        return this.currentFontSize;
    }

    public int getCurrentMathFont() {
        return this.currentMathFont;
    }

    public int getMathFont() {
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return 10;
            }
            return this.parent.getMathFont();
        }
        return this.currentMathFont;
    }

    public int getCurrentParAlign() {
        return this.currentParAlign;
    }

    public int getParAlign() {
        if (this.currentParAlign == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getParAlign();
        }
        return this.currentParAlign;
    }

    public int getCurrentAlignMode() {
        return this.currentAlignMode;
    }

    public int getAlignMode() {
        if (this.currentAlignMode == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getAlignMode();
        }
        return this.currentAlignMode;
    }

    public void setAlignMode(int n) {
        if (n == -1 || n == 0 || n == 1) {
            this.currentAlignMode = n;
            return;
        }
        throw new IllegalArgumentException("Invalid argument '" + n + "' for setAlignMode(int)");
    }

    public void endAlignment() {
        this.setAlignMode(0);
        this.setStartRowMode(0);
        this.setStartColumnMode(0);
    }

    public void startAlignment() {
        this.setAlignMode(1);
        this.startRow();
    }

    public void startRow() {
        this.setStartRowMode(1);
        this.startColumn();
        this.resetAlignmentColumn();
    }

    public void startColumn() {
        this.setStartColumnMode(1);
    }

    public int getCurrentStartRowMode() {
        return this.currentStartRowMode;
    }

    public int getStartRowMode() {
        if (this.currentStartRowMode == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getStartRowMode();
        }
        return this.currentStartRowMode;
    }

    public void setStartRowMode(int n) {
        if (n == -1 || n == 0 || n == 1) {
            this.currentStartRowMode = n;
            if (n == 1) {
                this.resetAlignmentColumn();
                this.setStartColumnMode(1);
            }
            return;
        }
        throw new IllegalArgumentException("Invalid argument '" + n + "' for setStartRowMode(int)");
    }

    public int getCurrentStartColumnMode() {
        return this.currentStartColumnMode;
    }

    public int getStartColumnMode() {
        if (this.currentStartColumnMode == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getStartColumnMode();
        }
        return this.currentStartColumnMode;
    }

    public void setStartColumnMode(int n) {
        if (n == -1 || n == 0 || n == 1) {
            this.currentStartColumnMode = n;
            if (n == 1) {
                this.incAlignmentColumn();
            }
            return;
        }
        throw new IllegalArgumentException("Invalid argument '" + n + "' for setStartColumnMode(int)");
    }

    public int getCurrentAlignmentColumn() {
        return this.currentAlignmentColumn;
    }

    public int getAlignmentColumn() {
        if (this.currentAlignmentColumn == -1) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getAlignmentColumn();
        }
        return this.currentAlignmentColumn;
    }

    public TeXCellAlignList getCurrentAlignmentList() {
        return this.currentAlignmentList;
    }

    public TeXCellAlignList getAlignmentList() {
        if (this.currentAlignmentList == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getAlignmentList();
        }
        return this.currentAlignmentList;
    }

    public void setAlignmentList(TeXCellAlignList teXCellAlignList) {
        this.currentAlignmentList = teXCellAlignList;
    }

    private void resetAlignmentColumn() {
        this.currentAlignmentColumn = 0;
    }

    private void incAlignmentColumn() {
        this.currentAlignmentColumn = this.getAlignmentColumn() + 1;
    }

    public int getCurrentAlignmentColumnCount() {
        return this.currentAlignmentList == null ? 0 : this.currentAlignmentList.size();
    }

    public int getAlignmentColumnCount() {
        if (this.currentAlignmentList == null) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getAlignmentColumnCount();
        }
        return this.getCurrentAlignmentColumnCount();
    }

    public Color getCurrentFgColor() {
        return this.currentFgColor;
    }

    public Color getFgColor() {
        if (this.currentFgColor == null) {
            if (this.parent == null) {
                return Color.black;
            }
            return this.parent.getFgColor();
        }
        return this.currentFgColor;
    }

    public void setFgColor(Color color) {
        this.currentFgColor = color;
    }

    public Color getCurrentBgColor() {
        return this.currentBgColor;
    }

    public Color getBgColor() {
        if (this.currentBgColor == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getBgColor();
        }
        return this.currentBgColor;
    }

    public void setBgColor(Color color) {
        this.currentBgColor = color;
    }

    public void setFontFamily(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.currentFontFamily = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setFontFamily(int)");
            }
        }
    }

    public void setFontShape(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.currentFontShape = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setFontShape(int)");
            }
        }
    }

    public void setFontWeight(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                this.currentFontWeight = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setFontWeight(int)");
            }
        }
    }

    public void setFontSize(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.currentFontSize = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setFontSize(int)");
            }
        }
    }

    public void setMathFont(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.currentMathFont = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setMathFont(int)");
            }
        }
    }

    public void setParAlign(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.currentParAlign = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid setting '" + n + "' for TeXSettings.setParAlign(int)");
            }
        }
    }

    public void setCurrentFgColor(Color color) {
        this.currentFgColor = color;
    }

    public void setCurrentBgColor(Color color) {
        this.currentBgColor = color;
    }

    public Register getRegister(String string) {
        Register register = this.localRegisters.get(string);
        if (register == null && this.parent != null) {
            register = this.parent.getRegister(string);
        }
        return register;
    }

    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.csTable.get(string);
        if (controlSequence == null) {
            controlSequence = this.localRegisters.get(string);
        }
        if (controlSequence == null && this.parent != null) {
            controlSequence = this.parent.getControlSequence(string);
        }
        return controlSequence;
    }

    public void putControlSequence(ControlSequence controlSequence) {
        this.csTable.put(controlSequence.getName(), controlSequence);
    }

    public ActiveChar getActiveChar(Integer n) {
        ActiveChar activeChar = this.activeTable.get(n);
        if (activeChar == null && this.parent != null) {
            activeChar = this.parent.getActiveChar(n);
        }
        return activeChar;
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.activeTable.put(new Integer(activeChar.getCharCode()), activeChar);
    }

    public ActiveChar removeActiveChar(int n) {
        return this.removeActiveChar(new Integer(n));
    }

    public ActiveChar removeActiveChar(Integer n) {
        ActiveChar activeChar = this.activeTable.remove(n);
        if (activeChar != null || this.parent == null) {
            return activeChar;
        }
        return this.parent.removeActiveChar(n);
    }

    public CountRegister countdef(String string, int n) {
        CountRegister countRegister = new CountRegister(string);
        this.parser.allocCount(n, countRegister);
        this.putRegister(countRegister);
        return countRegister;
    }

    public CountRegister newcount(boolean bl, String string) {
        if (bl || this.parent == null) {
            return this.newcount(string);
        }
        return this.parent.newcount(bl, string);
    }

    public CountRegister newcount(String string) {
        CountRegister countRegister = new CountRegister(string);
        this.parser.allocCount(countRegister);
        this.putRegister(countRegister);
        return countRegister;
    }

    public DimenRegister dimendef(String string, int n) {
        DimenRegister dimenRegister = new DimenRegister(string);
        this.parser.allocDimen(n, dimenRegister);
        this.putRegister(dimenRegister);
        return dimenRegister;
    }

    public DimenRegister newdimen(String string) {
        DimenRegister dimenRegister = new DimenRegister(string);
        this.parser.allocDimen(dimenRegister);
        this.putRegister(dimenRegister);
        return dimenRegister;
    }

    public DimenRegister newdimen(boolean bl, String string) {
        if (bl || this.parent == null) {
            return this.newdimen(string);
        }
        return this.parent.newdimen(bl, string);
    }

    protected Register putRegister(Register register) {
        Register register2;
        Register register3 = register;
        String string = register.getName();
        TeXSettings teXSettings = this.parser.getSettings();
        if (this != teXSettings && (register2 = teXSettings.getRegister(string)) == null) {
            register3 = teXSettings.putRegister((Register)register.clone());
        }
        this.localRegisters.put(string, register);
        return register3;
    }

    public void localSetRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.localRegisters.get(string);
        if (register == null) {
            if (this.parent != null) {
                register = this.parent.getRegister(string);
            }
            if (register == null) {
                throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
            }
            if (this.parent != null) {
                register = (Register)register.clone();
                this.localRegisters.put(string, register);
            }
        }
        register.setValue(this.parser, numerical);
    }

    public void globalSetRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.getRegister(string);
        if (register == null) {
            throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
        }
        register.setValue(this.parser, numerical);
        if (this.parent != null) {
            TeXSettings teXSettings = this.parent.getRoot();
            Register register2 = teXSettings.getRegister(string);
            if (register2 == null) {
                teXSettings.putRegister((Register)register.clone());
            } else if (register != register2) {
                register2.setValue(this.parser, register);
            }
        }
    }

    public void localAdvanceRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.localRegisters.get(string);
        if (register == null) {
            if (this.parent != null) {
                register = this.parent.getRegister(string);
            }
            if (register == null) {
                throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
            }
            if (this.parent != null) {
                register = (Register)register.clone();
                this.localRegisters.put(string, register);
            }
        }
        register.advance(this.parser, numerical);
    }

    public Register globalAdvanceRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.getRegister(string);
        if (register == null) {
            throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
        }
        register.advance(this.parser, numerical);
        if (this.parent != null) {
            TeXSettings teXSettings = this.parent.getRoot();
            Register register2 = teXSettings.getRegister(string);
            if (register2 == null) {
                teXSettings.putRegister((Register)register.clone());
            } else if (register != register2) {
                register2.setValue(this.parser, register);
            }
        }
        return register;
    }

    public void localMultiplyRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.localRegisters.get(string);
        if (register == null) {
            if (this.parent != null) {
                register = this.parent.getRegister(string);
            }
            if (register == null) {
                throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
            }
            if (this.parent != null) {
                register = (Register)register.clone();
                this.localRegisters.put(string, register);
            }
        }
        register.multiply(numerical.number(this.parser));
    }

    public void globalMultiplyRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.getRegister(string);
        if (register == null) {
            throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
        }
        register.multiply(numerical.number(this.parser));
        if (this.parent != null) {
            TeXSettings teXSettings = this.parent.getRoot();
            Register register2 = teXSettings.getRegister(string);
            if (register2 == null) {
                teXSettings.putRegister((Register)register.clone());
            } else if (register != register2) {
                register2.setValue(this.parser, register);
            }
        }
    }

    public void localDivideRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.localRegisters.get(string);
        if (register == null) {
            if (this.parent != null) {
                register = this.parent.getRegister(string);
            }
            if (register == null) {
                throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
            }
            if (this.parent != null) {
                register = (Register)register.clone();
                this.localRegisters.put(string, register);
            }
        }
        register.divide(numerical.number(this.parser));
    }

    public void globalDivideRegister(String string, Numerical numerical) throws TeXSyntaxException {
        Register register = this.getRegister(string);
        if (register == null) {
            throw new TeXSyntaxException(this.parser.getCurrentFile(), this.parser.getLineNumber(), "tex.error.register_undef", string);
        }
        register.divide(numerical.number(this.parser));
        if (this.parent != null) {
            TeXSettings teXSettings = this.parent.getRoot();
            Register register2 = teXSettings.getRegister(string);
            if (register2 == null) {
                teXSettings.putRegister((Register)register.clone());
            } else if (register != register2) {
                register2.setValue(this.parser, register);
            }
        }
    }

    private void removeLocalRegister(String string) {
        TeXSettings teXSettings = this.parser.getSettings();
        if (this == teXSettings || this.parent == null) {
            return;
        }
        this.localRegisters.remove(string);
        this.parent.removeLocalRegister(string);
    }

    public boolean isMathBold() {
        if (this.currentMathFont == 4 || this.currentMathFont == 8 || this.currentMathFont == 9) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathBold();
        }
        return false;
    }

    public boolean isMathSf() {
        if (this.currentMathFont == 1) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathSf();
        }
        return false;
    }

    public boolean isMathRm() {
        if (this.currentMathFont == 0) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathRm();
        }
        return false;
    }

    public boolean isMathTt() {
        if (this.currentMathFont == 2) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathTt();
        }
        return false;
    }

    public boolean isMathCal() {
        if (this.currentMathFont == 5) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathCal();
        }
        return false;
    }

    public boolean isMathFrak() {
        if (this.currentMathFont == 7) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathFrak();
        }
        return false;
    }

    public boolean isMathBb() {
        if (this.currentMathFont == 6) {
            return true;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isMathBb();
        }
        return false;
    }

    public boolean isMathIt() {
        if (this.currentMathFont == 0 || this.currentMathFont == 1 || this.currentMathFont == 2 || this.currentMathFont == 4 || this.currentMathFont == 5 || this.currentMathFont == 6) {
            return false;
        }
        if (this.currentMathFont == -1) {
            if (this.parent == null) {
                return true;
            }
            return this.parent.isMathIt();
        }
        return true;
    }

    public boolean isTextSansSerif() {
        if (this.currentFontFamily == 1) {
            return true;
        }
        if (this.currentFontFamily == -1) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isTextSansSerif();
        }
        return true;
    }

    public boolean isTextItalic() {
        if (this.currentFontShape == 1 || this.currentFontShape == 2) {
            return true;
        }
        if (this.currentFontShape == 3) {
            if (this.parent == null) {
                return true;
            }
            return !this.parent.isTextItalic();
        }
        if (this.currentFontShape == -1 && this.parent == null) {
            return false;
        }
        return false;
    }

    public int getCharCode(int n) {
        if (this.getCharMapMode() == 0) {
            return -1;
        }
        switch (this.getMode()) {
            case 0: {
                if (n == 39) {
                    return 8217;
                }
                return -1;
            }
            case 1: 
            case 2: {
                if (n == 45) {
                    n = 8722;
                } else if (n == 47) {
                    n = 8725;
                }
                if (this.isMathBb()) {
                    return TeXSettings.getCode(n, BLACKBOARD_BOLD);
                }
                if (this.isMathFrak()) {
                    if (this.isMathBold()) {
                        return TeXSettings.getCode(n, BLACKBOARD_BOLD);
                    }
                    return TeXSettings.getCode(n, FRAKTUR);
                }
                if (this.isMathCal()) {
                    if (this.isMathBold()) {
                        return TeXSettings.getCode(n, MATHCALSCRIPT_BOLD);
                    }
                    return TeXSettings.getCode(n, MATHCALSCRIPT);
                }
                if (this.isMathIt()) {
                    if (this.isMathBold()) {
                        if (this.isMathSf()) {
                            return TeXSettings.getCode(n, MATH_IT_BOLD_SF);
                        }
                        if (!this.isMathTt()) {
                            return TeXSettings.getCode(n, MATH_IT_BOLD);
                        }
                    }
                    if (this.isMathSf()) {
                        return TeXSettings.getCode(n, MATH_IT_SF);
                    }
                    if (this.isMathTt()) {
                        return TeXSettings.getCode(n, MATH_IT);
                    }
                }
                if (this.isMathSf()) {
                    if (this.isMathBold()) {
                        return TeXSettings.getCode(n, MATH_UP_BOLD_SF);
                    }
                    return TeXSettings.getCode(n, MATH_UP_SF);
                }
                if (this.isMathTt()) {
                    return TeXSettings.getCode(n, MATH_TT);
                }
                if (!this.isMathBold()) break;
                return TeXSettings.getCode(n, MATH_UP_BOLD);
            }
        }
        return -1;
    }

    public static int getCode(int n, int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] != n) continue;
            return nArray[i][1];
        }
        return -1;
    }

    public TeXSettings getParent() {
        return this.parent;
    }
}

