/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibData;
import java.io.IOException;

public class BibComment
extends BibData {
    private String entryType;
    private TeXObjectList contents;

    public BibComment() {
        this("comment");
    }

    public BibComment(String string) {
        this.entryType = string;
    }

    @Override
    public String getEntryType() {
        return this.entryType;
    }

    public TeXObjectList getContents() {
        return this.contents;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.contents = new TeXObjectList();
        while (teXObjectList.size() > 0) {
            this.contents.add(teXObjectList.popStack(teXParser));
        }
    }

    @Override
    public String format(byte by, char c, char c2, byte by2) {
        return String.format("@%s%c%s%c", BibComment.applyCase(this.entryType, by), Character.valueOf(c), this.contents.format(), Character.valueOf(c2));
    }

    public String toString() {
        return String.format("%s[type=%s,contents=%s]", this.getClass().getSimpleName(), this.entryType, this.contents);
    }
}

